/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAttributes
implements Attributes {
    private static final long serialVersionUID = 4980164073184639448L;
    private boolean ignoreCase;
    transient Vector<Attribute> attributes;

    public BasicAttributes() {
        this(false);
    }

    public BasicAttributes(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.attributes = new Vector();
    }

    public BasicAttributes(String attrID, Object val) {
        this(attrID, val, false);
    }

    public BasicAttributes(String attrID, Object val, boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.attributes = new Vector();
        this.attributes.add(new BasicAttribute(attrID, val));
    }

    @Override
    public Object clone() {
        BasicAttributes ba = new BasicAttributes(this.ignoreCase);
        ba.attributes = (Vector)this.attributes.clone();
        return ba;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Attributes)) {
            return false;
        }
        Attributes bs = (Attributes)obj;
        if (this.ignoreCase != bs.isCaseIgnored() || this.attributes.size() != bs.size()) {
            return false;
        }
        NamingEnumeration<? extends Attribute> bas = bs.getAll();
        while (bas.hasMoreElements()) {
            Attribute b;
            Attribute a = (Attribute)bas.nextElement();
            if (a.equals(b = this.get(a.getID()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Attribute get(String attrID) {
        int i = 0;
        while (i < this.attributes.size()) {
            Attribute at = this.attributes.get(i);
            if (this.ignoreCase && attrID.equalsIgnoreCase(at.getID()) || !this.ignoreCase && attrID.equals(at.getID())) {
                return at;
            }
            ++i;
        }
        return null;
    }

    public NamingEnumeration<Attribute> getAll() {
        return new BasicAttributesEnumeration();
    }

    @Override
    public NamingEnumeration<String> getIDs() {
        final NamingEnumeration<Attribute> attrs = this.getAll();
        return new NamingEnumeration<String>(){

            @Override
            public boolean hasMore() throws NamingException {
                return attrs.hasMore();
            }

            @Override
            public boolean hasMoreElements() {
                return attrs.hasMoreElements();
            }

            @Override
            public String next() throws NamingException {
                return ((Attribute)attrs.next()).getID();
            }

            @Override
            public String nextElement() {
                return ((Attribute)attrs.nextElement()).getID();
            }

            @Override
            public void close() throws NamingException {
                attrs.close();
            }
        };
    }

    public int hashCode() {
        int val = 0;
        int i = 0;
        while (i < this.attributes.size()) {
            val += this.attributes.get(i).hashCode();
            ++i;
        }
        return val;
    }

    @Override
    public boolean isCaseIgnored() {
        return this.ignoreCase;
    }

    @Override
    public Attribute put(Attribute attr) {
        Attribute r = this.remove(attr.getID());
        this.attributes.add(attr);
        return r;
    }

    @Override
    public Attribute put(String attrID, Object val) {
        return this.put(new BasicAttribute(attrID, val));
    }

    @Override
    public Attribute remove(String attrID) {
        int i = 0;
        while (i < this.attributes.size()) {
            Attribute at = this.attributes.get(i);
            if (this.ignoreCase && attrID.equalsIgnoreCase(at.getID()) || !this.ignoreCase && attrID.equals(at.getID())) {
                this.attributes.remove(i);
                return at;
            }
            ++i;
        }
        return null;
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    public String toString() {
        String r = "";
        int i = 0;
        while (i < this.attributes.size()) {
            if (i > 0) {
                r = String.valueOf(r) + "; ";
            }
            r = String.valueOf(r) + this.attributes.get(i).toString();
            ++i;
        }
        return r;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.attributes = new Vector(size);
        int i = 0;
        while (i < size) {
            this.attributes.add((Attribute)s.readObject());
            ++i;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.attributes.size());
        int i = 0;
        while (i < this.attributes.size()) {
            s.writeObject(this.attributes.get(i));
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BasicAttributesEnumeration
    implements NamingEnumeration<Attribute> {
        int where = 0;

        @Override
        public void close() throws NamingException {
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public Attribute next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public boolean hasMoreElements() {
            return this.where < BasicAttributes.this.attributes.size();
        }

        @Override
        public Attribute nextElement() throws NoSuchElementException {
            if (this.where >= BasicAttributes.this.attributes.size()) {
                throw new NoSuchElementException("no more elements");
            }
            Attribute at = BasicAttributes.this.attributes.get(this.where);
            ++this.where;
            return at;
        }
    }
}

