/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import java.lang.management.ThreadInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.SimpleType;

public class MemoryUsage {
    private long init;
    private long used;
    private long committed;
    private long maximum;

    public MemoryUsage(long init, long used, long committed, long maximum) {
        if (init < -1L) {
            throw new IllegalArgumentException("Initial value of " + init + " is too small.");
        }
        if (used < 0L) {
            throw new IllegalArgumentException("Used value of " + used + " is too small.");
        }
        if (committed < 0L) {
            throw new IllegalArgumentException("Committed value of " + committed + " is too small.");
        }
        if (committed < used) {
            throw new IllegalArgumentException("Committed value of " + committed + " is below " + used + ", the amount used.");
        }
        if (maximum < -1L) {
            throw new IllegalArgumentException("Maximum value of " + maximum + " is too small.");
        }
        if (maximum != -1L && maximum < committed) {
            throw new IllegalArgumentException("Maximum value of " + maximum + " is below " + committed + ", the amount " + "committed.");
        }
        this.init = init;
        this.used = used;
        this.committed = committed;
        this.maximum = maximum;
    }

    public static MemoryUsage from(CompositeData data) {
        if (data == null) {
            return null;
        }
        CompositeType type = data.getCompositeType();
        ThreadInfo.checkAttribute(type, "Init", SimpleType.LONG);
        ThreadInfo.checkAttribute(type, "Used", SimpleType.LONG);
        ThreadInfo.checkAttribute(type, "Committed", SimpleType.LONG);
        ThreadInfo.checkAttribute(type, "Max", SimpleType.LONG);
        return new MemoryUsage((Long)data.get("Init"), (Long)data.get("Used"), (Long)data.get("Committed"), (Long)data.get("Max"));
    }

    public long getCommitted() {
        return this.committed;
    }

    public long getInit() {
        return this.init;
    }

    public long getMax() {
        return this.maximum;
    }

    public long getUsed() {
        return this.used;
    }

    public String toString() {
        int megabyte = 0x100000;
        return String.valueOf(this.getClass().getName()) + "[init=" + this.init + " bytes (~" + this.init / (long)megabyte + "MB), used=" + this.used + " bytes (~" + this.used / (long)megabyte + "MB), committed=" + this.committed + " bytes (~" + this.committed / (long)megabyte + "MB), maximum=" + this.maximum + " bytes (~" + this.maximum / (long)megabyte + "MB)]";
    }
}

