/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class AffineTransformOp
implements BufferedImageOp,
RasterOp {
    public static final int TYPE_NEAREST_NEIGHBOR = 1;
    public static final int TYPE_BILINEAR = 2;
    public static final int TYPE_BICUBIC = 3;
    private AffineTransform transform;
    private RenderingHints hints;

    public AffineTransformOp(AffineTransform xform, int interpolationType) {
        this.transform = xform;
        if (xform.getDeterminant() == 0.0) {
            throw new ImagingOpException(null);
        }
        switch (interpolationType) {
            case 2: {
                this.hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                break;
            }
            case 3: {
                this.hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                break;
            }
            default: {
                this.hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            }
        }
    }

    public AffineTransformOp(AffineTransform xform, RenderingHints hints) {
        this.transform = xform;
        this.hints = hints;
        if (xform.getDeterminant() == 0.0) {
            throw new ImagingOpException(null);
        }
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        if (destCM != null) {
            return new BufferedImage(destCM, this.createCompatibleDestRaster(src.getRaster()), src.isAlphaPremultiplied(), null);
        }
        if (src.getType() == 3 || src.getType() == 6 || src.getType() == 7) {
            return new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
        }
        return new BufferedImage(src.getWidth(), src.getHeight(), 2);
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        Rectangle2D rect = this.getBounds2D(src);
        if (rect.getWidth() == 0.0 || rect.getHeight() == 0.0) {
            throw new RasterFormatException("width or height is 0");
        }
        return src.createCompatibleWritableRaster((int)rect.getWidth(), (int)rect.getHeight());
    }

    public final BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == src) {
            throw new IllegalArgumentException("src image cannot be the same as the dst image");
        }
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        Graphics2D gr = dst.createGraphics();
        gr.setRenderingHints(this.hints);
        gr.drawImage(src, this.transform, null);
        return dst;
    }

    public final WritableRaster filter(Raster src, WritableRaster dst) {
        if (dst == src) {
            throw new IllegalArgumentException("src image cannot be the same as the dst image");
        }
        if (dst == null) {
            dst = this.createCompatibleDestRaster(src);
        }
        if (src.getNumBands() != dst.getNumBands()) {
            throw new IllegalArgumentException("src and dst must have same number of bands");
        }
        if (ColorModel.getRGBdefault().isCompatibleSampleModel(src.getSampleModel()) && ColorModel.getRGBdefault().isCompatibleSampleModel(dst.getSampleModel())) {
            WritableRaster src2 = Raster.createWritableRaster(src.getSampleModel(), src.getDataBuffer(), new Point(src.getMinX(), src.getMinY()));
            BufferedImage iSrc = new BufferedImage(ColorModel.getRGBdefault(), src2, false, null);
            BufferedImage iDst = new BufferedImage(ColorModel.getRGBdefault(), dst, false, null);
            return this.filter(iSrc, iDst).getRaster();
        }
        double[] dstPts = new double[dst.getHeight() * dst.getWidth() * 2];
        double[] srcPts = new double[dst.getHeight() * dst.getWidth() * 2];
        int i = 0;
        int x = 0;
        while (x < dst.getWidth()) {
            int y = 0;
            while (y < dst.getHeight()) {
                dstPts[i++] = x;
                dstPts[i++] = y;
                ++y;
            }
            ++x;
        }
        src.getBounds();
        try {
            AffineTransform inverseTx = this.transform.createInverse();
            inverseTx.transform(dstPts, 0, srcPts, 0, dstPts.length / 2);
        }
        catch (NoninvertibleTransformException e) {
            throw new ImagingOpException(e.getMessage());
        }
        if (this.hints.containsValue(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR)) {
            this.filterNearest(src, dst, dstPts, srcPts);
        } else if (this.hints.containsValue(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
            this.filterBilinear(src, dst, dstPts, srcPts);
        } else {
            this.filterBicubic(src, dst, dstPts, srcPts);
        }
        return dst;
    }

    public final Rectangle2D getBounds2D(BufferedImage src) {
        return this.getBounds2D(src.getRaster());
    }

    public final Rectangle2D getBounds2D(Raster src) {
        return this.transform.createTransformedShape(src.getBounds()).getBounds2D();
    }

    public final int getInterpolationType() {
        if (this.hints.containsValue(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
            return 2;
        }
        if (this.hints.containsValue(RenderingHints.VALUE_INTERPOLATION_BICUBIC)) {
            return 3;
        }
        return 1;
    }

    public final Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return this.transform.transform(srcPt, dstPt);
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final AffineTransform getTransform() {
        return this.transform;
    }

    private void filterNearest(Raster src, WritableRaster dst, double[] dpts, double[] pts) {
        Rectangle srcbounds = src.getBounds();
        int i = 0;
        while (i < dpts.length) {
            int srcY;
            int srcX = (int)Math.round(pts[i]) + src.getMinX();
            if (srcbounds.contains(srcX, srcY = (int)Math.round(pts[i + 1]) + src.getMinY())) {
                dst.setDataElements((int)dpts[i] + dst.getMinX(), (int)dpts[i + 1] + dst.getMinY(), src.getDataElements(srcX, srcY, null));
            }
            i += 2;
        }
    }

    private void filterBilinear(Raster src, WritableRaster dst, double[] dpts, double[] pts) {
        Rectangle srcbounds = src.getBounds();
        Object[] xyarr = null;
        Object[] xp1arr = null;
        Object[] yp1arr = null;
        Object[] xyp1arr = null;
        double[] result = new double[src.getNumBands()];
        int i = 0;
        while (i < dpts.length) {
            int srcY;
            int srcX = (int)Math.round(pts[i]) + src.getMinX();
            if (srcbounds.contains(srcX, srcY = (int)Math.round(pts[i + 1]) + src.getMinY())) {
                if (pts[i] >= (double)(src.getWidth() - 1) || pts[i + 1] >= (double)(src.getHeight() - 1)) {
                    dst.setDataElements((int)dpts[i] + dst.getMinX(), (int)dpts[i + 1] + dst.getMinY(), src.getDataElements(srcX, srcY, null));
                } else {
                    int x = (int)Math.floor(pts[i] + (double)src.getMinX());
                    int y = (int)Math.floor(pts[i + 1] + (double)src.getMinY());
                    double xdiff = pts[i] + (double)src.getMinX() - (double)x;
                    double ydiff = pts[i + 1] + (double)src.getMinY() - (double)y;
                    if (src.getTransferType() == 5 || src.getTransferType() == 4) {
                        xyarr = src.getPixel(x, y, (double[])xyarr);
                        xp1arr = src.getPixel(x + 1, y, (double[])xp1arr);
                        yp1arr = src.getPixel(x, y + 1, (double[])yp1arr);
                        xyp1arr = src.getPixel(x + 1, y + 1, (double[])xyp1arr);
                    } else {
                        xyarr = src.getPixel(x, y, (int[])xyarr);
                        xp1arr = src.getPixel(x + 1, y, (int[])xp1arr);
                        yp1arr = src.getPixel(x, y + 1, (int[])yp1arr);
                        xyp1arr = src.getPixel(x + 1, y + 1, (int[])xyp1arr);
                    }
                    int j = 0;
                    while (j < src.getNumBands()) {
                        double xyp1;
                        double yp1;
                        double xp1;
                        double xy;
                        if (src.getTransferType() == 5 || src.getTransferType() == 4) {
                            xy = xyarr[j];
                            xp1 = xp1arr[j];
                            yp1 = yp1arr[j];
                            xyp1 = xyp1arr[j];
                        } else {
                            xy = ((int[])xyarr)[j];
                            xp1 = ((int[])xp1arr)[j];
                            yp1 = ((int[])yp1arr)[j];
                            xyp1 = ((int[])xyp1arr)[j];
                        }
                        result[j] = xy == xp1 && xy == yp1 && xy == xyp1 ? xy : (xy * (1.0 - xdiff) + xp1 * xdiff) * (1.0 - ydiff) + (yp1 * (1.0 - xdiff) + xyp1 * xdiff) * ydiff;
                        ++j;
                    }
                    dst.setPixel((int)dpts[i] + dst.getMinX(), (int)dpts[i + 1] + dst.getMinY(), result);
                }
            }
            i += 2;
        }
    }

    private void filterBicubic(Raster src, WritableRaster dst, double[] dpts, double[] pts) {
        Rectangle srcbounds = src.getBounds();
        double[] result = new double[src.getNumBands()];
        Object[] pixels = null;
        int i = 0;
        while (i < dpts.length) {
            if (srcbounds.contains((int)Math.round(pts[i]) + src.getMinX(), (int)Math.round(pts[i + 1]) + src.getMinY())) {
                int x = (int)Math.floor(pts[i] + (double)src.getMinX());
                int y = (int)Math.floor(pts[i + 1] + (double)src.getMinY());
                double dx = pts[i] + (double)src.getMinX() - (double)x;
                double dy = pts[i + 1] + (double)src.getMinY() - (double)y;
                Arrays.fill(result, 0.0);
                int m = -1;
                while (m < 3) {
                    int n = -1;
                    while (n < 3) {
                        int j;
                        double r1 = 0.0;
                        double r2 = 0.0;
                        double rx = (double)m - dx + 2.0;
                        r1 += rx * rx * rx;
                        rx = (double)m - dx + 1.0;
                        if (rx > 0.0) {
                            r1 -= 4.0 * rx * rx * rx;
                        }
                        if ((rx = (double)m - dx) > 0.0) {
                            r1 += 6.0 * rx * rx * rx;
                        }
                        if ((rx = (double)m - dx - 1.0) > 0.0) {
                            r1 -= 4.0 * rx * rx * rx;
                        }
                        r1 /= 6.0;
                        rx = dy - (double)n + 2.0;
                        if (rx > 0.0) {
                            r2 += rx * rx * rx;
                        }
                        if ((rx = dy - (double)n + 1.0) > 0.0) {
                            r2 -= 4.0 * rx * rx * rx;
                        }
                        if ((rx = dy - (double)n) > 0.0) {
                            r2 += 6.0 * rx * rx * rx;
                        }
                        if ((rx = dy - (double)n - 1.0) > 0.0) {
                            r2 -= 4.0 * rx * rx * rx;
                        }
                        r2 /= 6.0;
                        int srcX = x + m;
                        if (srcX >= src.getMinX() + src.getWidth()) {
                            srcX = src.getMinX() + src.getWidth() - 1;
                        } else if (srcX < src.getMinX()) {
                            srcX = src.getMinX();
                        }
                        int srcY = y + n;
                        if (srcY >= src.getMinY() + src.getHeight()) {
                            srcY = src.getMinY() + src.getHeight() - 1;
                        } else if (srcY < src.getMinY()) {
                            srcY = src.getMinY();
                        }
                        if (src.getTransferType() == 5 || src.getTransferType() == 4) {
                            pixels = src.getPixel(srcX, srcY, (double[])pixels);
                            j = 0;
                            while (j < result.length) {
                                int n2 = j;
                                result[n2] = result[n2] + pixels[j] * r1 * r2;
                                ++j;
                            }
                        } else {
                            pixels = src.getPixel(srcX, srcY, (int[])pixels);
                            j = 0;
                            while (j < result.length) {
                                int n3 = j;
                                result[n3] = result[n3] + (double)((int[])pixels)[j] * r1 * r2;
                                ++j;
                            }
                        }
                        ++n;
                    }
                    ++m;
                }
                dst.setPixel((int)dpts[i] + dst.getMinX(), (int)dpts[i + 1] + dst.getMinY(), result);
            }
            i += 2;
        }
    }
}

