/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class EntitiesType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{1, 2, 3, 4, 5, 6};

    EntitiesType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "ENTITIES"), TypeLibrary.ENTITY);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        CPStringBuilder buf = new CPStringBuilder();
        int len = value.length();
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c == ' ') {
                String token = buf.toString();
                if (token.length() > 0 && !context.isUnparsedEntity(token)) {
                    throw new DatatypeException(i, "invalid ENTITIES value");
                }
                buf.setLength(0);
            } else {
                buf.append(c);
            }
            ++i;
        }
        String token = buf.toString();
        if (token.length() == 0 || !context.isUnparsedEntity(token)) {
            throw new DatatypeException("invalid ENTITIES value");
        }
    }

    public boolean isContextDependent() {
        return true;
    }
}

