/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.pipeline;

import gnu.xml.pipeline.EventConsumer;
import gnu.xml.pipeline.EventFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LinkFilter
extends EventFilter {
    private Vector vector = new Vector();
    private String baseURI;
    private boolean siteRestricted = false;

    public LinkFilter() {
        super.setContentHandler(this);
    }

    public LinkFilter(EventConsumer next) {
        super(next);
        super.setContentHandler(this);
    }

    public Enumeration getLinks() {
        return this.vector.elements();
    }

    public void removeAllLinks() {
        this.vector = new Vector();
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("http://www.w3.org/1999/xhtml".equals(uri)) {
            String link = "a".equals(localName) || "base".equals(localName) || "area".equals(localName) ? atts.getValue("href") : ("iframe".equals(localName) || "frame".equals(localName) ? atts.getValue("src") : ("blockquote".equals(localName) || "q".equals(localName) || "ins".equals(localName) || "del".equals(localName) ? atts.getValue("cite") : null));
            link = this.maybeAddLink(link);
            if ("base".equals(localName) && link != null) {
                this.baseURI = link;
            }
            if ("iframe".equals(localName) || "img".equals(localName)) {
                this.maybeAddLink(atts.getValue("longdesc"));
            }
        }
        super.startElement(uri, localName, qName, atts);
    }

    private String maybeAddLink(String link) {
        if (link == null) {
            return null;
        }
        int index = link.indexOf("#");
        if (index >= 0) {
            link = link.substring(0, index);
        }
        if (link.equals("")) {
            return null;
        }
        try {
            URL base = new URL(this.baseURI != null ? this.baseURI : this.getDocumentLocator().getSystemId());
            URL url = new URL(base, link);
            link = url.toString();
            if (this.vector.contains(link)) {
                return link;
            }
            if (this.siteRestricted) {
                if (!base.getProtocol().equals(url.getProtocol())) {
                    return link;
                }
                if (base.getHost() != null && !base.getHost().equals(url.getHost())) {
                    return link;
                }
            }
            this.vector.addElement(link);
            return link;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void startDocument() throws SAXException {
        if (this.getDocumentLocator() == null) {
            throw new SAXException("no Locator!");
        }
    }

    public void endDocument() throws SAXException {
        this.baseURI = null;
        super.endDocument();
    }
}

