/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.RMIHashes;
import gnu.java.rmi.server.RMIObjectInputStream;
import gnu.java.rmi.server.RMIVoidValue;
import gnu.java.rmi.server.UnicastConnection;
import gnu.java.rmi.server.UnicastConnectionManager;
import gnu.java.rmi.server.UnicastRef;
import gnu.java.rmi.server.UnicastRemoteCall;
import gnu.java.rmi.server.UnicastRemoteStub;
import gnu.java.rmi.server.UnicastServer;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.Skeleton;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class UnicastServerRef
extends UnicastRef {
    private static final long serialVersionUID = -5585608108300801246L;
    private static final Class[] stubprototype = new Class[]{RemoteRef.class};
    Remote myself;
    protected Skeleton skel;
    protected Remote stub;
    protected Hashtable methods = new Hashtable();

    UnicastServerRef() {
    }

    public UnicastServerRef(ObjID id, int port, RMIServerSocketFactory ssf) throws RemoteException {
        super(id);
        this.manager = UnicastConnectionManager.getInstance(port, ssf);
    }

    public Remote exportObject(Remote obj) throws RemoteException {
        if (this.myself == null) {
            Class<? extends Object> cls;
            Class expCls;
            this.myself = obj;
            this.manager.serverobj = obj;
            ClassLoader loader = obj.getClass().getClassLoader();
            String ignoreStubs = loader == null ? "false" : System.getProperty("java.rmi.server.ignoreStubClasses", "false");
            if (!ignoreStubs.equals("true") && (expCls = this.findStubSkelClass(cls = obj.getClass())) != null) {
                this.stub = (RemoteStub)this.getHelperClass(expCls, "_Stub");
                this.skel = (Skeleton)this.getHelperClass(expCls, "_Skel");
            }
            if (this.stub == null) {
                this.stub = this.createProxyStub(obj.getClass(), this);
            }
            this.buildMethodHash(obj.getClass(), true);
            UnicastServer.exportObject(this);
        }
        return this.stub;
    }

    public Remote getStub() {
        return this.stub;
    }

    public boolean unexportObject(Remote obj, boolean force) {
        this.buildMethodHash(obj.getClass(), false);
        return UnicastServer.unexportObject(this, force);
    }

    protected Class findStubSkelClass(Class startCls) {
        Class cls = startCls;
        while (true) {
            try {
                String stubClassname = String.valueOf(cls.getName()) + "_Stub";
                ClassLoader cl = cls.getClassLoader();
                if (cl == null) {
                    Class.forName(stubClassname);
                } else {
                    cl.loadClass(stubClassname);
                }
                return cls;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Class superCls = cls.getSuperclass();
                if (superCls == null || superCls == UnicastRemoteObject.class) {
                    return null;
                }
                cls = superCls;
                continue;
            }
            break;
        }
    }

    protected Object getHelperClass(Class cls, String type) {
        try {
            Class<?> scls;
            String classname = cls.getName();
            ClassLoader cl = cls.getClassLoader();
            Class<?> clazz = scls = cl == null ? Class.forName(String.valueOf(classname) + type) : cl.loadClass(String.valueOf(classname) + type);
            if (type.equals("_Stub")) {
                try {
                    Constructor<?> con = scls.getConstructor(stubprototype);
                    return con.newInstance(this);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
                RemoteStub stub = (RemoteStub)scls.newInstance();
                UnicastRemoteStub.setStubRef(stub, this);
                return stub;
            }
            return scls.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return null;
    }

    public String getClientHost() throws ServerNotActiveException {
        return RemoteServer.getClientHost();
    }

    protected void buildMethodHash(Class cls, boolean build) {
        Method[] meths = cls.getMethods();
        int i = 0;
        while (i < meths.length) {
            if (!meths[i].getDeclaringClass().getName().startsWith("java.")) {
                long hash = RMIHashes.getMethodHash(meths[i]);
                if (build) {
                    this.methods.put(new Long(hash), meths[i]);
                } else {
                    this.methods.remove(new Long(hash));
                }
            }
            ++i;
        }
    }

    Class getMethodReturnType(int method, long hash) throws Exception {
        if (method == -1) {
            Method meth = (Method)this.methods.get(new Long(hash));
            return meth.getReturnType();
        }
        return null;
    }

    public Object incomingMessageCall(UnicastConnection conn, int method, long hash) throws Exception {
        if (method == -1) {
            Method meth = (Method)this.methods.get(new Long(hash));
            if (meth == null) {
                throw new NoSuchMethodException(String.valueOf(this.myself.getClass().getName()) + " hash " + hash);
            }
            ObjectInputStream in = conn.getObjectInputStream();
            int nrargs = meth.getParameterTypes().length;
            Object[] args = new Object[nrargs];
            int i = 0;
            while (i < nrargs) {
                try {
                    args[i] = ((RMIObjectInputStream)in).readValue(meth.getParameterTypes()[i]);
                }
                catch (Exception t) {
                    t.printStackTrace();
                    throw t;
                }
                ++i;
            }
            Object ret = null;
            try {
                ret = meth.invoke(this.myself, args);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new Error("The remote method threw a java.lang.Throwable that is neither java.lang.Exception nor java.lang.Error.", e);
            }
            return ret;
        }
        if (this.skel == null) {
            throw new NoSuchMethodException("JDK 1.1 call - Skeleton required");
        }
        UnicastRemoteCall call = new UnicastRemoteCall(conn);
        this.skel.dispatch(this.myself, call, method, hash);
        if (!call.isReturnValue()) {
            return RMIVoidValue.INSTANCE;
        }
        return call.returnValue();
    }

    Remote createProxyStub(Class stubFor, RemoteRef reference) {
        Class<?>[] intfs;
        HashSet interfaces = new HashSet();
        Class c = stubFor;
        while (c != null) {
            intfs = c.getInterfaces();
            int i = 0;
            while (i < intfs.length) {
                if (Remote.class.isAssignableFrom(intfs[i])) {
                    interfaces.add(intfs[i]);
                }
                ++i;
            }
            c = c.getSuperclass();
        }
        intfs = new Class[interfaces.size()];
        Iterator it = interfaces.iterator();
        int i = 0;
        while (i < intfs.length) {
            intfs[i] = (Class)it.next();
            ++i;
        }
        RemoteObjectInvocationHandler handler = new RemoteObjectInvocationHandler(reference);
        Object proxy = Proxy.newProxyInstance(stubFor.getClassLoader(), intfs, handler);
        return (Remote)proxy;
    }
}

