/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.qt;

import gnu.java.awt.peer.qt.QMatrix;
import gnu.java.awt.peer.qt.QtComponentPeer;
import gnu.java.awt.peer.qt.QtGraphics;
import gnu.java.awt.peer.qt.QtImageConsumer;
import gnu.java.awt.peer.qt.QtImageDirectGraphics;
import gnu.java.awt.peer.qt.QtImageGraphics;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.WeakHashMap;

public class QtImage
extends Image {
    int width = -1;
    int height = -1;
    Hashtable props;
    boolean isLoaded;
    long nativeObject;
    Vector observers;
    boolean errorLoading;
    ImageProducer source;
    static ColorModel nativeModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
    WeakHashMap painters;
    boolean killFlag;

    public native void clear();

    private native int[] getPixels();

    private native void setPixels(int[] var1);

    private native boolean loadImage(String var1);

    private native boolean loadImageFromData(byte[] var1);

    private native void createImage();

    private synchronized native void freeImage();

    private native void createScaledImage(QtImage var1, int var2);

    native void drawPixels(QtGraphics var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    private native void drawPixelsScaled(QtGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9);

    private native void drawPixelsTransformed(QtGraphics var1, QMatrix var2);

    native void drawPixelsScaledFlipped(QtGraphics var1, int var2, int var3, int var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, boolean var15);

    public QtImage(ImageProducer producer) {
        this.killFlag = false;
        this.isLoaded = false;
        this.observers = new Vector();
        this.source = producer;
        this.errorLoading = false;
        if (producer != null) {
            this.source.startProduction(new QtImageConsumer(this, this.source));
        }
    }

    public QtImage(URL url) {
        this.killFlag = false;
        this.isLoaded = false;
        this.observers = new Vector();
        this.errorLoading = false;
        if (url == null) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(5000);
        try {
            BufferedInputStream bis = new BufferedInputStream(url.openStream());
            byte[] buf = new byte[5000];
            int n = 0;
            while ((n = bis.read(buf)) != -1) {
                baos.write(buf, 0, n);
            }
            bis.close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Couldn't load image.");
        }
        if (!this.loadImageFromData(baos.toByteArray())) {
            throw new IllegalArgumentException("Couldn't load image.");
        }
        this.isLoaded = true;
        this.observers = null;
        this.props = new Hashtable();
    }

    public QtImage(String filename) {
        this.killFlag = false;
        File f = new File(filename);
        this.observers = null;
        this.props = new Hashtable();
        try {
            String fn = f.getCanonicalPath();
            if (!this.loadImage(fn)) {
                this.errorLoading = true;
                this.isLoaded = false;
                return;
            }
        }
        catch (IOException iOException) {
            this.errorLoading = true;
            this.isLoaded = false;
            return;
        }
        this.errorLoading = false;
        this.isLoaded = true;
    }

    public QtImage(byte[] data) {
        if (!this.loadImageFromData(data)) {
            throw new IllegalArgumentException("Couldn't load image.");
        }
        this.killFlag = false;
        this.isLoaded = true;
        this.observers = null;
        this.errorLoading = false;
        this.props = new Hashtable();
    }

    public QtImage(int width, int height) {
        this.width = width;
        this.height = height;
        this.props = new Hashtable();
        this.isLoaded = true;
        this.killFlag = false;
        this.observers = null;
        this.errorLoading = false;
        this.createImage();
        this.clear();
    }

    private QtImage(QtImage src, int width, int height, int hints) {
        this.width = width;
        this.height = height;
        this.props = new Hashtable();
        this.isLoaded = true;
        this.killFlag = false;
        this.observers = null;
        this.errorLoading = false;
        this.createScaledImage(src, hints);
    }

    public void setImage(int width, int height, int[] pixels, Hashtable properties) {
        this.width = width;
        this.height = height;
        Hashtable hashtable = this.props = properties != null ? properties : new Hashtable();
        if (width <= 0 || height <= 0 || pixels == null) {
            this.errorLoading = true;
            return;
        }
        this.isLoaded = true;
        this.deliver();
        this.createImage();
        this.setPixels(pixels);
    }

    public int getWidth(ImageObserver observer) {
        if (this.addObserver(observer)) {
            return -1;
        }
        return this.width;
    }

    public int getHeight(ImageObserver observer) {
        if (this.addObserver(observer)) {
            return -1;
        }
        return this.height;
    }

    public Object getProperty(String name, ImageObserver observer) {
        if (this.addObserver(observer)) {
            return UndefinedProperty;
        }
        Object value = this.props.get(name);
        return value == null ? UndefinedProperty : value;
    }

    public ImageProducer getSource() {
        if (!this.isLoaded) {
            return null;
        }
        return new MemoryImageSource(this.width, this.height, nativeModel, this.getPixels(), 0, this.width);
    }

    void putPainter(QtImageGraphics g) {
        if (this.painters == null) {
            this.painters = new WeakHashMap();
        }
        this.painters.put(g, "dummy");
    }

    void removePainter(QtImageGraphics g) {
        this.painters.remove(g);
        if (this.killFlag && this.painters.isEmpty()) {
            this.freeImage();
        }
    }

    public Graphics getGraphics() {
        if (!this.isLoaded || this.killFlag) {
            return null;
        }
        return new QtImageGraphics(this);
    }

    Graphics getDirectGraphics(QtComponentPeer peer) {
        if (!this.isLoaded) {
            return null;
        }
        return new QtImageDirectGraphics(this, peer);
    }

    public Image getScaledInstance(int width, int height, int hints) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width and height of scaled bitmapmust be >= 0");
        }
        return new QtImage(this, width, height, hints);
    }

    public synchronized void flush() {
        if (this.isLoaded && this.source != null) {
            this.observers = new Vector();
            this.isLoaded = false;
            this.freeImage();
            this.source.startProduction(new QtImageConsumer(this, this.source));
        }
    }

    public void finalize() {
        this.dispose();
    }

    public void dispose() {
        if (this.isLoaded) {
            if (this.painters == null || this.painters.isEmpty()) {
                this.freeImage();
            } else {
                this.killFlag = true;
            }
        }
    }

    public int checkImage(ImageObserver observer) {
        if (this.addObserver(observer)) {
            if (this.errorLoading) {
                return 64;
            }
            return 0;
        }
        return 35;
    }

    public boolean drawImage(QtGraphics g, QMatrix matrix, ImageObserver observer) {
        if (this.addObserver(observer)) {
            return false;
        }
        this.drawPixelsTransformed(g, matrix);
        return true;
    }

    public boolean drawImage(QtGraphics g, int x, int y, Color bgcolor, ImageObserver observer) {
        if (this.addObserver(observer)) {
            return false;
        }
        if (bgcolor != null) {
            this.drawPixels(g, bgcolor.getRed(), bgcolor.getGreen(), bgcolor.getBlue(), x, y, true);
        } else {
            this.drawPixels(g, 0, 0, 0, x, y, false);
        }
        return true;
    }

    public boolean drawImage(QtGraphics g, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        if (this.addObserver(observer)) {
            return false;
        }
        if (bgcolor != null) {
            this.drawPixelsScaled(g, bgcolor.getRed(), bgcolor.getGreen(), bgcolor.getBlue(), x, y, width, height, true);
        } else {
            this.drawPixelsScaled(g, 0, 0, 0, x, y, width, height, false);
        }
        return true;
    }

    public boolean drawImage(QtGraphics g, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        int dstY;
        if (this.addObserver(observer)) {
            return false;
        }
        boolean flipX = dx1 > dx2 ^ sx1 > sx2;
        boolean flipY = dy1 > dy2 ^ sy1 > sy2;
        int dstWidth = Math.abs(dx2 - dx1);
        int dstHeight = Math.abs(dy2 - dy1);
        int srcWidth = Math.abs(sx2 - sx1);
        int srcHeight = Math.abs(sy2 - sy1);
        int srcX = sx1 < sx2 ? sx1 : sx2;
        int srcY = sy1 < sy2 ? sy1 : sy2;
        int dstX = dx1 < dx2 ? dx1 : dx2;
        int n = dstY = dy1 < dy2 ? dy1 : dy2;
        if (srcWidth > this.width) {
            dstWidth = (int)((double)dstWidth * ((double)this.width / (double)srcWidth));
            srcWidth = this.width - srcX;
        }
        if (srcHeight > this.height) {
            dstHeight = (int)((double)dstHeight * ((double)this.height / (double)srcHeight));
            srcHeight = this.height - srcY;
        }
        if (srcWidth + srcX > this.width) {
            dstWidth = (int)((double)dstWidth * (double)(this.width - srcX) / (double)srcWidth);
            srcWidth = this.width - srcX;
        }
        if (srcHeight + srcY > this.height) {
            dstHeight = (int)((double)dstHeight * (double)(this.width - srcY) / (double)srcHeight);
            srcHeight = this.height - srcY;
        }
        if (srcWidth <= 0 || srcHeight <= 0 || dstWidth <= 0 || dstHeight <= 0) {
            return true;
        }
        if (bgcolor != null) {
            this.drawPixelsScaledFlipped(g, bgcolor.getRed(), bgcolor.getGreen(), bgcolor.getBlue(), flipX, flipY, srcX, srcY, srcWidth, srcHeight, dstX, dstY, dstWidth, dstHeight, true);
        } else {
            this.drawPixelsScaledFlipped(g, 0, 0, 0, flipX, flipY, srcX, srcY, srcWidth, srcHeight, dstX, dstY, dstWidth, dstHeight, false);
        }
        return true;
    }

    public native void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    private void deliver() {
        int flags = 39;
        if (this.observers != null) {
            int i = 0;
            while (i < this.observers.size()) {
                ((ImageObserver)this.observers.elementAt(i)).imageUpdate(this, flags, 0, 0, this.width, this.height);
                ++i;
            }
        }
        this.observers = null;
    }

    private boolean addObserver(ImageObserver observer) {
        if (!this.isLoaded) {
            if (observer != null && !this.observers.contains(observer)) {
                this.observers.addElement(observer);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "QtImage [isLoaded=" + this.isLoaded + ", width=" + this.width + ", height=" + this.height + "]";
    }
}

