/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.EuropeanNationType;
import net.sf.freecol.common.model.Event;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GameOptions;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.AbstractUnitOption;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.MapGeneratorOptions;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.option.RangeOption;
import net.sf.freecol.common.option.StringOption;
import net.sf.freecol.common.option.TextOption;
import net.sf.freecol.common.option.UnitListOption;
import net.sf.freecol.common.util.CollectionUtils;

public final class Specification {
    private static final Logger logger = Logger.getLogger(Specification.class.getName());
    private static final String DIFFICULTY_LEVELS = "difficultyLevels";
    public static final String ROLES_COMPAT_FILE_NAME = "roles-compat.xml";
    public static final String DEFAULT_ROLE_ID = "model.role.default";
    public static final int NUMBER_OF_AGES = 3;
    public static final Source AMBUSH_BONUS_SOURCE = new Source("model.source.ambushBonus");
    public static final Source AMPHIBIOUS_ATTACK_PENALTY_SOURCE = new Source("model.source.amphibiousAttack");
    public static final Source ARTILLERY_PENALTY_SOURCE = new Source("model.source.artilleryInTheOpen");
    public static final Source ATTACK_BONUS_SOURCE = new Source("model.source.attackBonus");
    public static final Source BASE_DEFENCE_SOURCE = new Source("model.source.baseDefence");
    public static final Source BASE_OFFENCE_SOURCE = new Source("model.source.baseOffence");
    public static final Source CARGO_PENALTY_SOURCE = new Source("model.source.cargoPenalty");
    public static final Source COLONY_GOODS_PARTY_SOURCE = new Source("model.source.colonyGoodsParty");
    public static final Source FORTIFICATION_BONUS_SOURCE = new Source("model.source.fortified");
    public static final Source INDIAN_RAID_BONUS_SOURCE = new Source("model.source.artilleryAgainstRaid");
    public static final Source MOVEMENT_PENALTY_SOURCE = new Source("model.source.movementPenalty");
    public static final Source SHIP_TRADE_PENALTY_SOURCE = new Source("model.source.shipTradePenalty");
    public static final Source SOL_MODIFIER_SOURCE = new Source("model.source.solModifier");
    private static final Source[] sources = new Source[]{MOVEMENT_PENALTY_SOURCE, ARTILLERY_PENALTY_SOURCE, ATTACK_BONUS_SOURCE, FORTIFICATION_BONUS_SOURCE, INDIAN_RAID_BONUS_SOURCE, AMPHIBIOUS_ATTACK_PENALTY_SOURCE, BASE_OFFENCE_SOURCE, BASE_DEFENCE_SOURCE, CARGO_PENALTY_SOURCE, AMBUSH_BONUS_SOURCE, COLONY_GOODS_PARTY_SOURCE, SHIP_TRADE_PENALTY_SOURCE, SOL_MODIFIER_SOURCE};
    private final Map<String, ChildReader> readerMap = new HashMap<String, ChildReader>();
    private final List<BuildingType> buildingTypeList = new ArrayList<BuildingType>();
    private final List<Disaster> disasters = new ArrayList<Disaster>();
    private final List<EquipmentType> equipmentTypes = new ArrayList<EquipmentType>();
    private final List<EuropeanNationType> europeanNationTypes = new ArrayList<EuropeanNationType>();
    private final List<Event> events = new ArrayList<Event>();
    private final List<FoundingFather> foundingFathers = new ArrayList<FoundingFather>();
    private final List<GoodsType> goodsTypeList = new ArrayList<GoodsType>();
    private final List<IndianNationType> indianNationTypes = new ArrayList<IndianNationType>();
    private final List<Nation> nations = new ArrayList<Nation>();
    private final List<ResourceType> resourceTypeList = new ArrayList<ResourceType>();
    private final List<Role> roles = new ArrayList<Role>();
    private final List<TileType> tileTypeList = new ArrayList<TileType>();
    private final List<TileImprovementType> tileImprovementTypeList = new ArrayList<TileImprovementType>();
    private final List<UnitType> unitTypeList = new ArrayList<UnitType>();
    private final Map<String, List<Modifier>> allModifiers = new HashMap<String, List<Modifier>>();
    private final List<Modifier> specialModifiers = new ArrayList<Modifier>();
    private final Map<String, AbstractOption> allOptions = new HashMap<String, AbstractOption>();
    private final Map<String, OptionGroup> allOptionGroups = new HashMap<String, OptionGroup>();
    private final List<GoodsType> storableGoodsTypeList = new ArrayList<GoodsType>();
    private final List<GoodsType> farmedGoodsTypeList = new ArrayList<GoodsType>();
    private final List<GoodsType> foodGoodsTypeList = new ArrayList<GoodsType>();
    private final List<GoodsType> newWorldGoodsTypeList = new ArrayList<GoodsType>();
    private final List<GoodsType> newWorldLuxuryGoodsTypeList = new ArrayList<GoodsType>();
    private final List<GoodsType> libertyGoodsTypeList = new ArrayList<GoodsType>();
    private final List<GoodsType> immigrationGoodsTypeList = new ArrayList<GoodsType>();
    private final List<GoodsType> rawBuildingGoodsTypeList = new ArrayList<GoodsType>();
    private final List<Nation> europeanNations = new ArrayList<Nation>();
    private final List<Nation> REFNations = new ArrayList<Nation>();
    private final List<Nation> indianNations = new ArrayList<Nation>();
    private final List<NationType> nationTypes = new ArrayList<NationType>();
    private final List<EuropeanNationType> REFNationTypes = new ArrayList<EuropeanNationType>();
    private final ArrayList<UnitType> buildableUnitTypes = new ArrayList();
    private final Map<GoodsType, UnitType> experts = new HashMap<GoodsType, UnitType>();
    private final List<UnitType> unitTypesTrainedInEurope = new ArrayList<UnitType>();
    private final List<UnitType> unitTypesPurchasedInEurope = new ArrayList<UnitType>();
    private UnitType fastestLandUnitType = null;
    private UnitType fastestNavalUnitType = null;
    private final List<UnitType> defaultUnitTypes = new ArrayList<UnitType>();
    public final Map<String, String> fatherGoodsFixMap = new HashMap<String, String>();
    private final Map<String, FreeColGameObjectType> allTypes = new HashMap<String, FreeColGameObjectType>();
    private final Map<String, List<Ability>> allAbilities = new HashMap<String, List<Ability>>();
    private List<Role> militaryRoles = null;
    private boolean initialized = false;
    private String id;
    private String version;
    private String difficultyLevel = null;
    private final int[] ages = new int[3];
    private static final String BUILDING_TYPES_TAG = "building-types";
    private static final String DIFFICULTY_LEVEL_TAG = "difficulty-level";
    private static final String DISASTERS_TAG = "disasters";
    private static final String EUROPEAN_NATION_TYPES_TAG = "european-nation-types";
    private static final String EVENTS_TAG = "events";
    private static final String FOUNDING_FATHERS_TAG = "founding-fathers";
    private static final String GOODS_TYPES_TAG = "goods-types";
    private static final String INDIAN_NATION_TYPES_TAG = "indian-nation-types";
    private static final String MODIFIERS_TAG = "modifiers";
    private static final String NATIONS_TAG = "nations";
    private static final String OPTIONS_TAG = "options";
    private static final String RESOURCE_TYPES_TAG = "resource-types";
    private static final String ROLES_TAG = "roles";
    private static final String TILE_TYPES_TAG = "tile-types";
    private static final String TILE_IMPROVEMENT_TYPES_TAG = "tile-improvement-types";
    private static final String UNIT_TYPES_TAG = "unit-types";
    private static final String VERSION_TAG = "version";
    private static final String EQUIPMENT_TYPES_TAG = "equipment-types";
    private static final String OLD_DIFFICULTY_LEVEL_TAG = "difficultyLevel";
    private static final String OLD_TILEIMPROVEMENT_TYPES_TAG = "tileimprovement-types";

    public Specification() {
        logger.fine("Initializing Specification");
        for (Source source : sources) {
            this.allTypes.put(source.getId(), source);
        }
        this.readerMap.put(BUILDING_TYPES_TAG, new TypeReader<BuildingType>(BuildingType.class, this.buildingTypeList));
        this.readerMap.put(DISASTERS_TAG, new TypeReader<Disaster>(Disaster.class, this.disasters));
        this.readerMap.put(EQUIPMENT_TYPES_TAG, new TypeReader<EquipmentType>(EquipmentType.class, this.equipmentTypes));
        this.readerMap.put(EUROPEAN_NATION_TYPES_TAG, new TypeReader<EuropeanNationType>(EuropeanNationType.class, this.europeanNationTypes));
        this.readerMap.put(EVENTS_TAG, new TypeReader<Event>(Event.class, this.events));
        this.readerMap.put(FOUNDING_FATHERS_TAG, new TypeReader<FoundingFather>(FoundingFather.class, this.foundingFathers));
        this.readerMap.put(GOODS_TYPES_TAG, new TypeReader<GoodsType>(GoodsType.class, this.goodsTypeList));
        this.readerMap.put(INDIAN_NATION_TYPES_TAG, new TypeReader<IndianNationType>(IndianNationType.class, this.indianNationTypes));
        this.readerMap.put(NATIONS_TAG, new TypeReader<Nation>(Nation.class, this.nations));
        this.readerMap.put(RESOURCE_TYPES_TAG, new TypeReader<ResourceType>(ResourceType.class, this.resourceTypeList));
        this.readerMap.put(ROLES_TAG, new TypeReader<Role>(Role.class, this.roles));
        this.readerMap.put(TILE_TYPES_TAG, new TypeReader<TileType>(TileType.class, this.tileTypeList));
        this.readerMap.put(TILE_IMPROVEMENT_TYPES_TAG, new TypeReader<TileImprovementType>(TileImprovementType.class, this.tileImprovementTypeList));
        this.readerMap.put(OLD_TILEIMPROVEMENT_TYPES_TAG, new TypeReader<TileImprovementType>(TileImprovementType.class, this.tileImprovementTypeList));
        this.readerMap.put(UNIT_TYPES_TAG, new TypeReader<UnitType>(UnitType.class, this.unitTypeList));
        this.readerMap.put(MODIFIERS_TAG, new ModifierReader());
        this.readerMap.put(OPTIONS_TAG, new OptionReader());
    }

    public Specification(FreeColXMLReader xr) {
        this();
        this.initialized = false;
        this.load(xr);
        this.prepare(null, this.difficultyLevel);
        this.clean("load from stream");
        this.initialized = true;
    }

    private void load(FreeColXMLReader xr) {
        try {
            this.readFromXML(xr);
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing specification", e);
        }
    }

    public Specification(InputStream in) {
        this();
        this.initialized = false;
        this.load(in);
        this.prepare(null, this.difficultyLevel);
        this.clean("load from InputStream");
        this.initialized = true;
    }

    private void load(InputStream in) {
        try (FreeColXMLReader xr = new FreeColXMLReader(in);){
            xr.nextTag();
            this.load(xr);
        }
        catch (Exception e) {
            throw new RuntimeException("Load specification stream error", e);
        }
    }

    public void prepare(NationOptions.Advantages advantages, String difficulty) {
        this.prepare(advantages, difficulty == null ? null : this.getDifficultyOptionGroup(difficulty));
    }

    public void prepare(NationOptions.Advantages advantages, OptionGroup difficulty) {
        this.applyFixes();
        if (advantages == NationOptions.Advantages.NONE) {
            this.clearEuropeanNationalAdvantages();
        }
        if (difficulty != null) {
            this.allOptionGroups.put(difficulty.getId(), difficulty);
            this.applyDifficultyLevel(difficulty);
        }
    }

    public boolean loadMods(List<FreeColModFile> mods) {
        this.initialized = false;
        boolean loadedMod = false;
        for (FreeColModFile mod : mods) {
            InputStream sis = null;
            try {
                sis = mod.getSpecificationInputStream();
                if (sis != null) {
                    this.load(sis);
                }
                loadedMod = true;
                logger.info("Loaded mod " + mod.getId());
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Read error in mod " + mod.getId(), ioe);
            }
            catch (RuntimeException rte) {
                logger.log(Level.WARNING, "Parse error in mod " + mod.getId(), rte);
            }
        }
        if (loadedMod) {
            this.clean("mod loading");
        }
        this.initialized = true;
        return loadedMod;
    }

    public OptionGroup loadOptionsFile(String optionId, File file) {
        OptionGroup group = null;
        try (FileInputStream fis = new FileInputStream(file);
             FreeColXMLReader xr = new FreeColXMLReader(fis);){
            xr.nextTag();
            group = new OptionGroup(this);
            group.readFromXML(xr);
            if (!optionId.equals(group.getId())) {
                Option op = group.getOption(optionId);
                group = op instanceof OptionGroup ? (OptionGroup)op : null;
            }
            logger.info("Loaded " + optionId + " group from file " + file.getPath() + (group == null ? " failed" : " succeeded"));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to load OptionGroup " + optionId + " from " + file.getName(), e);
        }
        return group;
    }

    public OptionGroup mergeGroup(OptionGroup group) {
        OptionGroup realGroup = this.allOptionGroups.get(group.getId());
        if (realGroup == null || !realGroup.isEditable()) {
            return realGroup;
        }
        for (Option o : group.getOptions()) {
            if (o instanceof OptionGroup) {
                this.mergeGroup((OptionGroup)o);
                continue;
            }
            realGroup.add(o);
        }
        return realGroup;
    }

    public static OptionGroup saveOptionsFile(OptionGroup group, File file) {
        if (group != null) {
            try {
                return group.save(file, FreeColXMLWriter.WriteScope.toSave(), true) ? group : null;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to save option group " + group.getId() + " to " + file.getName(), e);
            }
        }
        return null;
    }

    public void clean(String why) {
        logger.finest("Cleaning up specification following " + why + ".");
        Iterator<FreeColGameObjectType> typeIterator = this.allTypes.values().iterator();
        while (typeIterator.hasNext()) {
            FreeColGameObjectType type = typeIterator.next();
            if (!type.isAbstractType()) continue;
            typeIterator.remove();
        }
        GoodsType.setDerivedAttributes(this);
        this.storableGoodsTypeList.clear();
        this.farmedGoodsTypeList.clear();
        this.foodGoodsTypeList.clear();
        this.newWorldGoodsTypeList.clear();
        this.newWorldLuxuryGoodsTypeList.clear();
        this.libertyGoodsTypeList.clear();
        this.immigrationGoodsTypeList.clear();
        this.rawBuildingGoodsTypeList.clear();
        for (GoodsType goodsType : this.goodsTypeList) {
            if (goodsType.isStorable()) {
                this.storableGoodsTypeList.add(goodsType);
            }
            if (goodsType.isFarmed()) {
                this.farmedGoodsTypeList.add(goodsType);
            }
            if (goodsType.isFoodType()) {
                this.foodGoodsTypeList.add(goodsType);
            }
            if (goodsType.isNewWorldGoodsType()) {
                this.newWorldGoodsTypeList.add(goodsType);
                if (goodsType.isNewWorldLuxuryType()) {
                    this.newWorldLuxuryGoodsTypeList.add(goodsType);
                }
            }
            if (goodsType.isLibertyType()) {
                this.libertyGoodsTypeList.add(goodsType);
            }
            if (goodsType.isImmigrationType()) {
                this.immigrationGoodsTypeList.add(goodsType);
            }
            if (!goodsType.isRawBuildingMaterial() || goodsType.isFoodType()) continue;
            this.rawBuildingGoodsTypeList.add(goodsType);
        }
        this.REFNations.clear();
        this.europeanNations.clear();
        this.indianNations.clear();
        for (Nation nation : this.nations) {
            if (nation.getType().isEuropean()) {
                if (nation.isUnknownEnemy()) continue;
                if (nation.getType().isREF()) {
                    this.REFNations.add(nation);
                    continue;
                }
                this.europeanNations.add(nation);
                continue;
            }
            this.indianNations.add(nation);
        }
        this.nationTypes.clear();
        this.nationTypes.addAll(this.indianNationTypes);
        this.nationTypes.addAll(this.europeanNationTypes);
        Iterator<EuropeanNationType> iterator = this.europeanNationTypes.iterator();
        while (iterator.hasNext()) {
            EuropeanNationType nationType = iterator.next();
            if (!nationType.isREF()) continue;
            this.REFNationTypes.add(nationType);
            iterator.remove();
        }
        this.experts.clear();
        this.unitTypesTrainedInEurope.clear();
        this.unitTypesPurchasedInEurope.clear();
        this.defaultUnitTypes.clear();
        int bestLandValue = -1;
        int bestNavalValue = -1;
        for (UnitType unitType : this.unitTypeList) {
            if (unitType.isDefaultUnitType()) {
                this.defaultUnitTypes.add(unitType);
            }
            if (unitType.needsGoodsToBuild() && !unitType.hasAbility("model.ability.bornInColony")) {
                this.buildableUnitTypes.add(unitType);
            }
            if (unitType.getExpertProduction() != null) {
                this.experts.put(unitType.getExpertProduction(), unitType);
            }
            if (unitType.hasPrice()) {
                if (unitType.getSkill() > 0) {
                    this.unitTypesTrainedInEurope.add(unitType);
                } else if (!unitType.hasSkill()) {
                    this.unitTypesPurchasedInEurope.add(unitType);
                }
            }
            if (unitType.isNaval()) {
                if (bestNavalValue >= unitType.getMovement()) continue;
                bestNavalValue = unitType.getMovement();
                this.fastestNavalUnitType = unitType;
                continue;
            }
            if (bestLandValue >= unitType.getMovement()) continue;
            bestLandValue = unitType.getMovement();
            this.fastestLandUnitType = unitType;
        }
        for (AbstractOption option : this.allOptions.values()) {
            option.generateChoices();
        }
        Turn.initialize(this.getInteger("model.option.startingYear"), this.getInteger("model.option.seasonYear"), this.getInteger("model.option.seasons"));
        AbstractOption agesOption = this.getOption("model.option.ages");
        boolean badAges = !(agesOption instanceof TextOption);
        String agesValue = badAges ? "" : ((TextOption)agesOption).getValue();
        String[] a = agesValue.split(",");
        if (!(badAges |= a.length != 2)) {
            try {
                this.ages[0] = 1;
                this.ages[1] = Turn.yearToTurn(Integer.parseInt(a[0]));
                this.ages[2] = Turn.yearToTurn(Integer.parseInt(a[1]));
                if (this.ages[1] < 1 || this.ages[2] < 1) {
                    badAges = true;
                } else if (this.ages[1] > this.ages[2]) {
                    int tmp = this.ages[1];
                    this.ages[1] = this.ages[2];
                    this.ages[2] = tmp;
                }
            }
            catch (NumberFormatException nfe) {
                badAges = true;
            }
        }
        if (badAges) {
            logger.warning("Bad ages: " + agesValue);
            this.ages[0] = 1;
            this.ages[1] = Turn.yearToTurn(1600);
            this.ages[2] = Turn.yearToTurn(1700);
        }
        boolean customsOnCoast = this.getBoolean("model.option.customsOnCoast");
        for (Ability a2 : this.getBuildingType("model.building.customHouse").getAbilities("model.ability.coastalOnly")) {
            a2.setValue(customsOnCoast);
        }
        logger.info("Specification clean following " + why + " complete" + ", starting year=" + Turn.getStartingYear() + ", season year=" + Turn.getSeasonYear() + ", ages=[" + this.ages[0] + "," + this.ages[1] + "," + this.ages[2] + "]" + ", seasons=" + Turn.getSeasonNumber() + ", " + this.allTypes.size() + " FreeColGameObjectTypes" + ", " + this.allAbilities.size() + " Abilities" + ", " + this.buildingTypeList.size() + " BuildingTypes" + ", " + this.disasters.size() + " Disasters" + ", " + this.europeanNationTypes.size() + " EuropeanNationTypes" + ", " + this.events.size() + " Events" + ", " + this.foundingFathers.size() + " FoundingFathers" + ", " + this.goodsTypeList.size() + " GoodsTypes" + ", " + this.indianNationTypes.size() + " IndianNationTypes" + ", " + this.allModifiers.size() + " Modifiers" + ", " + this.nations.size() + " Nations" + ", " + this.allOptions.size() + " Options" + ", " + this.allOptionGroups.size() + " Option Groups" + ", " + this.resourceTypeList.size() + " ResourceTypes" + ", " + this.roles.size() + " Roles" + ", " + this.tileTypeList.size() + " TileTypes" + ", " + this.tileImprovementTypeList.size() + " TileImprovementTypes" + ", " + this.unitTypeList.size() + " UnitTypes" + " read.");
    }

    public void disableEditing() {
        for (String s : new String[]{GameOptions.getXMLElementTagName(), MapGeneratorOptions.getXMLElementTagName(), DIFFICULTY_LEVELS}) {
            OptionGroup og = this.allOptionGroups.get(s);
            if (og == null) continue;
            og.setEditable(false);
        }
    }

    public void generateDynamicOptions() {
        logger.finest("Generating dynamic options.");
        OptionGroup prices = new OptionGroup("gameOptions.prices", this);
        this.allOptionGroups.put(prices.getId(), prices);
        for (GoodsType goodsType : this.goodsTypeList) {
            String name = goodsType.getSuffix("model.goods.");
            String base = "model.option." + name + ".";
            if (goodsType.getInitialSellPrice() > 0) {
                int diff = goodsType.isNewWorldGoodsType() || goodsType.isNewWorldLuxuryType() ? 3 : 0;
                IntegerOption minimum = new IntegerOption(base + "minimumPrice", this);
                minimum.setValue(goodsType.getInitialSellPrice());
                minimum.setMinimumValue(1);
                minimum.setMaximumValue(100);
                prices.add(minimum);
                this.addAbstractOption(minimum);
                IntegerOption maximum = new IntegerOption(base + "maximumPrice", this);
                maximum.setValue(goodsType.getInitialSellPrice() + diff);
                maximum.setMinimumValue(1);
                maximum.setMaximumValue(100);
                prices.add(maximum);
                this.addAbstractOption(maximum);
                IntegerOption spread = new IntegerOption(base + "spread", this);
                spread.setValue(goodsType.getPriceDifference());
                spread.setMinimumValue(1);
                spread.setMaximumValue(100);
                prices.add(spread);
                this.addAbstractOption(spread);
                continue;
            }
            if (goodsType.getPrice() >= Integer.MAX_VALUE) continue;
            IntegerOption price = new IntegerOption(base + "price", this);
            price.setValue(goodsType.getPrice());
            price.setMinimumValue(1);
            price.setMaximumValue(100);
            prices.add(price);
            this.addAbstractOption(price);
        }
        this.getGameOptions().add(prices);
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public void addAbility(Ability ability) {
        String id = ability.getId();
        this.addAbility(id);
        this.allAbilities.get(id).add(ability);
    }

    public void addAbility(String id) {
        if (!this.allAbilities.containsKey(id)) {
            this.allAbilities.put(id, new ArrayList());
        }
    }

    public List<Ability> getAbilities(String id) {
        return this.allAbilities.get(id);
    }

    public void addModifier(Modifier modifier) {
        String id = modifier.getId();
        if (!this.allModifiers.containsKey(id)) {
            this.allModifiers.put(id, new ArrayList());
        }
        this.allModifiers.get(id).add(modifier);
    }

    public List<Modifier> getModifiers(String id) {
        List<Modifier> result = this.allModifiers.get(id);
        return result == null ? Collections.emptyList() : result;
    }

    public boolean hasOption(String id) {
        return id != null && this.allOptions.containsKey(id);
    }

    public AbstractOption getOption(String id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("AbstractOption with null id.");
        }
        if (!this.allOptions.containsKey(id)) {
            throw new IllegalArgumentException("Missing AbstractOption: " + id);
        }
        return this.allOptions.get(id);
    }

    public OptionGroup getOptionGroup(String id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("OptionGroup with null id.");
        }
        if (!this.allOptionGroups.containsKey(id)) {
            throw new IllegalArgumentException("Missing OptionGroup: " + id);
        }
        return this.allOptionGroups.get(id);
    }

    public void addOptionGroup(OptionGroup optionGroup, boolean recursive) {
        Iterator<Option> iter = optionGroup.iterator();
        while (iter.hasNext()) {
            Option option = iter.next();
            if (option instanceof OptionGroup) {
                this.allOptionGroups.put(option.getId(), (OptionGroup)option);
                if (!recursive) continue;
                this.addOptionGroup((OptionGroup)option, true);
                continue;
            }
            this.addAbstractOption((AbstractOption)option);
        }
    }

    private void addAbstractOption(AbstractOption abstractOption) {
        this.allOptions.put(abstractOption.getId(), abstractOption);
    }

    public IntegerOption getIntegerOption(String id) {
        return (IntegerOption)this.getOption(id);
    }

    public RangeOption getRangeOption(String id) {
        return (RangeOption)this.getOption(id);
    }

    public BooleanOption getBooleanOption(String id) {
        return (BooleanOption)this.getOption(id);
    }

    public StringOption getStringOption(String id) {
        return (StringOption)this.getOption(id);
    }

    public boolean getBoolean(String id) {
        try {
            return this.getBooleanOption(id).getValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a boolean option: " + id, e);
        }
    }

    public int getInteger(String id) {
        try {
            return this.getIntegerOption(id).getValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not an integer option: " + id, e);
        }
    }

    public String getString(String id) {
        try {
            return this.getStringOption(id).getValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a string option: " + id, e);
        }
    }

    public List<BuildingType> getBuildingTypeList() {
        return this.buildingTypeList;
    }

    public BuildingType getBuildingType(String id) {
        return this.getType(id, BuildingType.class);
    }

    public List<GoodsType> getGoodsTypeList() {
        return new ArrayList<GoodsType>(this.goodsTypeList);
    }

    public List<GoodsType> getStorableGoodsTypeList() {
        return new ArrayList<GoodsType>(this.storableGoodsTypeList);
    }

    public List<GoodsType> getFarmedGoodsTypeList() {
        return new ArrayList<GoodsType>(this.farmedGoodsTypeList);
    }

    public List<GoodsType> getNewWorldGoodsTypeList() {
        return new ArrayList<GoodsType>(this.newWorldGoodsTypeList);
    }

    public List<GoodsType> getNewWorldLuxuryGoodsTypeList() {
        return new ArrayList<GoodsType>(this.newWorldLuxuryGoodsTypeList);
    }

    public List<GoodsType> getLibertyGoodsTypeList() {
        return new ArrayList<GoodsType>(this.libertyGoodsTypeList);
    }

    public List<GoodsType> getImmigrationGoodsTypeList() {
        return new ArrayList<GoodsType>(this.immigrationGoodsTypeList);
    }

    public List<GoodsType> getFoodGoodsTypeList() {
        return new ArrayList<GoodsType>(this.foodGoodsTypeList);
    }

    public final List<GoodsType> getRawBuildingGoodsTypeList() {
        return new ArrayList<GoodsType>(this.rawBuildingGoodsTypeList);
    }

    public GoodsType getPrimaryFoodType() {
        return this.getGoodsType("model.goods.food");
    }

    public int getInitialPrice(GoodsType goodsType) {
        String suffix = goodsType.getSuffix("model.goods.");
        String minPrice = "model.option." + suffix + ".minimumPrice";
        String maxPrice = "model.option." + suffix + ".maximumPrice";
        return this.hasOption(minPrice) && this.hasOption(maxPrice) ? Math.min(this.getInteger(minPrice), this.getInteger(maxPrice)) : goodsType.getInitialSellPrice();
    }

    public GoodsType getGoodsType(String id) {
        return this.getType(id, GoodsType.class);
    }

    public List<ResourceType> getResourceTypeList() {
        return this.resourceTypeList;
    }

    public ResourceType getResourceType(String id) {
        return this.getType(id, ResourceType.class);
    }

    public List<TileType> getTileTypeList() {
        return this.tileTypeList;
    }

    public TileType getTileType(String id) {
        return this.getType(id, TileType.class);
    }

    public List<TileImprovementType> getTileImprovementTypeList() {
        return this.tileImprovementTypeList;
    }

    public TileImprovementType getTileImprovementType(String id) {
        return this.getType(id, TileImprovementType.class);
    }

    public List<UnitType> getUnitTypeList() {
        return this.unitTypeList;
    }

    public UnitType getDefaultUnitType(Player player) {
        return player == null ? this.getDefaultUnitType() : this.getDefaultUnitType(player.getNationType());
    }

    public UnitType getDefaultUnitType(NationType nationType) {
        Predicate<UnitType> p = nationType == null ? ut -> !ut.hasAbility("model.ability.bornInIndianSettlement") && !ut.hasAbility("model.ability.refUnit") : (nationType.isIndian() ? ut -> ut.hasAbility("model.ability.bornInIndianSettlement") && !ut.hasAbility("model.ability.refUnit") : (nationType.isREF() ? ut -> !ut.hasAbility("model.ability.bornInIndianSettlement") && ut.hasAbility("model.ability.refUnit") : ut -> !ut.hasAbility("model.ability.bornInIndianSettlement") && !ut.hasAbility("model.ability.refUnit")));
        return CollectionUtils.find(this.defaultUnitTypes, p, this.getDefaultUnitType());
    }

    public UnitType getDefaultUnitType() {
        return this.getUnitType("model.unit.freeColonist");
    }

    public List<UnitType> getBuildableUnitTypes() {
        return this.buildableUnitTypes;
    }

    public UnitType getExpertForProducing(GoodsType goodsType) {
        return this.experts.get(goodsType);
    }

    public List<UnitType> getUnitTypesWithAbility(String ... abilities) {
        return this.getTypesWithAbility(UnitType.class, abilities);
    }

    public List<UnitType> getUnitTypesWithoutAbility(String ... abilities) {
        return this.getTypesWithoutAbility(UnitType.class, abilities);
    }

    public List<UnitType> getUnitTypesTrainedInEurope() {
        return this.unitTypesTrainedInEurope;
    }

    public List<UnitType> getUnitTypesPurchasedInEurope() {
        return this.unitTypesPurchasedInEurope;
    }

    public UnitType getFastestLandUnitType() {
        return this.fastestLandUnitType;
    }

    public UnitType getFastestNavalUnitType() {
        return this.fastestNavalUnitType;
    }

    public List<UnitType> getREFUnitTypes(boolean naval) {
        return this.getUnitTypesWithAbility("model.ability.refUnit").stream().filter(ut -> ut.isNaval() == naval).collect(Collectors.toList());
    }

    public UnitType getUnitType(String id) {
        return this.getType(id, UnitType.class);
    }

    public List<FoundingFather> getFoundingFathers() {
        return this.foundingFathers;
    }

    public FoundingFather getFoundingFather(String id) {
        return this.getType(id, FoundingFather.class);
    }

    public List<NationType> getNationTypes() {
        return this.nationTypes;
    }

    public List<EuropeanNationType> getEuropeanNationTypes() {
        return this.europeanNationTypes;
    }

    public List<EuropeanNationType> getREFNationTypes() {
        return this.REFNationTypes;
    }

    public List<IndianNationType> getIndianNationTypes() {
        return this.indianNationTypes;
    }

    public NationType getNationType(String id) {
        return this.getType(id, NationType.class);
    }

    public NationType getDefaultNationType() {
        return this.getNationType("model.nationType.default");
    }

    public List<Nation> getNations() {
        return this.nations;
    }

    public List<Nation> getEuropeanNations() {
        return this.europeanNations;
    }

    public List<Nation> getIndianNations() {
        return this.indianNations;
    }

    public List<Nation> getREFNations() {
        return this.REFNations;
    }

    public Nation getNation(String id) {
        return this.getType(id, Nation.class);
    }

    public void clearEuropeanNationalAdvantages() {
        for (Nation n : this.getEuropeanNations()) {
            n.setType(this.getDefaultNationType());
        }
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public Role getRole(String id) {
        return this.getType(id, Role.class);
    }

    public Role getDefaultRole() {
        return this.getRole(DEFAULT_ROLE_ID);
    }

    public List<Role> getMilitaryRoles() {
        if (this.militaryRoles == null) {
            this.militaryRoles = Collections.unmodifiableList(this.roles.stream().filter(Role::isOffensive).sorted(Role.militaryComparator).collect(Collectors.toList()));
        }
        return this.militaryRoles;
    }

    public Role getRoleWithAbility(String id, List<Role> roles) {
        return CollectionUtils.find(this.getRoles(), r -> r.hasAbility(id));
    }

    public Role getMissionaryRole() {
        return this.getRoleWithAbility("model.ability.establishMission", null);
    }

    public Role getPioneerRole() {
        return this.getRoleWithAbility("model.ability.improveTerrain", null);
    }

    public Role getScoutRole() {
        return this.getRoleWithAbility("model.ability.speakWithChief", null);
    }

    public List<Role> getREFRoles(boolean naval) {
        return (naval ? Stream.of(this.getDefaultRole()) : this.getMilitaryRoles().stream().filter(r -> r.requiresAbility("model.ability.refUnit"))).collect(Collectors.toList());
    }

    public EquipmentType getEquipmentType(String id) {
        return this.getType(id, EquipmentType.class);
    }

    public List<OptionGroup> getDifficultyLevels() {
        ArrayList<OptionGroup> result = new ArrayList<OptionGroup>();
        OptionGroup group = this.allOptionGroups.get(DIFFICULTY_LEVELS);
        if (group != null) {
            for (Option option : group.getOptions()) {
                if (!(option instanceof OptionGroup)) continue;
                result.add((OptionGroup)option);
            }
        }
        return result;
    }

    public String getDifficultyLevel() {
        return this.difficultyLevel;
    }

    public OptionGroup getDifficultyOptionGroup() {
        return this.allOptionGroups.get(this.difficultyLevel);
    }

    public OptionGroup getDifficultyOptionGroup(String id) {
        return this.allOptionGroups.get(id);
    }

    public void applyDifficultyLevel(String difficulty) {
        this.applyDifficultyLevel(this.getDifficultyOptionGroup(difficulty));
    }

    public void applyDifficultyLevel(OptionGroup level) {
        if (level == null) {
            logger.warning("Null difficulty level supplied");
            return;
        }
        logger.info("Applying difficulty level " + level.getId());
        this.addOptionGroup(level, true);
        this.difficultyLevel = level.getId();
    }

    public OptionGroup getGameOptions() {
        return this.getOptionGroup(GameOptions.getXMLElementTagName());
    }

    public void setGameOptions(OptionGroup go) {
        this.allOptionGroups.put(GameOptions.getXMLElementTagName(), go);
        this.addOptionGroup(go, true);
    }

    public OptionGroup getMapGeneratorOptions() {
        return this.getOptionGroup(MapGeneratorOptions.getXMLElementTagName());
    }

    public void setMapGeneratorOptions(OptionGroup mgo) {
        this.allOptionGroups.put(MapGeneratorOptions.getXMLElementTagName(), mgo);
        this.addOptionGroup(mgo, true);
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public Event getEvent(String id) {
        return this.getType(id, Event.class);
    }

    public List<Disaster> getDisasters() {
        return this.disasters;
    }

    public Disaster getDisaster(String id) {
        return this.getType(id, Disaster.class);
    }

    public int getAge(Turn turn) {
        int n = turn.getNumber();
        return n < this.ages[0] ? -1 : (n < this.ages[1] ? 0 : (n < this.ages[2] ? 1 : 2));
    }

    public <T extends FreeColGameObjectType> T getType(String id, Class<T> type) {
        FreeColGameObjectType o = this.findType(id);
        if (o != null) {
            return (T)((FreeColGameObjectType)type.cast(this.allTypes.get(id)));
        }
        if (this.initialized) {
            throw new IllegalArgumentException("Undefined FCGOT: " + id);
        }
        try {
            Constructor<T> c = type.getConstructor(String.class, Specification.class);
            FreeColGameObjectType result = (FreeColGameObjectType)c.newInstance(id, this);
            this.allTypes.put(id, result);
            return (T)result;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not construct: " + id, e);
            return null;
        }
    }

    public FreeColGameObjectType findType(String id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("Null id");
        }
        if (this.allTypes.containsKey(id)) {
            return this.allTypes.get(id);
        }
        return null;
    }

    public List<FreeColGameObjectType> getTypesProviding(String id, boolean value) {
        ArrayList<FreeColGameObjectType> result = new ArrayList<FreeColGameObjectType>();
        for (Ability ability : this.getAbilities(id)) {
            if (ability.getValue() != value || !(ability.getSource() instanceof FreeColGameObjectType)) continue;
            result.add((FreeColGameObjectType)ability.getSource());
        }
        return result;
    }

    public <T extends FreeColGameObjectType> List<T> getTypesWithAbility(Class<T> resultType, String ... abilities) {
        return this.allTypes.values().stream().filter(type -> resultType.isInstance(type) && CollectionUtils.any(abilities, a -> type.hasAbility((String)a))).map(type -> (FreeColGameObjectType)resultType.cast(type)).collect(Collectors.toList());
    }

    public <T extends FreeColGameObjectType> List<T> getTypesWithoutAbility(Class<T> resultType, String ... abilities) {
        return this.allTypes.values().stream().filter(type -> resultType.isInstance(type) && CollectionUtils.none(abilities, a -> type.hasAbility((String)a))).map(type -> (FreeColGameObjectType)resultType.cast(type)).collect(Collectors.toList());
    }

    private void applyFixes() {
        this.fixDifficultyOptions();
        this.fixGameOptions();
        this.fixMapGeneratorOptions();
        this.fixSpec();
    }

    private void fixRoles() {
        boolean zero10X;
        try {
            zero10X = Double.parseDouble(this.version) < 0.86;
        }
        catch (Exception e) {
            zero10X = true;
        }
        if (!zero10X) {
            return;
        }
        File base = FreeColDirectories.getBaseDirectory();
        File rolf = new File(base, ROLES_COMPAT_FILE_NAME);
        try (FileInputStream fis = new FileInputStream(rolf);){
            this.load(fis);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to load remedial roles.", e);
            return;
        }
        logger.info("Loading role backward compatibility fragment: roles-compat.xml with roles: " + this.getRoles().stream().map(FreeColObject::getId).collect(Collectors.joining()));
    }

    /*
     * WARNING - void declaration
     */
    private void fixSpec() {
        UnitType unitType;
        Limit limit;
        Event event;
        BuildingType buildingType;
        void var9_93;
        void var9_86;
        void var9_84;
        if (this.getModifiers("model.modifier.shipTradePenalty") == null) {
            this.addModifier(new Modifier("model.modifier.shipTradePenalty", -30.0f, Modifier.ModifierType.PERCENTAGE, SHIP_TRADE_PENALTY_SOURCE));
        }
        FoundingFather brebeuf = this.getFoundingFather("model.foundingFather.fatherJeanDeBrebeuf");
        for (Ability ability : brebeuf.getAbilities()) {
            for (Scope scope : ability.getScopes()) {
                if (!"model.ability.missionary".equals(scope.getAbilityId())) continue;
                scope.setAbilityId("model.ability.establishMission");
            }
        }
        FoundingFather coronado = this.getFoundingFather("model.foundingFather.franciscoDeCoronado");
        if ("freecol".equals(this.getId()) && !coronado.hasAbility("model.ability.seeAllColonies")) {
            coronado.addAbility(new Ability("model.ability.seeAllColonies", coronado, true));
        }
        this.fatherGoodsFixMap.clear();
        this.fatherGoodsFixMap.put("model.foundingFather.thomasJefferson", "model.goods.bells");
        this.fatherGoodsFixMap.put("model.foundingFather.thomasPaine", "model.goods.bells");
        this.fatherGoodsFixMap.put("model.foundingFather.williamPenn", "model.goods.crosses");
        for (Map.Entry<String, String> entry : this.fatherGoodsFixMap.entrySet()) {
            FoundingFather foundingFather = this.getFoundingFather(entry.getKey());
            for (Modifier modifier : foundingFather.getModifiers(entry.getValue())) {
                modifier.requireNegatedPersonScope();
            }
        }
        for (EuropeanNationType europeanNationType : this.europeanNationTypes) {
            if (!europeanNationType.hasAbility("model.ability.foundColony")) continue;
            europeanNationType.removeAbilities("model.ability.foundColony");
            europeanNationType.addAbility(new Ability("model.ability.foundsColonies", europeanNationType, true));
        }
        for (OptionGroup optionGroup : this.getDifficultyLevels()) {
            Option option = optionGroup.getOption("model.difficulty.monarch");
            Option refSize = ((OptionGroup)(option instanceof OptionGroup ? option : optionGroup)).getOption("model.option.refSize");
            if (refSize == null || !(refSize instanceof UnitListOption)) continue;
            for (AbstractUnit au : ((UnitListOption)refSize).getOptionValues()) {
                if ("DEFAULT".equals(au.getRoleId())) {
                    au.setRoleId(DEFAULT_ROLE_ID);
                    continue;
                }
                if ("model.role.soldier".equals(au.getRoleId()) || "SOLDIER".equals(au.getRoleId())) {
                    au.setRoleId("model.role.infantry");
                    continue;
                }
                if (!"model.role.dragoon".equals(au.getRoleId()) && !"DRAGOON".equals(au.getRoleId())) continue;
                au.setRoleId("model.role.cavalry");
            }
        }
        ArrayList<OptionGroup> arrayList = new ArrayList<OptionGroup>(this.getDifficultyLevels());
        while (!arrayList.isEmpty()) {
            Option option = (Option)arrayList.remove(0);
            if (option instanceof OptionGroup) {
                List<Option> list = ((OptionGroup)option).getOptions();
                arrayList.addAll(new ArrayList<Option>(list));
                continue;
            }
            if (!(option instanceof UnitListOption)) continue;
            for (Object au : ((UnitListOption)option).getOptionValues()) {
                String string = ((AbstractUnit)au).getRoleId();
                if (string == null) {
                    ((AbstractUnit)au).setRoleId(DEFAULT_ROLE_ID);
                    continue;
                }
                if (((AbstractUnit)au).getRoleId().startsWith("model.role.")) continue;
                if ("DEFAULT".equals(((AbstractUnit)au).getRoleId())) {
                    ((AbstractUnit)au).setRoleId(DEFAULT_ROLE_ID);
                    continue;
                }
                if ("DRAGOON".equals(((AbstractUnit)au).getRoleId())) {
                    ((AbstractUnit)au).setRoleId("model.role.dragoon");
                    continue;
                }
                if ("MISSIONARY".equals(((AbstractUnit)au).getRoleId())) {
                    ((AbstractUnit)au).setRoleId("model.role.missionary");
                    continue;
                }
                if ("PIONEER".equals(((AbstractUnit)au).getRoleId())) {
                    ((AbstractUnit)au).setRoleId("model.role.pioneer");
                    continue;
                }
                if ("MISSIONARY".equals(((AbstractUnit)au).getRoleId())) {
                    ((AbstractUnit)au).setRoleId("model.role.missionary");
                    continue;
                }
                if ("SCOUT".equals(((AbstractUnit)au).getRoleId())) {
                    ((AbstractUnit)au).setRoleId("model.role.scout");
                    continue;
                }
                if ("SOLDIER".equals(((AbstractUnit)au).getRoleId())) {
                    ((AbstractUnit)au).setRoleId("model.role.soldier");
                    continue;
                }
                ((AbstractUnit)au).setRoleId(DEFAULT_ROLE_ID);
            }
        }
        for (NationType nationType : this.europeanNationTypes) {
            if (!nationType.isREF() || nationType.hasAbility("model.ability.independentNation")) continue;
            nationType.addAbility(new Ability("model.ability.independentNation"));
        }
        for (ResourceType resourceType : this.resourceTypeList) {
            for (Modifier modifier : resourceType.getModifiers()) {
                modifier.setModifierIndex(10);
            }
        }
        for (UnitType unitType2 : this.unitTypeList) {
            for (Modifier modifier : unitType2.getModifiers()) {
                if (!(this.allTypes.get(modifier.getId()) instanceof GoodsType)) continue;
                modifier.setModifierIndex(30);
            }
        }
        for (FoundingFather foundingFather : this.foundingFathers) {
            for (Modifier modifier : foundingFather.getModifiers()) {
                if (!(this.allTypes.get(modifier.getId()) instanceof GoodsType)) continue;
                modifier.setModifierIndex(40);
            }
        }
        for (TileImprovementType tileImprovementType : this.tileImprovementTypeList) {
            for (Modifier modifier : tileImprovementType.getModifiers()) {
                if (!(this.allTypes.get(modifier.getId()) instanceof GoodsType)) continue;
                modifier.setModifierIndex(50);
            }
        }
        for (BuildingType buildingType2 : this.buildingTypeList) {
            for (Modifier modifier : buildingType2.getModifiers()) {
                if (!(this.allTypes.get(modifier.getId()) instanceof GoodsType)) continue;
                modifier.setModifierIndex(buildingType2.hasAbility("model.ability.autoProduction") ? 60 : 70);
            }
        }
        for (EuropeanNationType europeanNationType : this.europeanNationTypes) {
            for (Modifier modifier : europeanNationType.getModifiers()) {
                if (!(this.allTypes.get(modifier.getId()) instanceof GoodsType)) continue;
                modifier.setModifierIndex(80);
            }
        }
        BuildingType buildingType3 = this.getBuildingType("model.building.townHall");
        if (buildingType3.hasModifier("model.goods.bells")) {
            GoodsType goodsType = this.getGoodsType("model.goods.bells");
            AbstractGoods ag = new AbstractGoods(goodsType, 1);
            ProductionType productionType = new ProductionType(ag, true, null);
            buildingType3.addProductionType(productionType);
            buildingType3.removeModifiers("model.goods.bells");
            logger.info("Added backward compatibility production " + productionType + " to " + buildingType3);
        }
        GoodsType goodsType = this.getGoodsType("model.goods.crosses");
        int a = 1;
        BuildingType[] buildingTypeArray = new BuildingType[]{this.getBuildingType("model.building.chapel"), this.getBuildingType("model.building.church"), this.getBuildingType("model.building.cathedral")};
        int au = buildingTypeArray.length;
        boolean bl = false;
        while (var9_84 < au) {
            BuildingType buildingType4 = buildingTypeArray[var9_84];
            if (buildingType4.hasModifier("model.goods.crosses")) {
                AbstractGoods abstractGoods = new AbstractGoods(goodsType, a);
                ++a;
                ProductionType productionType = new ProductionType(abstractGoods, true, null);
                buildingType4.addProductionType(productionType);
                buildingType4.removeModifiers("model.goods.crosses");
                logger.info("Added backward compatibility production " + productionType + " to " + buildingType4);
            }
            ++var9_84;
        }
        BuildingType[] buildingTypeArray2 = new BuildingType[]{this.getBuildingType("model.building.country"), this.getBuildingType("model.building.stables")};
        au = buildingTypeArray2.length;
        boolean bl2 = false;
        while (var9_86 < au) {
            BuildingType buildingType5 = buildingTypeArray2[var9_86];
            for (ProductionType productionType : buildingType5.getAvailableProductionTypes(false)) {
                productionType.setUnattended(true);
                logger.info("Switched production " + productionType + " to unattended at " + buildingType5);
            }
            ++var9_86;
        }
        if (this.getNation("model.nation.unknownEnemy") == null) {
            Nation nation = new Nation("model.nation.unknownEnemy", this);
            nation.setColor(Nation.UNKNOWN_NATION_COLOR);
        }
        if (this.getAbilities("model.ability.ambushTerrain") == null) {
            Ability ability = new Ability("model.ability.ambushTerrain", null, true);
            this.addAbility(ability);
            for (TileType tileType : this.getTileTypeList()) {
                if (!tileType.isElevation() && !tileType.isForested() || tileType.hasAbility("model.ability.ambushTerrain")) continue;
                tileType.addAbility(new Ability("model.ability.ambushTerrain", tileType, true));
            }
        }
        GoodsType goodsType2 = this.getGoodsType("model.goods.horses");
        goodsType2.setMilitary();
        GoodsType goodsType3 = this.getGoodsType("model.goods.muskets");
        goodsType3.setMilitary();
        for (NationType nationType : this.indianNationTypes) {
            for (Ability ability : nationType.getAbilities("model.ability.automaticEquipment")) {
                for (Scope scope : ability.getScopes()) {
                    String type = scope.getType();
                    if ("model.equipment.indian.muskets".equals(type)) {
                        scope.setType("model.role.nativeDragoon");
                        continue;
                    }
                    if (!"model.equipment.indian.horses".equals(type)) continue;
                    scope.setType("model.role.armedBrave");
                }
            }
        }
        FoundingFather revere = this.getFoundingFather("model.foundingFather.paulRevere");
        for (Ability ability : revere.getAbilities("model.ability.automaticEquipment")) {
            for (Scope scope : ability.getScopes()) {
                String type = scope.getType();
                if (!"model.equipment.muskets".equals(type)) continue;
                scope.setType("model.role.soldier");
            }
        }
        FoundingFather bolivar = this.getFoundingFather("model.foundingFather.simonBolivar");
        boolean bl3 = false;
        if (!bolivar.getEvents().isEmpty()) {
            bolivar.setEvents(Collections.emptyList());
            boolean bl4 = true;
        } else if (bolivar.hasModifier("model.modifier.liberty")) {
            bolivar.removeModifiers("model.modifier.liberty");
            boolean bl5 = true;
        }
        if (var9_93 != false) {
            bolivar.addModifier(new Modifier("model.modifier.SoL", 20.0f, Modifier.ModifierType.ADDITIVE, bolivar, 0));
        }
        if (!(buildingType = this.getBuildingType("model.building.customHouse")).hasAbility("model.ability.coastalOnly")) {
            buildingType.addAbility(new Ability("model.ability.coastalOnly", null, false));
        }
        if (this.getModifiers("model.modifier.cargoPenalty").isEmpty()) {
            this.addModifier(new Modifier("model.modifier.cargoPenalty", -12.5f, Modifier.ModifierType.PERCENTAGE, CARGO_PENALTY_SOURCE, 50));
        }
        if ((event = this.getEvent("model.event.declareIndependence")) != null && (limit = event.getLimit("model.limit.independence.coastalColonies")) != null) {
            limit.setOperator(Limit.Operator.GE);
            limit.getRightHandSide().setValue(1);
        }
        if ((unitType = this.getUnitType("model.unit.hardyPioneer")).getModifiers("model.modifier.tileTypeChangeProduction").isEmpty()) {
            Modifier m = new Modifier("model.modifier.tileTypeChangeProduction", 2.0f, Modifier.ModifierType.MULTIPLICATIVE);
            Scope scope = new Scope();
            scope.setType("model.goods.lumber");
            m.addScope(scope);
            unitType.addModifier(m);
        }
        if (!coronado.hasModifier("model.modifier.exposedTilesRadius")) {
            coronado.addModifier(new Modifier("model.modifier.exposedTilesRadius", 3.0f, Modifier.ModifierType.ADDITIVE, coronado, 0));
        }
    }

    private boolean fixDifficultyOptions() {
        AbstractUnitOption menOfWar;
        AbstractUnitOption artillery;
        AbstractUnitOption dragoons;
        AbstractUnitOption regulars;
        boolean ret = false;
        ret |= this.checkDifficultyOptionGroup("model.difficulty.immigration", "model.option.crossesIncrement", "model.option.recruitPriceIncrease", "model.option.lowerCapIncrease", "model.option.priceIncrease.artillery", "model.option.priceIncreasePerType", "model.option.expertStartingUnits", "model.option.immigrants");
        ret |= this.checkDifficultyOptionGroup("model.difficulty.natives", "model.option.landPriceFactor", "model.option.nativeConvertProbability", "model.option.burnProbability", "model.option.nativeDemands", "model.option.rumourDifficulty", "model.option.shipTradePenalty", "model.option.buildOnNativeLand", "model.option.settlementNumber");
        ret |= this.checkDifficultyOptionGroup("model.difficulty.monarch", "model.option.monarchMeddling", "model.option.taxAdjustment", "model.option.mercenaryPrice", "model.option.maximumTax", "model.option.monarchSupport", "model.option.treasureTransportFee", "model.option.refSize", "model.option.interventionBells", "model.option.interventionTurns", "model.option.interventionForce", "model.option.mercenaryForce");
        ret |= this.checkDifficultyOptionGroup("model.difficulty.government", "model.option.badGovernmentLimit", "model.option.veryBadGovernmentLimit", "model.option.goodGovernmentLimit", "model.option.veryGoodGovernmentLimit");
        ret |= this.checkDifficultyOptionGroup("model.difficulty.other", "model.option.startingMoney", "model.option.foundingFatherFactor", "model.option.arrearsFactor", "model.option.unitsThatUseNoBells", "model.option.tileProduction");
        ret |= this.checkDifficultyOptionGroup("model.difficulty.cheat", "model.option.liftBoycottCheat", "model.option.equipScoutCheat", "model.option.landUnitCheat", "model.option.offensiveNavalUnitCheat", "model.option.transportNavalUnitCheat");
        ret |= this.checkDifficultyIntegerOption("model.option.shipTradePenalty", "model.difficulty.natives", -30);
        String id = "model.option.refSize";
        UnitListOption ulo = this.checkDifficultyUnitListOption(id, "model.difficulty.monarch");
        if (ulo != null) {
            regulars = new AbstractUnitOption(id + ".regulars", this);
            regulars.setValue(new AbstractUnit("model.unit.kingsRegular", "model.role.infantry", 31));
            ulo.getValue().add(regulars);
            dragoons = new AbstractUnitOption(id + ".dragoons", this);
            dragoons.setValue(new AbstractUnit("model.unit.kingsRegular", "model.role.cavalry", 15));
            ulo.getValue().add(dragoons);
            artillery = new AbstractUnitOption(id + ".artillery", this);
            artillery.setValue(new AbstractUnit("model.unit.artillery", DEFAULT_ROLE_ID, 14));
            ulo.getValue().add(artillery);
            menOfWar = new AbstractUnitOption(id + ".menOfWar", this);
            menOfWar.setValue(new AbstractUnit("model.unit.manOWar", DEFAULT_ROLE_ID, 8));
            ulo.getValue().add(menOfWar);
            ret = true;
        }
        if ((ulo = this.checkDifficultyUnitListOption(id = "model.option.immigrants", "model.difficulty.immigration")) != null) {
            AbstractUnitOption i1 = new AbstractUnitOption(id + ".1", this);
            i1.setValue(new AbstractUnit("model.unit.masterCarpenter", DEFAULT_ROLE_ID, 1));
            ulo.getValue().add(i1);
            ret = true;
        }
        ret |= this.checkDifficultyIntegerOption("model.option.interventionBells", "model.difficulty.monarch", 5000);
        ret |= this.checkDifficultyIntegerOption("model.option.interventionTurns", "model.difficulty.monarch", 52);
        id = "model.option.interventionForce";
        ulo = this.checkDifficultyUnitListOption(id, "model.difficulty.monarch");
        if (ulo != null) {
            regulars = new AbstractUnitOption(id + ".regulars", this);
            regulars.setValue(new AbstractUnit("model.unit.colonialRegular", "model.role.soldier", 2));
            ulo.getValue().add(regulars);
            dragoons = new AbstractUnitOption(id + ".dragoons", this);
            dragoons.setValue(new AbstractUnit("model.unit.colonialRegular", "model.role.dragoon", 2));
            ulo.getValue().add(dragoons);
            artillery = new AbstractUnitOption(id + ".artillery", this);
            artillery.setValue(new AbstractUnit("model.unit.artillery", DEFAULT_ROLE_ID, 2));
            ulo.getValue().add(artillery);
            menOfWar = new AbstractUnitOption(id + ".menOfWar", this);
            menOfWar.setValue(new AbstractUnit("model.unit.manOWar", DEFAULT_ROLE_ID, 2));
            ulo.getValue().add(menOfWar);
            ret = true;
        }
        if ((ulo = this.checkDifficultyUnitListOption(id = "model.option.mercenaryForce", "model.difficulty.monarch")) != null) {
            regulars = new AbstractUnitOption(id + ".regulars", this);
            regulars.setValue(new AbstractUnit("model.unit.veteranSoldier", "model.role.soldier", 2));
            ulo.getValue().add(regulars);
            dragoons = new AbstractUnitOption(id + ".dragoons", this);
            dragoons.setValue(new AbstractUnit("model.unit.veteranSoldier", "model.role.dragoon", 2));
            ulo.getValue().add(dragoons);
            artillery = new AbstractUnitOption(id + ".artillery", this);
            artillery.setValue(new AbstractUnit("model.unit.artillery", DEFAULT_ROLE_ID, 2));
            ulo.getValue().add(artillery);
            menOfWar = new AbstractUnitOption(id + ".menOfWar", this);
            menOfWar.setValue(new AbstractUnit("model.unit.manOWar", DEFAULT_ROLE_ID, 2));
            ulo.getValue().add(menOfWar);
            ret = true;
        }
        ret |= this.checkDifficultyIntegerOption("model.option.goodGovernmentLimit", "model.difficulty.government", 50);
        ret |= this.checkDifficultyIntegerOption("model.option.veryGoodGovernmentLimit", "model.difficulty.government", 100);
        ret |= this.checkDifficultyIntegerOption("model.option.liftBoycottCheat", "model.difficulty.cheat", 10);
        ret |= this.checkDifficultyIntegerOption("model.option.equipScoutCheat", "model.difficulty.cheat", 10);
        ret |= this.checkDifficultyIntegerOption("model.option.landUnitCheat", "model.difficulty.cheat", 10);
        ret |= this.checkDifficultyIntegerOption("model.option.offensiveNavalUnitCheat", "model.difficulty.cheat", 10);
        ret |= this.checkDifficultyIntegerOption("model.option.transportNavalUnitCheat", "model.difficulty.cheat", 10);
        ret |= this.checkDifficultyIntegerOption("model.option.destroySettlementScore", "model.difficulty.natives", -5);
        ret |= this.checkDifficultyIntegerOption("model.option.badRumour", "model.difficulty.other", 23);
        ret |= this.checkDifficultyIntegerOption("model.option.goodRumour", "model.difficulty.other", 48);
        ret |= this.checkDifficultyIntegerOption("model.option.offensiveLandUnitCheat", "model.difficulty.cheat", 4);
        ret |= this.checkDifficultyIntegerOption("model.option.equipPioneerCheat", "model.difficulty.cheat", 10);
        id = "model.option.warSupportForce";
        ulo = this.checkDifficultyUnitListOption(id, "model.difficulty.monarch");
        if (ulo != null) {
            AbstractUnitOption support = new AbstractUnitOption(id, this);
            support.setValue(new AbstractUnit("model.unit.veteranSoldier", "model.role.soldier", 4));
            ulo.getValue().add(support);
            ret = true;
        }
        return ret |= this.checkDifficultyIntegerOption("model.option.warSupportGold", "model.difficulty.monarch", 1500);
    }

    private boolean checkDifficultyOptionGroup(String gr, String ... ids) {
        logger.info("Check group " + gr);
        boolean ret = false;
        for (OptionGroup level : this.getDifficultyLevels()) {
            OptionGroup og;
            Option op = level.getOption(gr);
            if (op instanceof OptionGroup) {
                og = (OptionGroup)op;
            } else {
                og = new OptionGroup(gr, this);
                level.add(og);
                og.setGroup(level.getId());
                ret = true;
            }
            for (String id : ids) {
                op = level.remove(id);
                if (op == null) continue;
                if (op instanceof AbstractOption) {
                    ((AbstractOption)op).setGroup(og.getId());
                }
                og.add(op);
                ret = true;
            }
        }
        return ret;
    }

    private boolean checkDifficultyIntegerOption(String id, String gr, int defaultValue) {
        boolean ret = false;
        for (OptionGroup level : this.getDifficultyLevels()) {
            OptionGroup og;
            Option op = level.getOption(gr);
            if (!(op instanceof OptionGroup) || (op = (og = (OptionGroup)op).getOption(id)) != null) continue;
            IntegerOption iop = new IntegerOption(id, this);
            iop.setGroup(gr);
            iop.setValue(defaultValue);
            og.add(iop);
            ret = true;
        }
        if (ret) {
            logger.info("Added difficulty integer option: " + id);
        }
        return ret;
    }

    private UnitListOption checkDifficultyUnitListOption(String id, String gr) {
        UnitListOption ulo = null;
        for (OptionGroup level : this.getDifficultyLevels()) {
            OptionGroup og;
            Option op = level.getOption(gr);
            if (!(op instanceof OptionGroup) || (og = (OptionGroup)op).getOption(id) instanceof UnitListOption) continue;
            if (ulo == null) {
                ulo = new UnitListOption(id, this);
            }
            og.add(ulo);
        }
        if (ulo != null) {
            logger.info("Added difficulty unit list option: " + id);
        }
        return ulo;
    }

    public boolean fixGameOptions() {
        boolean ret = false;
        ret |= this.checkOptionGroup("gameOptions.years");
        String[] years = new String[]{"model.option.startingYear", "model.option.seasonYear", "model.option.mandatoryColonyYear", "model.option.lastYear", "model.option.lastColonialYear"};
        int[] values = new int[]{1492, 1600, 1600, 1850, 1800};
        for (int index = 0; index < years.length; ++index) {
            ret |= this.checkIntegerOption(years[index], "gameOptions.years", values[index]);
        }
        ret |= this.checkBooleanOption("model.option.enhancedMissionaries", "gameOptions.map", false);
        ret |= this.checkBooleanOption("model.option.continueFoundingFatherRecruitment", "gameOptions.map", false);
        ret |= this.checkIntegerOption("model.option.settlementLimitModifier", "gameOptions.map", 0);
        ret |= this.checkBooleanOption("model.option.settlementActionsContactChief", "gameOptions.map", false);
        ret |= this.checkIntegerOption("model.option.startingPositions", "gameOptions.map", 0);
        ret |= this.checkBooleanOption("model.option.teleportREF", "gameOptions.map", false);
        ret |= this.checkBooleanOption("model.option.enableUpkeep", "gameOptions.colony", false);
        ret |= this.checkIntegerOption("model.option.naturalDisasters", "gameOptions.colony", 0);
        ret |= this.checkIntegerOption("model.option.giftProbability", "gameOptions.map", 5);
        ret |= this.checkIntegerOption("model.option.demandProbability", "gameOptions.map", 10);
        ret |= this.checkBooleanOption("model.option.emptyTraders", "gameOptions.map", false);
        ret |= this.checkBooleanOption("model.option.onlyNaturalImprovements", "gameOptions.colony", true);
        ret |= this.checkIntegerOption("model.option.peaceProbability", "gameOptions.map", 90);
        ret |= this.checkIntegerOption("model.option.initialImmigration", "gameOptions.map", 15);
        ret |= this.checkIntegerOption("model.option.europeanUnitImmigrationPenalty", "gameOptions.map", -4);
        ret |= this.checkIntegerOption("model.option.playerImmigrationBonus", "gameOptions.map", 2);
        ret |= this.checkBooleanOption("model.option.foundColonyDuringRebellion", "gameOptions.colony", true);
        ret |= this.checkBooleanOption("model.option.bellAccumulationCapped", "gameOptions.colony", false);
        ret |= this.checkBooleanOption("model.option.captureUnitsUnderRepair", "gameOptions.colony", false);
        ret |= this.checkBooleanOption("model.option.payForBuilding", "gameOptions.colony", true);
        ret |= this.checkBooleanOption("model.option.clearHammersOnConstructionSwitch", "gameOptions.colony", false);
        ret |= this.checkBooleanOption("model.option.customsOnCoast", "gameOptions.colony", false);
        ret |= this.checkBooleanOption("model.option.equipEuropeanRecruits", "gameOptions.colony", true);
        ret |= this.checkIntegerOption("model.option.missionInfluence", "gameOptions.map", -10);
        ret |= this.checkIntegerOption("model.option.independenceTurn", "gameOptions.years", 468);
        ret |= this.checkTextOption("model.option.ages", "gameOptions.years", "1600,1700");
        ret |= this.checkIntegerOption("model.option.seasons", "gameOptions.years", 2);
        return ret |= this.checkBooleanOption("model.option.disembarkInColony", "gameOptions.colony", false);
    }

    public boolean fixMapGeneratorOptions() {
        boolean ret = false;
        ret |= this.checkIntegerOption("model.option.minimumLatitude", "mapGeneratorOptions.terrainGenerator", -90);
        return ret |= this.checkIntegerOption("model.option.maximumLatitude", "mapGeneratorOptions.terrainGenerator", 90);
    }

    private boolean checkOptionGroup(String id) {
        if (this.allOptionGroups.containsKey(id)) {
            return false;
        }
        OptionGroup og = new OptionGroup(id, this);
        this.allOptionGroups.put(id, og);
        return true;
    }

    private boolean checkBooleanOption(String id, String gr, boolean defaultValue) {
        if (this.hasOption(id)) {
            return false;
        }
        BooleanOption op = new BooleanOption(id, this);
        op.setGroup(gr);
        op.setValue(defaultValue);
        return this.checkOption(op);
    }

    private boolean checkIntegerOption(String id, String gr, int defaultValue) {
        if (this.hasOption(id)) {
            return false;
        }
        IntegerOption op = new IntegerOption(id, this);
        op.setGroup(gr);
        op.setValue(defaultValue);
        return this.checkOption(op);
    }

    private boolean checkStringOption(String id, String gr, String defaultValue) {
        if (this.hasOption(id)) {
            return false;
        }
        StringOption op = new StringOption(id, this);
        op.setGroup(gr);
        op.setValue(defaultValue);
        return this.checkOption(op);
    }

    private boolean checkTextOption(String id, String gr, String defaultValue) {
        if (this.hasOption(id)) {
            return false;
        }
        TextOption op = new TextOption(id, this);
        op.setGroup(gr);
        op.setValue(defaultValue);
        return this.checkOption(op);
    }

    private boolean checkOption(AbstractOption option) {
        this.getOptionGroup(option.getGroup()).add(option);
        this.addAbstractOption(option);
        return true;
    }

    protected void toXML(FreeColXMLWriter xw) throws XMLStreamException {
        xw.writeStartElement(Specification.getXMLElementTagName());
        xw.writeAttribute("id", this.getId());
        if (this.difficultyLevel != null) {
            xw.writeAttribute(DIFFICULTY_LEVEL_TAG, this.difficultyLevel);
        }
        if (this.version != null) {
            xw.writeAttribute(VERSION_TAG, this.version);
        }
        this.writeSection(xw, MODIFIERS_TAG, this.specialModifiers);
        this.writeSection(xw, EVENTS_TAG, this.events);
        this.writeSection(xw, DISASTERS_TAG, this.disasters);
        this.writeSection(xw, GOODS_TYPES_TAG, this.goodsTypeList);
        this.writeSection(xw, RESOURCE_TYPES_TAG, this.resourceTypeList);
        this.writeSection(xw, TILE_TYPES_TAG, this.tileTypeList);
        this.writeSection(xw, ROLES_TAG, this.roles);
        this.writeSection(xw, TILE_IMPROVEMENT_TYPES_TAG, this.tileImprovementTypeList);
        this.writeSection(xw, UNIT_TYPES_TAG, this.unitTypeList);
        this.writeSection(xw, BUILDING_TYPES_TAG, this.buildingTypeList);
        this.writeSection(xw, FOUNDING_FATHERS_TAG, this.foundingFathers);
        this.writeSection(xw, EUROPEAN_NATION_TYPES_TAG, this.europeanNationTypes);
        this.writeSection(xw, EUROPEAN_NATION_TYPES_TAG, this.REFNationTypes);
        this.writeSection(xw, INDIAN_NATION_TYPES_TAG, this.indianNationTypes);
        this.writeSection(xw, NATIONS_TAG, this.nations);
        xw.writeStartElement(OPTIONS_TAG);
        for (OptionGroup item : this.allOptionGroups.values()) {
            if (!item.getGroup().isEmpty()) continue;
            item.toXML(xw);
        }
        xw.writeEndElement();
        xw.writeEndElement();
    }

    private <T extends FreeColObject> void writeSection(FreeColXMLWriter xw, String section, Collection<T> items) throws XMLStreamException {
        xw.writeStartElement(section);
        for (FreeColObject item : items) {
            item.toXML(xw);
        }
        xw.writeEndElement();
    }

    public void readFromXML(FreeColXMLReader xr) throws XMLStreamException {
        String newId = xr.readId();
        if (this.id == null) {
            this.id = newId;
        }
        if (this.difficultyLevel == null) {
            this.difficultyLevel = xr.getAttribute(DIFFICULTY_LEVEL_TAG, null);
            if (this.difficultyLevel == null) {
                this.difficultyLevel = xr.getAttribute(OLD_DIFFICULTY_LEVEL_TAG, null);
            }
        }
        this.version = xr.getAttribute(VERSION_TAG, null);
        logger.fine("Reading specification " + newId + " difficulty=" + this.difficultyLevel + " version=" + this.version);
        String parentId = xr.getAttribute("extends", null);
        if (parentId != null) {
            try {
                FreeColTcFile parent = new FreeColTcFile(parentId);
                this.load(parent.getSpecificationInputStream());
                this.initialized = false;
            }
            catch (IOException e) {
                throw new XMLStreamException("Failed to open parent specification: ", e);
            }
        }
        while (xr.nextTag() != 2) {
            ChildReader reader;
            String childName = xr.getLocalName();
            if (EQUIPMENT_TYPES_TAG.equals(childName)) {
                this.fixRoles();
            }
            if ((reader = this.readerMap.get(childName)) == null) {
                logger.warning("No reader found for: " + childName);
                continue;
            }
            reader.readChildren(xr);
        }
    }

    public static String getXMLElementTagName() {
        return "freecol-specification";
    }

    private class OptionReader
    implements ChildReader {
        private static final String RECURSIVE_TAG = "recursive";

        private OptionReader() {
        }

        @Override
        public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
            while (xr.nextTag() != 2) {
                this.readChild(xr);
            }
        }

        private void readChild(FreeColXMLReader xr) throws XMLStreamException {
            String tag = xr.getLocalName();
            boolean recursive = xr.getAttribute(RECURSIVE_TAG, true);
            if (OptionGroup.getXMLElementTagName().equals(tag)) {
                String id = xr.readId();
                OptionGroup group = (OptionGroup)Specification.this.allOptionGroups.get(id);
                if (group == null) {
                    group = new OptionGroup(id, Specification.this);
                    Specification.this.allOptionGroups.put(id, group);
                }
                group.readFromXML(xr);
                Specification.this.addOptionGroup(group, recursive);
            } else {
                logger.warning(OptionGroup.getXMLElementTagName() + " expected in OptionReader, not: " + tag);
                xr.nextTag();
            }
        }
    }

    private class TypeReader<T extends FreeColGameObjectType>
    implements ChildReader {
        private final Class<T> type;
        private final List<T> result;
        private int index = 0;

        public TypeReader(Class<T> type, List<T> listToFill) {
            this.result = listToFill;
            this.type = type;
        }

        @Override
        public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
            while (xr.nextTag() != 2) {
                FreeColGameObjectType object;
                String tag = xr.getLocalName();
                String id = xr.readId();
                if (id == null) {
                    logger.warning("Null identifier, tag: " + tag);
                    continue;
                }
                if ("delete".equals(tag)) {
                    object = (FreeColGameObjectType)Specification.this.allTypes.remove(id);
                    if (object == null) continue;
                    this.result.remove(object);
                    continue;
                }
                object = Specification.this.getType(id, this.type);
                Specification.this.allTypes.put(id, object);
                if (object.getId() != null && xr.getAttribute("preserve", null) != null) {
                    object.readChildren(xr);
                } else {
                    object.readFromXML(xr);
                }
                if (object.isAbstractType() || this.result.contains(object)) continue;
                this.result.add(object);
                object.setIndex(this.index);
                ++this.index;
            }
        }
    }

    private class ModifierReader
    implements ChildReader {
        private ModifierReader() {
        }

        @Override
        public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
            while (xr.nextTag() != 2) {
                Modifier modifier = new Modifier(xr, Specification.this);
                Specification.this.addModifier(modifier);
                Specification.this.specialModifiers.add(modifier);
            }
        }
    }

    private static interface ChildReader {
        public void readChildren(FreeColXMLReader var1) throws XMLStreamException;
    }

    public static class Source
    extends FreeColGameObjectType {
        public Source(String id) {
            super(id);
        }

        @Override
        public void toXML(FreeColXMLWriter xw) {
            throw new RuntimeException("Can not happen");
        }

        @Override
        public String toString() {
            return this.getId();
        }

        @Override
        public String getXMLTagName() {
            return "source";
        }
    }
}

