/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.logging;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.logging.TextFormatter;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.util.Utils;

public final class DefaultHandler
extends Handler {
    private final Writer writer;
    private final boolean consoleLogging;

    public DefaultHandler(boolean consoleLogging, String fileName) throws FreeColException {
        this.consoleLogging = consoleLogging;
        File file = new File(fileName);
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new FreeColException("Log file \"" + fileName + "\" could not be created.");
            }
            if (file.isFile()) {
                file.delete();
            }
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new FreeColException("Log file \"" + fileName + "\" could not be created.", e);
        }
        if (!file.canWrite()) {
            throw new FreeColException("Can not write in log file \"" + fileName + "\".");
        }
        this.writer = Utils.getFileUTF8Writer(file);
        if (this.writer == null) {
            throw new FreeColException("Can not write in log file \"" + fileName + "\".");
        }
        this.setFormatter(new TextFormatter());
        try {
            StringBuilder sb = new StringBuilder(512);
            sb.append("FreeCol game version: ").append(FreeCol.getRevision()).append("\nFreeCol protocol version: ").append(DOMMessage.getFreeColProtocolVersion()).append("\n\nJava vendor: ").append(System.getProperty("java.vendor")).append("\nJava version: ").append(System.getProperty("java.version")).append("\nJava WM name: ").append(System.getProperty("java.vm.name")).append("\nJava WM vendor: ").append(System.getProperty("java.vm.vendor")).append("\nJava WM version: ").append(System.getProperty("java.vm.version")).append("\n\nOS name: ").append(System.getProperty("os.name")).append("\nOS architecture: ").append(System.getProperty("os.arch")).append("\nOS version: ").append(System.getProperty("os.version")).append("\n\n");
            this.writer.write(sb.toString());
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (record.getThrown() != null) {
            FreeColDebugger.handleCrash();
        }
        if (record.getLevel().intValue() < this.getLevel().intValue()) {
            return;
        }
        String str = this.getFormatter().format(record);
        if (this.consoleLogging && record.getLevel().intValue() >= Level.WARNING.intValue()) {
            System.err.println(str);
        }
        try {
            this.writer.write(str, 0, str.length());
        }
        catch (IOException e) {
            System.err.println("Failed to write log record!");
            e.printStackTrace(System.err);
        }
        this.flush();
    }
}

