/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.PhiExpr;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.JumpStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.StmtList;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.ir.ts.Cfg;
import com.googlecode.dex2jar.ir.ts.Transformer;
import com.googlecode.dex2jar.ir.ts.UniqueQueue;
import com.googlecode.dex2jar.ir.ts.an.AnalyzeValue;
import com.googlecode.dex2jar.ir.ts.an.BaseAnalyze;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UnSSATransformer
implements Transformer {
    private static final boolean DEBUG = false;
    protected static final Comparator<RegAssign> OrderRegAssignByExcludeSizeDesc = new Comparator<RegAssign>(){

        @Override
        public int compare(RegAssign o1, RegAssign o2) {
            return o2.excludes.size() - o1.excludes.size();
        }
    };

    private void fixPhi(IrMethod method, Collection<LabelStmt> phiLabels) {
        for (LabelStmt labelStmt : phiLabels) {
            List<AssignStmt> phis = labelStmt.phis;
            for (AssignStmt phi : phis) {
                Local a = (Local)phi.getOp1();
                PhiExpr b = (PhiExpr)phi.getOp2();
                boolean introduceNewLocal = false;
                RegAssign aReg = (RegAssign)a.tag;
                Value[] valueArray = b.getOps();
                int n = valueArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Value op = valueArray[n2];
                    RegAssign bReg = (RegAssign)((Local)op).tag;
                    if (aReg.excludes.contains(bReg)) {
                        introduceNewLocal = true;
                        break;
                    }
                    ++n2;
                }
                if (!introduceNewLocal) continue;
                Local newLocal = (Local)a.clone();
                phi.op1 = newLocal;
                RegAssign newRegAssign = new RegAssign();
                newLocal.tag = newRegAssign;
                method.locals.add(newLocal);
                AssignStmt newAssigStmt = Stmts.nAssign(a, newLocal);
                Stmt next = labelStmt.getNext();
                if (next != null && next.st == Stmt.ST.IDENTITY && next.getOp2().vt == Value.VT.EXCEPTION_REF) {
                    method.stmts.insertAfter(next, newAssigStmt);
                } else {
                    method.stmts.insertAfter(labelStmt, newAssigStmt);
                }
                LiveV[] frame = (LiveV[])labelStmt.frame;
                LiveV thePhi = frame[a._ls_index];
                thePhi.local = newLocal;
                LiveV[] liveVArray = frame;
                int n3 = frame.length;
                int n4 = 0;
                while (n4 < n3) {
                    LiveV v = liveVArray[n4];
                    if (v != null && v.used) {
                        RegAssign s = (RegAssign)v.local.tag;
                        s.excludes.add(newRegAssign);
                        newRegAssign.excludes.add(s);
                    }
                    ++n4;
                }
            }
        }
    }

    private void insertAssignPath(IrMethod method, Collection<LabelStmt> phiLabels) {
        ArrayList<AssignStmt> buff = new ArrayList<AssignStmt>();
        for (LabelStmt labelStmt : phiLabels) {
            List<AssignStmt> phis = labelStmt.phis;
            LiveV[] frame = (LiveV[])labelStmt.frame;
            for (Stmt from : labelStmt._cfg_froms) {
                if (!from.visited) continue;
                for (AssignStmt phi : phis) {
                    Local a = (Local)phi.getOp1();
                    LiveV v = frame[a._ls_index];
                    Local local = v.stmt2regMap.get(from);
                    if (local == a) continue;
                    buff.add(Stmts.nAssign(a, local));
                }
                this.insertAssignPath(method.stmts, from, labelStmt, buff);
                buff.clear();
            }
        }
    }

    private void insertAssignPath(StmtList stmts, Stmt from, LabelStmt labelStmt, List<AssignStmt> buff) {
        boolean insertBeforeFromStmt;
        if (from.exceptionHandlers != null && from.exceptionHandlers.contains(labelStmt)) {
            insertBeforeFromStmt = true;
        } else {
            switch (from.st) {
                case GOTO: 
                case IF: {
                    JumpStmt jumpStmt = (JumpStmt)((Object)from);
                    insertBeforeFromStmt = jumpStmt.getTarget().equals(labelStmt);
                    break;
                }
                case LOOKUP_SWITCH: 
                case TABLE_SWITCH: {
                    insertBeforeFromStmt = true;
                    break;
                }
                default: {
                    insertBeforeFromStmt = false;
                }
            }
        }
        if (insertBeforeFromStmt) {
            for (AssignStmt as : buff) {
                stmts.insertBefore(from, as);
            }
        } else {
            for (AssignStmt as : buff) {
                stmts.insertAfter(from, as);
            }
        }
        LiveV[] frame = (LiveV[])from.frame;
        ArrayList<LiveV> newLiveVs = new ArrayList<LiveV>(buff.size());
        for (AssignStmt as : buff) {
            RegAssign assign;
            Local left = (Local)as.getOp1();
            LiveV liveV = new LiveV();
            liveV.local = left;
            liveV.used = true;
            newLiveVs.add(liveV);
            RegAssign leftRegAssign = (RegAssign)left.tag;
            Local right = (Local)as.getOp2();
            int toSkip = right._ls_index;
            int i = 0;
            while (i < frame.length) {
                LiveV v;
                if (i != toSkip && (v = frame[i]) != null && v.used) {
                    assign = (RegAssign)v.local.tag;
                    assign.excludes.add(leftRegAssign);
                    leftRegAssign.excludes.add(assign);
                }
                ++i;
            }
            for (AssignStmt as2 : buff) {
                assign = (RegAssign)((Local)as2.getOp1()).tag;
                assign.excludes.add(leftRegAssign);
                leftRegAssign.excludes.add(assign);
            }
        }
        LiveV[] newFrame = new LiveV[frame.length + newLiveVs.size()];
        System.arraycopy(frame, 0, newFrame, 0, frame.length);
        int i = 0;
        while (i < newLiveVs.size()) {
            newFrame[i + frame.length] = (LiveV)newLiveVs.get(i);
            ++i;
        }
    }

    @Override
    public void transform(IrMethod method) {
        if (method.phiLabels == null || method.phiLabels.size() == 0) {
            return;
        }
        LiveA liveA = new LiveA(method);
        liveA.analyze();
        this.genRegGraph(method, liveA);
        this.fixPhi(method, method.phiLabels);
        this.insertAssignPath(method, method.phiLabels);
        for (Local local : method.locals) {
            local.tag = null;
        }
        for (Stmt stmt : method.stmts) {
            stmt.frame = null;
        }
        for (LabelStmt labelStmt : method.phiLabels) {
            labelStmt.phis = null;
        }
        method.phiLabels = null;
    }

    private void genRegGraph(IrMethod method, LiveA liveA) {
        for (Local local : method.locals) {
            local.tag = new RegAssign();
        }
        HashSet<Stmt> tos = new HashSet<Stmt>();
        for (Stmt stmt : method.stmts) {
            LiveV[] frame;
            if ((stmt.st == Stmt.ST.ASSIGN || stmt.st == Stmt.ST.IDENTITY) && stmt.getOp1().vt == Value.VT.LOCAL) {
                Local localAssignTo = (Local)stmt.getOp1();
                RegAssign regAssignTo = (RegAssign)localAssignTo.tag;
                HashSet<Integer> excludeIdx = new HashSet<Integer>();
                Cfg.collectTos(stmt, tos);
                for (Stmt target : tos) {
                    frame = (LiveV[])target.frame;
                    if (frame == null) continue;
                    excludeIdx.clear();
                    excludeIdx.add(localAssignTo._ls_index);
                    if (target.st == Stmt.ST.LABEL) {
                        LabelStmt label = (LabelStmt)target;
                        if (label.phis != null) {
                            for (AssignStmt phiAssignStmt : label.phis) {
                                Local phiLocal = (Local)phiAssignStmt.getOp1();
                                excludeIdx.add(phiLocal._ls_index);
                            }
                        }
                    }
                    int i = 0;
                    while (i < frame.length) {
                        LiveV v;
                        if (!excludeIdx.contains(i) && (v = frame[i]) != null && v.used) {
                            RegAssign b = (RegAssign)v.local.tag;
                            regAssignTo.excludes.add(b);
                            b.excludes.add(regAssignTo);
                        }
                        ++i;
                    }
                }
                tos.clear();
                continue;
            }
            if (stmt.st != Stmt.ST.LABEL) continue;
            LabelStmt label = (LabelStmt)stmt;
            if (label.phis == null) continue;
            for (AssignStmt phiAssignStmt : label.phis) {
                Local phiLocal = (Local)phiAssignStmt.getOp1();
                RegAssign a = (RegAssign)phiLocal.tag;
                LiveV[] liveVArray = frame = (LiveV[])stmt.frame;
                int n = frame.length;
                int n2 = 0;
                while (n2 < n) {
                    LiveV v = liveVArray[n2];
                    if (v != null && v.used) {
                        RegAssign b = (RegAssign)v.local.tag;
                        a.excludes.add(b);
                        b.excludes.add(a);
                    }
                    ++n2;
                }
            }
        }
    }

    protected static class LiveA
    extends BaseAnalyze<LiveV> {
        static Comparator<LiveV> sortByHopsASC = new Comparator<LiveV>(){

            @Override
            public int compare(LiveV arg0, LiveV arg1) {
                return arg0.hops - arg1.hops;
            }
        };

        public LiveA(IrMethod method) {
            super(method);
        }

        @Override
        protected void analyzeValue() {
            this.markUsed();
        }

        protected void clearUnUsedFromFrame() {
            Stmt p = this.method.stmts.getFirst();
            while (p != null) {
                LiveV[] frame = (LiveV[])p.frame;
                if (frame != null) {
                    int i = 0;
                    while (i < frame.length) {
                        LiveV r = frame[i];
                        if (r != null && !r.used) {
                            frame[i] = null;
                        }
                        ++i;
                    }
                }
                p = p.getNext();
            }
        }

        protected Set<LiveV> markUsed() {
            HashSet<LiveV> used = new HashSet<LiveV>(this.aValues.size() / 2);
            UniqueQueue q = new UniqueQueue();
            q.addAll(this.aValues);
            while (!q.isEmpty()) {
                List<LiveV> otherParent;
                LiveV v = (LiveV)q.poll();
                if (!v.used || used.contains(v)) continue;
                used.add(v);
                LiveV parent = v.parent;
                if (parent != null && !parent.used) {
                    parent.used = true;
                    q.add(parent);
                }
                if ((otherParent = v.otherParents) == null || otherParent.size() <= 0) continue;
                for (LiveV parent2 : otherParent) {
                    if (parent2 == null || parent2.used) continue;
                    parent2.used = true;
                    q.add(parent2);
                }
                v.otherParents = null;
            }
            for (LiveV v : this.aValues) {
                v.parent = null;
            }
            this.aValues = null;
            return used;
        }

        @Override
        public LiveV[] merge(LiveV[] srcFrame, LiveV[] distFrame, Stmt src, Stmt dist) {
            LiveV distV;
            LiveV srcV;
            Local phiLocal;
            HashMap<Integer, AssignStmt> phiLives = new HashMap<Integer, AssignStmt>();
            if (dist.st == Stmt.ST.LABEL) {
                LabelStmt label = (LabelStmt)dist;
                if (label.phis != null) {
                    for (AssignStmt phiAssignStmt : label.phis) {
                        phiLocal = (Local)phiAssignStmt.getOp1();
                        phiLives.put(phiLocal._ls_index, phiAssignStmt);
                    }
                }
            }
            boolean firstMerge = false;
            if (distFrame == null) {
                distFrame = (LiveV[])this.newFrame();
                firstMerge = true;
                int i = 0;
                while (i < distFrame.length) {
                    if (!phiLives.containsKey(i) && (srcV = srcFrame[i]) != null) {
                        distV = this.newValue();
                        this.aValues.add(distV);
                        distV.parent = srcV;
                        distV.hops = srcV.hops + 1;
                        distV.local = srcV.local;
                        distFrame[i] = distV;
                    }
                    ++i;
                }
            }
            if (!firstMerge) {
                int i = 0;
                while (i < distFrame.length) {
                    if (!phiLives.containsKey(i)) {
                        srcV = srcFrame[i];
                        distV = distFrame[i];
                        if (srcV != null && distV != null) {
                            if (distV.otherParents == null) {
                                distV.otherParents = new ArrayList<LiveV>(5);
                            }
                            distV.otherParents.add(srcV);
                        }
                    }
                    ++i;
                }
            }
            for (AssignStmt phiAssignStmt : phiLives.values()) {
                LiveV distValue;
                phiLocal = (Local)phiAssignStmt.getOp1();
                if (firstMerge) {
                    distValue = new LiveV();
                    distValue.local = phiLocal;
                    distValue.stmt2regMap = new HashMap<Stmt, Local>();
                    distFrame[phiLocal._ls_index] = distValue;
                } else {
                    distValue = distFrame[phiLocal._ls_index];
                }
                ArrayList<LiveV> liveVs = new ArrayList<LiveV>();
                LiveV possiblePhiLocal = srcFrame[phiLocal._ls_index];
                if (possiblePhiLocal != null) {
                    liveVs.add(possiblePhiLocal);
                }
                Value[] valueArray = phiAssignStmt.getOp2().getOps();
                int n = valueArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Value p0 = valueArray[n2];
                    Local srcLocal = (Local)p0;
                    LiveV s = srcFrame[srcLocal._ls_index];
                    if (s != null) {
                        liveVs.add(s);
                    }
                    ++n2;
                }
                Collections.sort(liveVs, sortByHopsASC);
                LiveV a = (LiveV)liveVs.get(0);
                a.used = true;
                distValue.stmt2regMap.put(src, a.local);
            }
            return distFrame;
        }

        protected LiveV[] newFrame(int size) {
            return new LiveV[size];
        }

        @Override
        protected LiveV newValue() {
            return new LiveV();
        }

        @Override
        protected LiveV onAssignLocal(Local local, Value value) {
            LiveV v = (LiveV)super.onAssignLocal(local, value);
            v.local = local;
            v.used = true;
            return v;
        }

        @Override
        protected void onUseLocal(LiveV aValue, Local local) {
            aValue.used = true;
        }
    }

    private static class LiveV
    implements AnalyzeValue {
        public int hops;
        public Local local;
        public LiveV parent;
        public boolean used;
        public List<LiveV> otherParents;
        Map<Stmt, Local> stmt2regMap;

        private LiveV() {
        }

        @Override
        public char toRsp() {
            return this.used ? (char)'x' : '?';
        }

        public String toString() {
            return this.local + "|" + this.hops;
        }
    }

    protected static class RegAssign {
        public Set<RegAssign> excludes = new HashSet<RegAssign>();

        protected RegAssign() {
        }
    }
}

