/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.PlayPenCoordinate;
import ca.sqlpower.architect.swingui.olap.OLAPPane;
import ca.sqlpower.architect.swingui.olap.PaneSection;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DnDOLAPTransferable
implements Transferable,
Serializable {
    private static final Logger logger = Logger.getLogger(DnDOLAPTransferable.class);
    public static final DataFlavor PP_COORDINATE_FLAVOR = new DataFlavor(PlayPenCoordinate.class, "List of selected PlayPen coordinates");
    private final List<List<Integer>> coords;
    private final String userVisibleName;

    public DnDOLAPTransferable(PlayPen pp, List<PlayPenCoordinate<? extends OLAPObject, ? extends OLAPObject>> selectedCoordinates) {
        PlayPenContentPane contentPane = pp.getContentPane();
        StringBuilder name = new StringBuilder();
        this.coords = new ArrayList<List<Integer>>();
        for (int i = 0; i < contentPane.getChildren().size(); ++i) {
            PlayPenComponent ppc = contentPane.getChildren().get(i);
            for (PlayPenCoordinate<? extends OLAPObject, ? extends OLAPObject> ppco : selectedCoordinates) {
                OLAPPane<? extends OLAPObject, ? extends OLAPObject> pane = ppco.getPane();
                PaneSection<? extends OLAPObject> section = ppco.getSection();
                if (pane != ppc) continue;
                ArrayList<Integer> c = new ArrayList<Integer>();
                c.add(i);
                c.add(pane.getSections().indexOf(section));
                c.add(ppco.getIndex());
                this.coords.add(c);
                if (name.length() != 0) {
                    name.append("\n");
                }
                if (ppco.getItem() == null) {
                    name.append(section.getTitle());
                    continue;
                }
                name.append(OLAPUtil.nameFor(ppco.getItem()));
            }
        }
        this.userVisibleName = name.toString();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{PP_COORDINATE_FLAVOR};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(PP_COORDINATE_FLAVOR);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor != PP_COORDINATE_FLAVOR) {
            throw new IllegalArgumentException("Unsupported flavor " + flavor);
        }
        return this.coords;
    }

    public static List<PlayPenCoordinate<? extends OLAPObject, ? extends OLAPObject>> resolve(PlayPen pp, List<List<Integer>> coords) {
        ArrayList<PlayPenCoordinate<? extends OLAPObject, ? extends OLAPObject>> items = new ArrayList<PlayPenCoordinate<? extends OLAPObject, ? extends OLAPObject>>();
        for (List<Integer> coord : coords) {
            int paneIndex = coord.get(0);
            int sectIndex = coord.get(1);
            int itemIndex = coord.get(2);
            OLAPPane ppc = (OLAPPane)pp.getContentPane().getChildren().get(paneIndex);
            PaneSection s = ppc.getSections().get(sectIndex);
            OLAPObject item = itemIndex >= 0 ? (OLAPObject)((Object)s.getItems().get(itemIndex)) : null;
            PlayPenCoordinate ppco = new PlayPenCoordinate(ppc, s, itemIndex, item);
            items.add(ppco);
        }
        return items;
    }

    public String toString() {
        return this.userVisibleName;
    }
}

