/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xslt;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xslt.Messages;
import org.pentaho.di.trans.steps.xslt.Xslt;
import org.pentaho.di.trans.steps.xslt.XsltData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String xslFilename;
    private String fieldName;
    private String resultFieldname;
    private String xslFileField;
    private boolean xslFileFieldUse;
    private String xslFactory;

    public String getXslFilename() {
        return this.xslFilename;
    }

    public void setXSLFileField(String xslfilefieldin) {
        this.xslFileField = xslfilefieldin;
    }

    public void setXSLFactory(String xslfactoryin) {
        this.xslFactory = xslfactoryin;
    }

    public String getXSLFactory() {
        return this.xslFactory;
    }

    public String getXSLFileField() {
        return this.xslFileField;
    }

    public String getResultfieldname() {
        return this.resultFieldname;
    }

    public String getFieldname() {
        return this.fieldName;
    }

    public void setXslFilename(String xslFilename) {
        this.xslFilename = xslFilename;
    }

    public void setResultfieldname(String resultfield) {
        this.resultFieldname = resultfield;
    }

    public void setFieldname(String fieldnamein) {
        this.fieldName = fieldnamein;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        XsltMeta retval = (XsltMeta)super.clone();
        return retval;
    }

    public boolean useXSLFileFieldUse() {
        return this.xslFileFieldUse;
    }

    public void setXSLFileFieldUse(boolean xslfilefieldusein) {
        this.xslFileFieldUse = xslfilefieldusein;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.xslFilename = XMLHandler.getTagValue((Node)stepnode, (String)"xslfilename");
            this.fieldName = XMLHandler.getTagValue((Node)stepnode, (String)"fieldname");
            this.resultFieldname = XMLHandler.getTagValue((Node)stepnode, (String)"resultfieldname");
            this.xslFileField = XMLHandler.getTagValue((Node)stepnode, (String)"xslfilefield");
            this.xslFileFieldUse = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"xslfilefielduse"));
            this.xslFactory = XMLHandler.getTagValue((Node)stepnode, (String)"xslfactory");
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("XsltMeta.Exception.UnableToLoadStepInfoFromXML"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.xslFilename = null;
        this.fieldName = null;
        this.resultFieldname = "result";
        this.xslFactory = "JAXP";
        this.xslFileField = null;
        this.xslFileFieldUse = false;
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        ValueMeta v = new ValueMeta(space.environmentSubstitute(this.getResultfieldname()), 2);
        inputRowMeta.addValueMeta((ValueMetaInterface)v);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"xslfilename", (String)this.xslFilename));
        retval.append("    " + XMLHandler.addTagValue((String)"fieldname", (String)this.fieldName));
        retval.append("    " + XMLHandler.addTagValue((String)"resultfieldname", (String)this.resultFieldname));
        retval.append("    " + XMLHandler.addTagValue((String)"xslfilefield", (String)this.xslFileField));
        retval.append("    " + XMLHandler.addTagValue((String)"xslfilefielduse", (boolean)this.xslFileFieldUse));
        retval.append("    " + XMLHandler.addTagValue((String)"xslfactory", (String)this.xslFactory));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.xslFilename = rep.getStepAttributeString(id_step, "xslfilename");
            this.fieldName = rep.getStepAttributeString(id_step, "fieldname");
            this.resultFieldname = rep.getStepAttributeString(id_step, "resultfieldname");
            this.xslFileField = rep.getStepAttributeString(id_step, "xslfilefield");
            this.xslFileFieldUse = rep.getStepAttributeBoolean(id_step, "xslfilefielduse");
            this.xslFactory = rep.getStepAttributeString(id_step, "xslfactory");
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("XsltMeta.Exception.UnexpectedErrorInReadingStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "xslfilename", this.xslFilename);
            rep.saveStepAttribute(id_transformation, id_step, "fieldname", this.fieldName);
            rep.saveStepAttribute(id_transformation, id_step, "resultfieldname", this.resultFieldname);
            rep.saveStepAttribute(id_transformation, id_step, "xslfilefield", this.xslFileField);
            rep.saveStepAttribute(id_transformation, id_step, "xslfilefielduse", this.xslFileFieldUse);
            rep.saveStepAttribute(id_transformation, id_step, "xslfactory", this.xslFactory);
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("XsltMeta.Exception.UnableToSaveStepInfo") + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, Messages.getString("XsltMeta.CheckResult.ConnectedStepOK", String.valueOf(prev.size())), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("XsltMeta.CheckResult.NoInputReceived"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("XsltMeta.CheckResult.ExpectedInputOk"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("XsltMeta.CheckResult.ExpectedInputError"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.getResultfieldname() == null) {
            cr = new CheckResult(4, Messages.getString("XsltMeta.CheckResult.ErrorResultFieldNameMissing"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.xslFileFieldUse) {
            if (this.getXSLFileField() == null) {
                cr = new CheckResult(4, Messages.getString("XsltMeta.CheckResult.ErrorResultXSLFieldNameMissing"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, Messages.getString("XsltMeta.CheckResult.ErrorResultXSLFieldNameOK"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else if (this.xslFilename == null) {
            cr = new CheckResult(4, Messages.getString("XsltMeta.CheckResult.ErrorXSLFileNameMissing"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            String RealFilename = transMeta.environmentSubstitute(this.xslFilename);
            File f = new File(RealFilename);
            if (f.exists()) {
                if (f.isFile()) {
                    cr = new CheckResult(1, Messages.getString("XsltMeta.CheckResult.FileExists", RealFilename), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                } else {
                    cr = new CheckResult(4, Messages.getString("XsltMeta.CheckResult.ExistsButNoFile", RealFilename), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
            } else {
                cr = new CheckResult(4, Messages.getString("XsltMeta.CheckResult.FileNotExists", RealFilename), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new Xslt(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new XsltData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

