/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Symbol;

@DocString(name="unzip", args="pathname &optional directory => unzipped_pathnames", doc="Unpack zip archive at PATHNAME returning a list of extracted pathnames.\nIf the optional DIRECTORY is specified, root the abstraction in that directory, otherwise use the current value of *DEFAULT-PATHNAME-DEFAULTS*.")
public final class unzip
extends Primitive {
    private static final Primitive unzip = new unzip();

    public unzip() {
        super("unzip", Lisp.PACKAGE_SYS, true, "pathname &optional directory => unzipped_pathnames");
    }

    public LispObject execute(LispObject first) {
        Pathname zipFile = Lisp.coerceToPathname(first);
        Pathname directory = Lisp.coerceToPathname(Symbol.DEFAULT_PATHNAME_DEFAULTS.symbolValue());
        return this.unzipToDirectory(zipFile, directory);
    }

    public LispObject execute(LispObject first, LispObject second) {
        Pathname zipFile = Lisp.coerceToPathname(first);
        Pathname directory = Lisp.coerceToPathname(second);
        directory.name = Lisp.NIL;
        directory.type = Lisp.NIL;
        directory.invalidateNamestring();
        return this.unzipToDirectory(zipFile, directory);
    }

    private LispObject unzipToDirectory(Pathname zipPath, Pathname dirPath) {
        LispObject o;
        if (!zipPath.isAbsolute()) {
            zipPath = Pathname.mergePathnames(zipPath, Lisp.coerceToPathname(Symbol.DEFAULT_PATHNAME_DEFAULTS.symbolValue()));
        }
        if (!((o = Pathname.truename(zipPath, false)) instanceof Pathname)) {
            return Lisp.error(new FileError("No file found: " + zipPath, zipPath));
        }
        String zip2 = ((Pathname)o).getNamestring();
        if (zip2 == null) {
            return Lisp.error(new FileError("Pathname has no namestring: " + zip2, zipPath));
        }
        String dir = dirPath.getNamestring();
        if (dir == null) {
            return Lisp.error(new FileError("Could not parse diretory: " + dirPath, dirPath));
        }
        LispObject result = Lisp.NIL;
        try {
            ZipFile zipfile = new ZipFile(zip2);
            byte[] buffer = new byte[4096];
            Enumeration<? extends ZipEntry> entries = zipfile.entries();
            while (entries.hasMoreElements()) {
                int n;
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                String filename = dir + name;
                File file = new File(filename);
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                FileOutputStream out = new FileOutputStream(file);
                InputStream in = zipfile.getInputStream(entry);
                while ((n = in.read(buffer)) > 0) {
                    out.write(buffer, 0, n);
                }
                out.close();
                in.close();
                result = result.push(new Pathname(filename));
            }
        }
        catch (IOException e) {
            return Lisp.error(new FileError("Failed to unzip '" + zipPath + "'" + " into " + "'" + dirPath + "'" + ": " + e, zipPath));
        }
        return result;
    }
}

