/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.IOException;
import java.io.StringReader;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.StreamError;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class StringInputStream
extends Stream {
    private final StringReader stringReader;
    private final int start;
    private final String subString;
    private static final Primitive MAKE_STRING_INPUT_STREAM = new Primitive("make-string-input-stream", "string &optional start end"){

        public LispObject execute(LispObject arg) {
            return new StringInputStream(arg.getStringValue());
        }

        public LispObject execute(LispObject first, LispObject second) {
            String s = first.getStringValue();
            int start = Fixnum.getValue(second);
            return new StringInputStream(s, start);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            String s = first.getStringValue();
            int start = Fixnum.getValue(second);
            if (third == Lisp.NIL) {
                return new StringInputStream(s, start);
            }
            int end = Fixnum.getValue(third);
            return new StringInputStream(s, start, end);
        }
    };
    private static final Primitive STRING_INPUT_STREAM_CURRENT = new Primitive("string-input-stream-current", Lisp.PACKAGE_EXT, true, "stream"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof StringInputStream) {
                return Fixnum.getInstance(((StringInputStream)arg).getOffset());
            }
            return Lisp.error(new TypeError(String.valueOf(arg) + " is not a string input stream."));
        }
    };

    public StringInputStream(String s) {
        this(s, 0, s.length());
    }

    public StringInputStream(String s, int start) {
        this(s, start, s.length());
    }

    public StringInputStream(String s, int start, int end) {
        super(Symbol.STRING_INPUT_STREAM);
        this.elementType = Symbol.CHARACTER;
        this.setExternalFormat(keywordDefault);
        this.eolStyle = Stream.EolStyle.RAW;
        this.start = start;
        this.subString = s.substring(start, end);
        this.stringReader = new StringReader(this.subString);
        this.initAsCharacterInputStream(this.stringReader);
    }

    public LispObject typeOf() {
        return Symbol.STRING_INPUT_STREAM;
    }

    public LispObject classOf() {
        return BuiltInClass.STRING_INPUT_STREAM;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.STRING_INPUT_STREAM) {
            return Lisp.T;
        }
        if (type == Symbol.STRING_STREAM) {
            return Lisp.T;
        }
        if (type == BuiltInClass.STRING_INPUT_STREAM) {
            return Lisp.T;
        }
        if (type == BuiltInClass.STRING_STREAM) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public int getOffset() {
        return this.start + this.offset;
    }

    protected long _getFilePosition() {
        return this.getOffset();
    }

    protected boolean _setFilePosition(LispObject arg) {
        try {
            int offset;
            if (arg == Keyword.START) {
                offset = 0;
            } else if (arg == Keyword.END) {
                offset = this.subString.length();
            } else {
                long n = Fixnum.getValue(arg);
                if (n < 0L || n > (long)this.subString.length()) {
                    Lisp.error(new StreamError((Stream)this, "FILE-POSITION got out of bounds argument."));
                }
                offset = (int)n;
            }
            this.stringReader.reset();
            this.stringReader.skip(offset);
            this.initAsCharacterInputStream(this.stringReader);
            this.offset = offset;
        }
        catch (IOException e) {
            Lisp.error(new StreamError((Stream)this, e));
        }
        return true;
    }
}

