/***************************************************************************
                           chttp.h  -  description
                             -------------------
    begin                : Mon Jul 29 2002
    copyright            : (C) 2002-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHTTP_H
#define CHTTP_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/core/cobject.h>
#include <dclib/core/cbytearray.h>
#include <dclib/core/cconnection.h>
#include <dclib/core/ccallback.h>

class _CCallback;

typedef enum eUrlMethod {
	eumGET,
	eumPOST
};

class DLL_EXPORT CHttp : public CConnection {
public:
	/** */
	CHttp();
	/** */
	virtual ~CHttp();

	/** */
	int GetUrl( CString url, CString postdata = "" );
	/** */
	bool GetData( CByteArray * ba );

	/** callback function */
	virtual int DC_CallBack( CObject * ) { return -1; };
	/** */
	virtual void ConnectionState( eConnectionState );
	/** */
	virtual void DataAvailable( const char *, int );
	/** */
	virtual void DataSend();
	/** */
	virtual void DataTimeout();
	/** */
	virtual void Notify();

	/** */
	void SetCallBackFunction( _CCallback * callback );
	/** */
	CString GetUrl() { return m_sUrl; }
	/** */
	CString GetLocation() { return m_sLocation; }
	/** */
	int GetHttpError() { return m_nErrorCode; }
	/** */
	static CString Encode( CString s );
	/** */
	static CString Decode( CString s );

private:
	/** */
	int Callback( CObject *, CObject * );
	/** */
	int CallBack_SendObject( CObject * Object );

	/** */
	void AppendData( const char * buffer, int len );
	/** */
	CList<CObject> * m_pMessageList;
	/** */
	eConnectionState m_eMode;
	/** */
	CString m_sUrl;
	/** */
	CString m_sHost;
	/** */
	CString m_sPort;
	/** */
	CString m_sProxy;
	/** */
	CString m_sProxyPort;
	/** */
	eUrlMethod m_eUrlMethod;
	/** */
	int m_nErrorCode;
	/** */
	bool m_bData;
	/** */
	CString m_sLocation;
	/** */
	CString m_sHeader;
	/** */
	CString m_sPostData;
	/** */
	long m_nContentLength;
	/** */
	CByteArray m_baData;
	/** */
	_CCallback * m_pHttpCallback;
	/** */
	_CCallback * m_pCallback;
};

inline void CHttp::SetCallBackFunction( _CCallback * callback )
{ if ( m_pHttpCallback ) delete m_pHttpCallback; m_pHttpCallback = callback; }

#endif
