#!/bin/sh
export PATH='/usr/obj/ports/hs-hedis-0.6.10/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: hedis
version: 0.6.10
id: hedis-0.6.10-2150ab0d697d8547cc2947bde275e53c
key: hedis_6HbwglZVs6oAzh3h5ygLrB
license: BSD3
copyright: Copyright (c) 2011 Falko Peters
maintainer: falko.peters@gmail.com
homepage: https://github.com/informatikr/hedis
synopsis: Client library for the Redis datastore: supports full command set,
          pipelining.
description:
    Redis is an open source, advanced key-value store. It is often referred to
    as a data structure server since keys can contain strings, hashes, lists,
    sets and sorted sets. This library is a Haskell client for the Redis
    datastore. Compared to other Haskell client libraries it has some
    advantages:
    .
    [Complete Redis 2.6 command set:] All Redis commands
    (<http://redis.io/commands>) are available as haskell functions, except
    for the MONITOR and SYNC commands. Additionally, a low-level API is
    exposed that  makes it easy for the library user to implement further
    commands, such as new commands from an experimental Redis version.
    .
    [Automatic Optimal Pipelining:] Commands are pipelined
    (<http://redis.io/topics/pipelining>) as much as possible without any
    work by the user. See
    <http://informatikr.com/2012/redis-pipelining.html> for a
    technical explanation of automatic optimal pipelining.
    .
    [Enforced Pub\/Sub semantics:] When subscribed to the Redis Pub\/Sub server
    (<http://redis.io/topics/pubsub>), clients are not allowed to issue
    commands other than subscribing to or unsubscribing from channels. This
    library uses the type system to enforce the correct behavior.
    .
    [Connect via TCP or Unix Domain Socket:] TCP sockets are the default way to
    connect to a Redis server. For connections to a server on the same
    machine, Unix domain sockets offer higher performance than the standard
    TCP connection.
    .
    For detailed documentation, see the "Database.Redis" module.
    .
category: Database
author: Falko Peters
exposed: True
exposed-modules:
    Database.Redis
hidden-modules: Database.Redis.Core
                Database.Redis.ProtocolPipelining Database.Redis.Protocol
                Database.Redis.PubSub Database.Redis.Transactions
                Database.Redis.Types Database.Redis.Commands
                Database.Redis.ManualCommands
trusted: False
import-dirs: /usr/local/lib/ghc/hedis-0.6.10
library-dirs: /usr/local/lib/ghc/hedis-0.6.10
data-dir: /usr/local/share/hs-hedis-0.6.10
hs-libraries: HShedis-0.6.10-6HbwglZVs6oAzh3h5ygLrB
depends:
    BoundedChan-1.0.1.0-c5f01ea73825a0d1e79efb19bd80788a
    attoparsec-0.13.0.1-8953826c212c049a5286a9aadeb21f07
    base-4.8.2.0-6d41353bf1900ecbb9b02a306c286c36
    bytestring-0.10.6.0-0aa78e663f1d7b0d4f434cabb130075c
    bytestring-lexing-0.5.0.2-1105d35b64ccd4cc85542d94df1bc249
    mtl-2.2.1-05005bb32df8fbad260aa2bc8c4b64aa
    network-2.6.2.1-3b665743d23d24bea9ea15fe12214a85
    resource-pool-0.2.1.1-0ee20e750de8ba030c9ee03cc43775fe
    time-1.5.0.1-7f6e7d3125c12e9efdc302bc6ee0a210
    vector-0.11.0.0-038317210aedffb94db1b450a91d7de1
haddock-interfaces: /usr/local/share/doc/hs-hedis-0.6.10/html/hedis.haddock
haddock-html: /usr/local/share/doc/hs-hedis-0.6.10/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
