#!/bin/sh
#
# This file is part of sudognu.
#
# Copyright (C) 2007-2009 Jens Baaran, Germany.
#
# THERE IS NO WARRANTY FOR THIS PROGRAM, TO THE EXTENT PERMITTED
# BY APPLICABLE LAW.
#
# See the GPL Version 2 (http://www.gnu.org/licenses/gpl.html)
# or the file COPYING for details
# ******************************************************************************
set -f
CGISUDOKU=/usr/local/bin/sudognu
TMPDIR=./tmp
LOG=$TMPDIR/wsudoku.log

PARAM_STRING_SUDOKU=`echo $QUERY_STRING | egrep -o 'sudoku=[[:digit:]]+'`
SUDOKU=`echo $PARAM_STRING_SUDOKU | egrep -o '=[[:digit:]]+' | cut -b 2-`

rm -f `find $TMPDIR -mmin +60 -name ??-??.html`
fn="$TMPDIR/`date +%M-%S`.html"
echo "$fn" > $LOG
echo "$SUDOKU" >> $LOG
echo >> $LOG

echo $SUDOKU | $CGISUDOKU -w -o "$fn" >> $LOG 2>> $LOG

echo "Content-type: text/html"
echo
cat "$fn"
