/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import javax.swing.SizeRequirements;

public class BoxLayout
implements LayoutManager2,
Serializable {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int LINE_AXIS = 2;
    public static final int PAGE_AXIS = 3;
    private static final long serialVersionUID = -2474455742719112368L;
    private Container container;
    private int way = 0;
    private SizeRequirements[] xChildren;
    private SizeRequirements[] yChildren;
    private SizeRequirements xTotal;
    private SizeRequirements yTotal;
    private int[] offsetsX;
    private int[] offsetsY;
    private int[] spansX;
    private int[] spansY;

    public BoxLayout(Container container, int way) {
        if (way != 0 && way != 1 && way != 2 && way != 3) {
            throw new AWTError("Invalid axis");
        }
        this.container = container;
        this.way = way;
    }

    public void addLayoutComponent(String name, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    private boolean isHorizontalIn(Container parent) {
        ComponentOrientation orientation = parent.getComponentOrientation();
        return this.way == 0 || this.way == 2 && orientation.isHorizontal() || this.way == 3 && !orientation.isHorizontal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container parent) {
        Object object = this.container.getTreeLock();
        synchronized (object) {
            if (this.container != parent) {
                throw new AWTError("BoxLayout can't be shared");
            }
            this.checkTotalRequirements();
            Insets i = this.container.getInsets();
            return new Dimension(this.xTotal.preferred + i.left + i.right, this.yTotal.preferred + i.top + i.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container parent) {
        Object object = this.container.getTreeLock();
        synchronized (object) {
            if (this.container != parent) {
                throw new AWTError("BoxLayout can't be shared");
            }
            this.checkTotalRequirements();
            Insets i = this.container.getInsets();
            return new Dimension(this.xTotal.minimum + i.left + i.right, this.yTotal.minimum + i.top + i.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = this.container.getTreeLock();
        synchronized (object) {
            if (this.container != parent) {
                throw new AWTError("BoxLayout can't be shared");
            }
            this.checkLayout();
            Component[] children = this.container.getComponents();
            Insets in = this.container.getInsets();
            int i = 0;
            while (i < children.length) {
                children[i].setBounds(this.offsetsX[i] + in.left, this.offsetsY[i] + in.top, this.spansX[i], this.spansY[i]);
                ++i;
            }
        }
    }

    public void addLayoutComponent(Component child, Object constraints) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getLayoutAlignmentX(Container parent) {
        Object object = this.container.getTreeLock();
        synchronized (object) {
            if (this.container != parent) {
                throw new AWTError("BoxLayout can't be shared");
            }
            this.checkTotalRequirements();
            return this.xTotal.alignment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getLayoutAlignmentY(Container parent) {
        Object object = this.container.getTreeLock();
        synchronized (object) {
            if (this.container != parent) {
                throw new AWTError("BoxLayout can't be shared");
            }
            this.checkTotalRequirements();
            return this.yTotal.alignment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateLayout(Container parent) {
        if (this.container != parent) {
            throw new AWTError("BoxLayout can't be shared");
        }
        Object object = this.container.getTreeLock();
        synchronized (object) {
            this.xChildren = null;
            this.yChildren = null;
            this.xTotal = null;
            this.yTotal = null;
            this.offsetsX = null;
            this.offsetsY = null;
            this.spansX = null;
            this.spansY = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension maximumLayoutSize(Container parent) {
        Object object = this.container.getTreeLock();
        synchronized (object) {
            if (this.container != parent) {
                throw new AWTError("BoxLayout can't be shared");
            }
            this.checkTotalRequirements();
            Insets i = this.container.getInsets();
            int xDim = this.xTotal.maximum + i.left + i.right;
            int yDim = this.yTotal.maximum + i.top + i.bottom;
            if (xDim < this.xTotal.maximum) {
                xDim = Integer.MAX_VALUE;
            }
            if (yDim < this.yTotal.maximum) {
                yDim = Integer.MAX_VALUE;
            }
            return new Dimension(xDim, yDim);
        }
    }

    private void checkTotalRequirements() {
        if (this.xTotal == null || this.yTotal == null) {
            this.checkRequirements();
            if (this.isHorizontalIn(this.container)) {
                this.xTotal = SizeRequirements.getTiledSizeRequirements(this.xChildren);
                this.yTotal = SizeRequirements.getAlignedSizeRequirements(this.yChildren);
            } else {
                this.xTotal = SizeRequirements.getAlignedSizeRequirements(this.xChildren);
                this.yTotal = SizeRequirements.getTiledSizeRequirements(this.yChildren);
            }
        }
    }

    private void checkRequirements() {
        if (this.xChildren == null || this.yChildren == null) {
            Component[] children = this.container.getComponents();
            this.xChildren = new SizeRequirements[children.length];
            this.yChildren = new SizeRequirements[children.length];
            int i = 0;
            while (i < children.length) {
                if (!children[i].isVisible()) {
                    this.xChildren[i] = new SizeRequirements();
                    this.yChildren[i] = new SizeRequirements();
                } else {
                    this.xChildren[i] = new SizeRequirements(children[i].getMinimumSize().width, children[i].getPreferredSize().width, children[i].getMaximumSize().width, children[i].getAlignmentX());
                    this.yChildren[i] = new SizeRequirements(children[i].getMinimumSize().height, children[i].getPreferredSize().height, children[i].getMaximumSize().height, children[i].getAlignmentY());
                }
                ++i;
            }
        }
    }

    private void checkLayout() {
        if (this.offsetsX == null || this.offsetsY == null || this.spansX == null || this.spansY == null) {
            this.checkRequirements();
            this.checkTotalRequirements();
            int len = this.container.getComponents().length;
            this.offsetsX = new int[len];
            this.offsetsY = new int[len];
            this.spansX = new int[len];
            this.spansY = new int[len];
            Insets in = this.container.getInsets();
            int width = this.container.getWidth() - in.left - in.right;
            int height = this.container.getHeight() - in.top - in.bottom;
            if (this.isHorizontalIn(this.container)) {
                SizeRequirements.calculateTiledPositions(width, this.xTotal, this.xChildren, this.offsetsX, this.spansX);
                SizeRequirements.calculateAlignedPositions(height, this.yTotal, this.yChildren, this.offsetsY, this.spansY);
            } else {
                SizeRequirements.calculateAlignedPositions(width, this.xTotal, this.xChildren, this.offsetsX, this.spansX);
                SizeRequirements.calculateTiledPositions(height, this.yTotal, this.yChildren, this.offsetsY, this.spansY);
            }
        }
    }
}

