/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class LineNumberReader
extends BufferedReader {
    private int lineNumber;
    private boolean matchedNewLine;
    private int savedLineNumber;

    public LineNumberReader(Reader in) {
        super(in, 8192);
    }

    public LineNumberReader(Reader in, int size) {
        super(in, size);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readLimit) throws IOException {
        if (readLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit is negative");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.pos + readLimit > this.limit) {
                int saveCR = this.matchedNewLine ? 1 : 0;
                char[] old_buffer = this.buffer;
                if (readLimit > this.limit) {
                    this.buffer = new char[saveCR + readLimit];
                }
                int copy_start = this.pos - saveCR;
                this.savedLineNumber = this.lineNumber;
                this.limit -= copy_start;
                System.arraycopy(old_buffer, copy_start, this.buffer, 0, this.limit);
                this.pos = saveCR;
            }
            this.markPos = this.pos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.markPos < 0) {
                throw new IOException("mark never set or invalidated");
            }
            this.lineNumber = this.savedLineNumber;
            this.pos = this.markPos;
            this.matchedNewLine = this.markPos > 0 && this.buffer[this.markPos - 1] == '\r';
        }
    }

    private int fill() throws IOException {
        int count;
        if (this.markPos >= 0 && this.limit == this.buffer.length) {
            this.markPos = -1;
        }
        if (this.markPos < 0) {
            this.limit = 0;
            this.pos = 0;
        }
        if ((count = this.in.read(this.buffer, this.limit, this.buffer.length - this.limit)) <= 0) {
            return -1;
        }
        this.limit += count;
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            char ch;
            block6: {
                block5: {
                    this.skipRedundantLF();
                    if (this.pos < this.limit || this.fill() >= 0) break block5;
                    return -1;
                }
                ch = this.buffer[this.pos++];
                this.matchedNewLine = ch == '\r';
                if (!this.matchedNewLine && ch != '\n') break block6;
                ++this.lineNumber;
                return 10;
            }
            this.matchedNewLine = false;
            return ch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] buf, int offset, int count) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset + count > buf.length || offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count <= 0) {
            if (count < 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            block13: {
                if (this.pos < this.limit || this.fill() >= 0) break block13;
                return -1;
            }
            int start_offset = offset;
            boolean matched = this.matchedNewLine;
            while (count-- > 0 && this.pos < this.limit) {
                char ch;
                if ((ch = this.buffer[this.pos++]) == '\r') {
                    ++this.lineNumber;
                    matched = true;
                } else if (ch == '\n' && !matched) {
                    ++this.lineNumber;
                } else {
                    matched = false;
                }
                buf[offset++] = ch;
            }
            this.matchedNewLine = matched;
            return offset - start_offset;
        }
    }

    private void skipRedundantLF() throws IOException {
        if (this.pos > 0 && this.matchedNewLine) {
            if (this.pos < this.limit) {
                if (this.buffer[this.pos] == '\n') {
                    ++this.pos;
                }
            } else {
                if (this.fill() <= 0) {
                    return;
                }
                if (this.buffer[this.pos] == '\n') {
                    ++this.pos;
                }
            }
            this.matchedNewLine = true;
        }
    }

    public String readLine() throws IOException {
        int tmpLineNumber = this.lineNumber;
        this.skipRedundantLF();
        String str = super.readLine();
        if (this.pos > this.limit) {
            --this.pos;
        }
        if (str != null) {
            this.lineNumber = tmpLineNumber + 1;
        }
        return str;
    }

    public long skip(long count) throws IOException {
        if (count < 0L) {
            throw new IllegalArgumentException("skip() value is negative");
        }
        if (count == 0L) {
            return 0L;
        }
        char[] buf = new char[1];
        int skipped = 0;
        while ((long)skipped < count) {
            int ch = this.read(buf, 0, 1);
            if (ch < 0) break;
            ++skipped;
        }
        return skipped;
    }
}

