/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mac;

import gnu.java.security.util.Util;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mode.IMode;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class OMAC
implements IMac {
    private static final Logger log = null;
    private static final byte C1 = -121;
    private static final byte C2 = 27;
    private static final byte[] KEY0 = Util.toBytesFromString("2b7e151628aed2a6abf7158809cf4f3c");
    private static final byte[] DIGEST0 = Util.toBytesFromString("bb1d6929e95937287fa37d129b756746");
    private static Boolean valid;
    private final IBlockCipher cipher;
    private final String name;
    private IMode mode;
    private int blockSize;
    private int outputSize;
    private byte[] Lu;
    private byte[] Lu2;
    private byte[] M;
    private byte[] Y;
    private boolean init;
    private int index;

    public OMAC(IBlockCipher cipher) {
        this.cipher = cipher;
        this.name = "OMAC-" + cipher.name();
    }

    public Object clone() {
        return new OMAC(this.cipher);
    }

    public String name() {
        return this.name;
    }

    public int macSize() {
        return this.outputSize;
    }

    public void init(Map attrib) throws InvalidKeyException {
        HashMap attrib2 = new HashMap();
        attrib2.put("gnu.crypto.cipher.key.material", attrib.get("gnu.crypto.mac.key.material"));
        this.cipher.reset();
        this.cipher.init(attrib2);
        this.blockSize = this.cipher.currentBlockSize();
        Integer os = (Integer)attrib.get("gnu.crypto.mac.truncated.size");
        if (os != null) {
            this.outputSize = os;
            if (this.outputSize < 0 || this.outputSize > this.blockSize) {
                throw new IllegalArgumentException("truncated size out of range");
            }
        } else {
            this.outputSize = this.blockSize;
        }
        byte[] L = new byte[this.blockSize];
        this.cipher.encryptBlock(L, 0, L, 0);
        if (this.Lu != null) {
            Arrays.fill(this.Lu, (byte)0);
            if (this.Lu.length != this.blockSize) {
                this.Lu = new byte[this.blockSize];
            }
        } else {
            this.Lu = new byte[this.blockSize];
        }
        if (this.Lu2 != null) {
            Arrays.fill(this.Lu2, (byte)0);
            if (this.Lu2.length != this.blockSize) {
                this.Lu2 = new byte[this.blockSize];
            }
        } else {
            this.Lu2 = new byte[this.blockSize];
        }
        boolean msb = (L[0] & 0x80) != 0;
        int i = 0;
        while (i < this.blockSize) {
            this.Lu[i] = (byte)(L[i] << 1 & 0xFF);
            if (i + 1 < this.blockSize) {
                int n = i;
                this.Lu[n] = (byte)(this.Lu[n] | (byte)((L[i + 1] & 0x80) >> 7));
            }
            ++i;
        }
        if (msb) {
            if (this.blockSize == 16) {
                int n = this.Lu.length - 1;
                this.Lu[n] = (byte)(this.Lu[n] ^ 0xFFFFFF87);
            } else if (this.blockSize == 8) {
                int n = this.Lu.length - 1;
                this.Lu[n] = (byte)(this.Lu[n] ^ 0x1B);
            } else {
                throw new IllegalArgumentException("unsupported cipher block size: " + this.blockSize);
            }
        }
        msb = (this.Lu[0] & 0x80) != 0;
        i = 0;
        while (i < this.blockSize) {
            this.Lu2[i] = (byte)(this.Lu[i] << 1 & 0xFF);
            if (i + 1 < this.blockSize) {
                int n = i;
                this.Lu2[n] = (byte)(this.Lu2[n] | (byte)((this.Lu[i + 1] & 0x80) >> 7));
            }
            ++i;
        }
        if (msb) {
            if (this.blockSize == 16) {
                int n = this.Lu2.length - 1;
                this.Lu2[n] = (byte)(this.Lu2[n] ^ 0xFFFFFF87);
            } else {
                int n = this.Lu2.length - 1;
                this.Lu2[n] = (byte)(this.Lu2[n] ^ 0x1B);
            }
        }
        if (this.M != null) {
            Arrays.fill(this.M, (byte)0);
            if (this.M.length != this.blockSize) {
                this.M = new byte[this.blockSize];
            }
        } else {
            this.M = new byte[this.blockSize];
        }
        if (this.Y != null) {
            Arrays.fill(this.Y, (byte)0);
            if (this.Y.length != this.blockSize) {
                this.Y = new byte[this.blockSize];
            }
        } else {
            this.Y = new byte[this.blockSize];
        }
        this.index = 0;
        this.init = true;
    }

    public void update(byte b) {
        if (!this.init) {
            throw new IllegalStateException("not initialized");
        }
        if (this.index == this.M.length) {
            this.process();
            this.index = 0;
        }
        this.M[this.index++] = b;
    }

    public void update(byte[] buf, int off, int len) {
        if (!this.init) {
            throw new IllegalStateException("not initialized");
        }
        if (off < 0 || len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException("size=" + buf.length + "; off=" + off + "; len=" + len);
        }
        int i = 0;
        while (i < len) {
            if (this.index == this.blockSize) {
                this.process();
                this.index = 0;
            }
            int count = Math.min(this.blockSize - this.index, len - i);
            System.arraycopy(buf, off + i, this.M, this.index, count);
            this.index += count;
            i += count;
        }
    }

    public byte[] digest() {
        byte[] b = new byte[this.outputSize];
        this.digest(b, 0);
        return b;
    }

    public void digest(byte[] out, int off) {
        if (!this.init) {
            throw new IllegalStateException("not initialized");
        }
        if (off < 0 || off + this.outputSize > out.length) {
            throw new IndexOutOfBoundsException("size=" + out.length + "; off=" + off + "; len=" + this.outputSize);
        }
        byte[] T = new byte[this.blockSize];
        byte[] L = this.Lu;
        if (this.index < this.blockSize) {
            this.M[this.index++] = -128;
            while (this.index < this.blockSize) {
                this.M[this.index++] = 0;
            }
            L = this.Lu2;
        }
        int i = 0;
        while (i < this.blockSize) {
            T[i] = (byte)(this.M[i] ^ this.Y[i] ^ L[i]);
            ++i;
        }
        this.cipher.encryptBlock(T, 0, T, 0);
        System.arraycopy(T, 0, out, off, this.outputSize);
        this.reset();
    }

    public void reset() {
        this.index = 0;
        if (this.Y != null) {
            Arrays.fill(this.Y, (byte)0);
        }
        if (this.M != null) {
            Arrays.fill(this.M, (byte)0);
        }
    }

    public boolean selfTest() {
        OMAC mac = new OMAC(CipherFactory.getInstance("aes"));
        mac.reset();
        HashMap<String, byte[]> attr = new HashMap<String, byte[]>();
        attr.put("gnu.crypto.mac.key.material", KEY0);
        byte[] digest = null;
        try {
            mac.init(attr);
            digest = mac.digest();
        }
        catch (Exception exception) {
            return false;
        }
        if (digest == null) {
            return false;
        }
        return Arrays.equals(DIGEST0, digest);
    }

    private void process() {
        int i = 0;
        while (i < this.blockSize) {
            this.M[i] = (byte)(this.M[i] ^ this.Y[i]);
            ++i;
        }
        this.cipher.encryptBlock(this.M, 0, this.Y, 0);
    }
}

