/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.util;

import gnu.java.lang.CPStringBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class ByteArray {
    private final byte[] value;

    public ByteArray(byte[] value) {
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    public String toString() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        int i = 0;
        int len = this.value.length;
        while (i < len) {
            out.print(ByteArray.formatInt(i, 16, 8));
            out.print("  ");
            int l = Math.min(16, len - i);
            String s = ByteArray.toHexString(this.value, i, l, ' ');
            out.print(s);
            int j = 56 - (56 - s.length());
            while (j < 56) {
                out.print(" ");
                ++j;
            }
            j = 0;
            while (j < l) {
                byte b = this.value[i + j];
                if ((b & 0xFF) < 32 || (b & 0xFF) > 126) {
                    out.print(".");
                } else {
                    out.print((char)(b & 0xFF));
                }
                ++j;
            }
            out.println();
            i += 16;
        }
        return str.toString();
    }

    public static String toHexString(byte[] buf, int off, int len, char sep) {
        CPStringBuilder str = new CPStringBuilder();
        int i = 0;
        while (i < len) {
            str.append(Character.forDigit(buf[i + off] >>> 4 & 0xF, 16));
            str.append(Character.forDigit(buf[i + off] & 0xF, 16));
            if (i < len - 1) {
                str.append(sep);
            }
            ++i;
        }
        return str.toString();
    }

    public static String formatInt(int value, int radix, int len) {
        String s = Integer.toString(value, radix);
        CPStringBuilder buf = new CPStringBuilder();
        int j = 0;
        while (j < len - s.length()) {
            buf.append("0");
            ++j;
        }
        buf.append(s);
        return buf.toString();
    }
}

