/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.dss;

import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.key.IKeyPairCodec;
import gnu.java.security.key.dss.DSSPublicKey;
import gnu.java.security.util.DerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;

public class DSSKeyPairX509Codec
implements IKeyPairCodec {
    private static final OID DSA_ALG_OID = new OID("1.2.840.10040.4.1");

    public int getFormatID() {
        return 2;
    }

    public byte[] encodePublicKey(PublicKey key) {
        byte[] result;
        DERValue derParams;
        if (!(key instanceof DSSPublicKey)) {
            throw new InvalidParameterException("key");
        }
        DERValue derOID = new DERValue(6, DSA_ALG_OID);
        DSSPublicKey dssKey = (DSSPublicKey)key;
        if (dssKey.hasInheritedParameters()) {
            derParams = new DERValue(5, null);
        } else {
            BigInteger p = dssKey.getParams().getP();
            BigInteger q = dssKey.getParams().getQ();
            BigInteger g = dssKey.getParams().getG();
            DERValue derP = new DERValue(2, p);
            DERValue derQ = new DERValue(2, q);
            DERValue derG = new DERValue(2, g);
            ArrayList<DERValue> params = new ArrayList<DERValue>(3);
            params.add(derP);
            params.add(derQ);
            params.add(derG);
            derParams = new DERValue(48, params);
        }
        ArrayList<DERValue> algorithmID = new ArrayList<DERValue>(2);
        algorithmID.add(derOID);
        algorithmID.add(derParams);
        DERValue derAlgorithmID = new DERValue(48, algorithmID);
        BigInteger y = dssKey.getY();
        DERValue derDSAPublicKey = new DERValue(2, y);
        byte[] yBytes = derDSAPublicKey.getEncoded();
        DERValue derSPK = new DERValue(3, new BitString(yBytes));
        ArrayList<DERValue> spki = new ArrayList<DERValue>(2);
        spki.add(derAlgorithmID);
        spki.add(derSPK);
        DERValue derSPKI = new DERValue(48, spki);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DERWriter.write(baos, derSPKI);
            result = baos.toByteArray();
        }
        catch (IOException x) {
            InvalidParameterException e = new InvalidParameterException(x.getMessage());
            e.initCause(x);
            throw e;
        }
        return result;
    }

    public byte[] encodePrivateKey(PrivateKey key) {
        throw new InvalidParameterException("Wrong format for private keys");
    }

    public PublicKey decodePublicKey(byte[] input) {
        BigInteger y;
        if (input == null) {
            throw new InvalidParameterException("Input bytes MUST NOT be null");
        }
        BigInteger p = null;
        BigInteger g = null;
        BigInteger q = null;
        DERReader der = new DERReader(input);
        try {
            DERValue derSPKI = der.read();
            DerUtil.checkIsConstructed(derSPKI, "Wrong SubjectPublicKeyInfo field");
            DERValue derAlgorithmID = der.read();
            DerUtil.checkIsConstructed(derAlgorithmID, "Wrong AlgorithmIdentifier field");
            DERValue derOID = der.read();
            if (!(derOID.getValue() instanceof OID)) {
                throw new InvalidParameterException("Wrong Algorithm field");
            }
            OID algOID = (OID)derOID.getValue();
            if (!algOID.equals(DSA_ALG_OID)) {
                throw new InvalidParameterException("Unexpected OID: " + algOID);
            }
            DERValue val = der.read();
            if (val.getTag() == 5) {
                val = der.read();
            } else if (val.isConstructed()) {
                val = der.read();
                DerUtil.checkIsBigInteger(val, "Wrong P field");
                p = (BigInteger)val.getValue();
                val = der.read();
                DerUtil.checkIsBigInteger(val, "Wrong Q field");
                q = (BigInteger)val.getValue();
                val = der.read();
                DerUtil.checkIsBigInteger(val, "Wrong G field");
                g = (BigInteger)val.getValue();
                val = der.read();
            }
            if (!(val.getValue() instanceof BitString)) {
                throw new InvalidParameterException("Wrong SubjectPublicKey field");
            }
            byte[] yBytes = ((BitString)val.getValue()).toByteArray();
            DERReader dsaPub = new DERReader(yBytes);
            val = dsaPub.read();
            DerUtil.checkIsBigInteger(val, "Wrong Y field");
            y = (BigInteger)val.getValue();
        }
        catch (IOException x) {
            InvalidParameterException e = new InvalidParameterException(x.getMessage());
            e.initCause(x);
            throw e;
        }
        return new DSSPublicKey(2, p, q, g, y);
    }

    public PrivateKey decodePrivateKey(byte[] input) {
        throw new InvalidParameterException("Wrong format for private keys");
    }
}

