/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.qt;

import gnu.java.awt.peer.qt.QMatrix;
import gnu.java.awt.peer.qt.QPainterPath;
import gnu.java.awt.peer.qt.QPen;
import gnu.java.awt.peer.qt.QtFontMetrics;
import gnu.java.awt.peer.qt.QtFontPeer;
import gnu.java.awt.peer.qt.QtImage;
import gnu.java.awt.peer.qt.QtVolatileImage;
import java.awt.AWTPermission;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QtGraphics
extends Graphics2D {
    protected long nativeObject;
    private static final AffineTransform identity = new AffineTransform();
    protected Font font;
    protected Color color;
    protected Color bgcolor;
    protected Shape clip;
    protected Shape initialClip;
    protected AffineTransform xform;
    protected Stroke currentStroke;
    protected boolean nativeStroking;
    protected Composite composite;
    protected double currentAlpha;
    protected Paint currentPaint;
    protected RenderingHints renderingHints;
    Graphics parent;

    QtGraphics() {
    }

    QtGraphics(QtGraphics parent) {
        this.cloneNativeContext(parent);
        this.setFont(parent.getFont());
        this.setAlpha(parent.currentAlpha);
        this.setBackground(parent.getBackground());
        this.setColor(parent.getColor());
        this.initialClip = parent.getClip();
        this.setClip(this.initialClip);
        this.setTransform(parent.getTransform());
        this.setStroke(parent.getStroke());
        this.setComposite(parent.getComposite());
        this.setPaint(parent.getPaint());
        this.setRenderingHints(parent.getRenderingHints());
    }

    protected void setup() {
        this.font = new Font("Dialog", 0, 12);
        this.setTransform(identity);
        this.setStroke(new BasicStroke());
        this.renderingHints = new RenderingHints(null);
    }

    public synchronized native void delete();

    @Override
    public void dispose() {
    }

    private void resetClip() {
        AffineTransform current = this.getTransform();
        this.setTransform(identity);
        this.setClip(this.initialClip);
        this.setTransform(current);
    }

    protected native void initImage(QtImage var1);

    protected native void initVolatileImage(QtVolatileImage var1);

    private native void cloneNativeContext(QtGraphics var1);

    private native void setColor(int var1, int var2, int var3, int var4);

    private native void drawNative(QPainterPath var1);

    private native void fillNative(QPainterPath var1);

    private native void setClipNative(QPainterPath var1);

    private native void setClipRectNative(int var1, int var2, int var3, int var4);

    private native void intersectClipNative(QPainterPath var1);

    private native void intersectClipRectNative(int var1, int var2, int var3, int var4);

    private native void setQtTransform(QMatrix var1);

    private native void setNativeStroke(QPen var1);

    private native void setNativeComposite(int var1);

    private native void drawStringNative(String var1, double var2, double var4);

    private native void setLinearGradient(int var1, int var2, int var3, int var4, int var5, int var6, double var7, double var9, double var11, double var13, boolean var15);

    private native void setAlphaNative(double var1);

    private native void setFontNative(QtFontPeer var1);

    private native QPainterPath getClipNative();

    void setAlpha(double alpha) {
        this.currentAlpha = alpha;
        this.setAlphaNative(this.currentAlpha);
    }

    @Override
    public abstract Graphics create();

    @Override
    public abstract void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    @Override
    public abstract GraphicsConfiguration getDeviceConfiguration();

    @Override
    public Color getColor() {
        return new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
    }

    @Override
    public void setColor(Color c) {
        if (c == null) {
            c = Color.white;
        }
        this.color = c;
        int alpha = (int)((double)c.getAlpha() * this.currentAlpha);
        this.setColor(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    @Override
    public void setBackground(Color color) {
        this.bgcolor = new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    public Color getBackground() {
        return new Color(this.bgcolor.getRed(), this.bgcolor.getGreen(), this.bgcolor.getBlue());
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color color) {
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        if (onStroke) {
            Shape stroked = this.currentStroke.createStrokedShape(s);
            return stroked.intersects(rect.x, rect.y, rect.width, rect.height);
        }
        return s.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        this.font = font;
        if (font.getPeer() != null && font.getPeer() instanceof QtFontPeer) {
            this.setFontNative((QtFontPeer)font.getPeer());
        }
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return new QtFontMetrics(font, (Graphics)this);
    }

    @Override
    public void clip(Shape s) {
        this.intersectClipNative(new QPainterPath(s));
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.intersectClipRectNative(x, y, width, height);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setClipRectNative(x, y, width, height);
    }

    @Override
    public Shape getClip() {
        return this.getClipNative().getPath();
    }

    @Override
    public native Rectangle getClipBounds();

    @Override
    public void setClip(Shape clip) {
        if (clip == null) {
            this.resetClip();
        } else {
            this.setClipNative(new QPainterPath(clip));
        }
    }

    @Override
    public void draw(Shape s) {
        if (this.nativeStroking) {
            this.drawNative(new QPainterPath(s));
        } else {
            this.fillNative(new QPainterPath(this.currentStroke.createStrokedShape(s)));
        }
    }

    @Override
    public void fill(Shape s) {
        this.fillNative(new QPainterPath(s));
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.nativeStroking) {
            this.drawNative(new QPainterPath(x1, y1, x2, y2, true));
        } else {
            this.draw(new Line2D.Double(x1, y1, x2, y2));
        }
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        if (this.nativeStroking) {
            this.drawNative(new QPainterPath(x, y, width, height));
        } else {
            this.fillNative(new QPainterPath(this.currentStroke.createStrokedShape(new Rectangle2D.Double(x, y, width, height))));
        }
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.fillNative(new QPainterPath(x, y, width, height));
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Color c = this.color;
        this.setColor(this.bgcolor);
        this.fillRect(x, y, width, height);
        this.setColor(c);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.draw(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fill(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.draw(new Ellipse2D.Double(x, y, width, height));
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.fill(new Ellipse2D.Double(x, y, width, height));
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int arcStart, int arcAngle) {
        this.draw(new Arc2D.Double(x, y, width, height, arcStart, arcAngle, 0));
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int arcStart, int arcAngle) {
        this.fill(new Arc2D.Double(x, y, width, height, arcStart, arcAngle, 1));
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int npoints) {
        int i = 0;
        while (i < npoints - 1) {
            this.drawLine(xPoints[i], yPoints[i], xPoints[i + 1], yPoints[i + 1]);
            ++i;
        }
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int npoints) {
        this.draw(new Polygon(xPoints, yPoints, npoints));
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int npoints) {
        this.fill(new Polygon(xPoints, yPoints, npoints));
    }

    @Override
    public native void fill3DRect(int var1, int var2, int var3, int var4, boolean var5);

    @Override
    public native void draw3DRect(int var1, int var2, int var3, int var4, boolean var5);

    @Override
    public void drawString(String string, int x, int y) {
        this.drawStringNative(string, x, y);
    }

    @Override
    public void drawString(String string, float x, float y) {
        this.drawStringNative(string, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator ci, int x, int y) {
        String s = "";
        char c = ci.first();
        while (c != '\uffff') {
            s = String.valueOf(s) + c;
            c = ci.next();
        }
        this.drawString(s, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator ci, float x, float y) {
        String s = "";
        char c = ci.first();
        while (c != '\uffff') {
            s = String.valueOf(s) + c;
            c = ci.next();
        }
        this.drawString(s, x, y);
    }

    @Override
    public void drawGlyphVector(GlyphVector v, float x, float y) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean drawImage(Image image, AffineTransform Tx, ImageObserver obs) {
        if (image instanceof QtImage) {
            return ((QtImage)image).drawImage(this, new QMatrix(Tx), obs);
        }
        return new QtImage(image.getSource()).drawImage(this, new QMatrix(Tx), obs);
    }

    @Override
    public boolean drawImage(Image image, int x, int y, Color bgcolor, ImageObserver observer) {
        if (image instanceof QtImage) {
            return ((QtImage)image).drawImage(this, x, y, bgcolor, observer);
        }
        return new QtImage(image.getSource()).drawImage(this, x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        if (image instanceof QtImage) {
            return ((QtImage)image).drawImage(this, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
        }
        return new QtImage(image.getSource()).drawImage(this, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image image, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        if (image instanceof QtImage) {
            return ((QtImage)image).drawImage(this, x, y, width, height, bgcolor, observer);
        }
        return new QtImage(image.getSource()).drawImage(this, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image image, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(image, x, y, width, height, null, observer);
    }

    @Override
    public boolean drawImage(Image image, int x, int y, ImageObserver observer) {
        return this.drawImage(image, x, y, null, observer);
    }

    @Override
    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    @Override
    public AffineTransform getTransform() {
        return new AffineTransform(this.xform);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.xform = new AffineTransform(Tx);
        this.setQtTransform(new QMatrix(this.xform));
    }

    @Override
    public void rotate(double theta) {
        this.xform.rotate(theta);
        this.setQtTransform(new QMatrix(this.xform));
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.xform.rotate(theta, x, y);
        this.setQtTransform(new QMatrix(this.xform));
    }

    @Override
    public void scale(double sx, double sy) {
        this.xform.scale(sx, sy);
        this.setQtTransform(new QMatrix(this.xform));
    }

    @Override
    public void shear(double shx, double shy) {
        this.xform.shear(shx, shy);
        this.setQtTransform(new QMatrix(this.xform));
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.xform.concatenate(Tx);
        this.setQtTransform(new QMatrix(this.xform));
    }

    @Override
    public void translate(double tx, double ty) {
        this.xform.translate(tx, ty);
        this.setQtTransform(new QMatrix(this.xform));
    }

    @Override
    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    @Override
    public void setStroke(Stroke s) {
        try {
            QPen pen = new QPen(s);
            this.nativeStroking = true;
            this.setNativeStroke(pen);
            this.setColor(this.color);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.nativeStroking = false;
        }
        this.currentStroke = s;
    }

    @Override
    public Stroke getStroke() {
        return this.currentStroke;
    }

    @Override
    public void setComposite(Composite comp) {
        if (comp == null) {
            this.setNativeComposite(3);
            return;
        }
        if (comp instanceof AlphaComposite) {
            if (((AlphaComposite)comp).getRule() != 12) {
                this.setAlpha(((AlphaComposite)comp).getAlpha());
            }
        } else {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new AWTPermission("readDisplayPixels"));
            }
            throw new UnsupportedOperationException("We don't support custom composites yet.");
        }
        this.setNativeComposite(((AlphaComposite)comp).getRule());
        this.composite = comp;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public void setPaint(Paint p) {
        if (p == null) {
            return;
        }
        this.currentPaint = p;
        if (p instanceof GradientPaint) {
            GradientPaint lg = (GradientPaint)p;
            this.setLinearGradient(lg.getColor1().getRed(), lg.getColor1().getGreen(), lg.getColor1().getBlue(), lg.getColor2().getRed(), lg.getColor2().getGreen(), lg.getColor2().getBlue(), lg.getPoint1().getX(), lg.getPoint1().getY(), lg.getPoint2().getX(), lg.getPoint2().getY(), lg.isCyclic());
            return;
        }
        if (p instanceof Color) {
            this.setColor((Color)p);
            return;
        }
        throw new UnsupportedOperationException("We don't support custom paints yet.");
    }

    @Override
    public Paint getPaint() {
        return this.currentPaint;
    }

    public void addRenderingHints(Map hints) {
        this.renderingHints.putAll((Map<?, ?>)hints);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.renderingHints.get(hintKey);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return (RenderingHints)this.renderingHints.clone();
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.renderingHints = new RenderingHints(null);
        this.renderingHints.putAll(hints);
        this.updateRenderingHints();
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.renderingHints.put(hintKey, hintValue);
        this.updateRenderingHints();
    }

    private void updateRenderingHints() {
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void drawRenderableImage(RenderableImage image, AffineTransform xform) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void drawRenderedImage(RenderedImage image, AffineTransform xform) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void drawImage(BufferedImage image, BufferedImageOp op, int x, int y) {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

