package Wx::Mini; # for RPM

package Wx;

use strict;

our( $VERSION, $XS_VERSION );
our $alien_key = 'gtk2_gcc';

{
    my $VAR1;
    $Wx::dlls = $VAR1 = {
          'gizmos' => 'libwx_gtk2_gizmos.so.3.0',
          'net' => 'libwx_base_net.so.3.0',
          'xrc' => 'libwx_gtk2_xrc.so.3.0',
          'base' => 'libwx_base.so.3.0',
          'fl' => 'libwx_gtk2_fl.so.3.0',
          'aui' => 'libwx_gtk2_aui.so.3.0',
          'richtext' => 'libwx_gtk2_richtext.so.3.0',
          'core' => 'libwx_gtk2_core.so.3.0',
          'gl' => 'libwx_gtk2_gl.so.3.0',
          'stc' => 'libwx_gtk2_stc.so.3.0',
          'adv' => 'libwx_gtk2_adv.so.3.0',
          'qa' => 'libwx_gtk2_qa.so.3.0',
          'html' => 'libwx_gtk2_html.so.3.0',
          'xml' => 'libwx_base_xml.so.3.0'
        };
;
}

$VERSION = '0.92'; # bootstrap will catch wrong versions
$XS_VERSION = $VERSION;
$VERSION = eval $VERSION;

#
# XSLoader/DynaLoader wrapper
#
our( $wx_path );

sub wxPL_STATIC();
sub wx_boot($$) {
  local $ENV{PATH} = $wx_path . ';' . $ENV{PATH} if $wx_path;
  if( $_[0] eq 'Wx' || !wxPL_STATIC ) {
    if( $] < 5.006 ) {
      require DynaLoader;
      no strict 'refs';
      push @{"$_[0]::ISA"}, 'DynaLoader';
      $_[0]->bootstrap( $_[1] );
    } else {
      require XSLoader;
      XSLoader::load( $_[0], $_[1] );
    }
  } else {
    no strict 'refs';
    my $t = $_[0]; $t =~ tr/:/_/;
    &{"_boot_$t"}( $_[0], $_[1] );
  }
}

sub _alien_path {
  return if defined $wx_path;
  return unless length 'local';
  foreach ( @INC ) {
    if( -d "$_/Alien/wxWidgets/local" ) {
      $wx_path = "$_/Alien/wxWidgets/local/lib";
      last;
    }
  }
}

_alien_path();

sub _start {
    wx_boot( 'Wx', $XS_VERSION );

    _boot_Constant( 'Wx', $XS_VERSION );
    _boot_GDI( 'Wx', $XS_VERSION );

    Load();
}

1;
