package Alien::wxWidgets::Config::gtk2_gcc;

use strict;

our %VALUES;

{
    no strict 'vars';
    %VALUES = %{
$VAR1 = {
          'version' => '2.008012',
          'link_flags' => '',
          'config' => {
                        'build' => 'multi',
                        'debug' => 0,
                        'unicode' => 0,
                        'toolkit' => 'gtk2',
                        'compiler_version' => '3.4',
                        'compiler_kind' => 'gcc',
                        'mslu' => 0
                      },
          'alien_base' => 'gtk2_gcc',
          'compiler' => 'c++',
          'alien_package' => 'Alien::wxWidgets::Config::gtk2_gcc',
          'include_path' => '-I/usr/local/lib/wx/include/gtk2-unicode-release-2.8 -I/usr/local/include ',
          'c_flags' => '-pthread ',
          'linker' => 'c++ -shared -fPIC  ',
          '_libraries' => {
                            'base' => {
                                        'dll' => 'libwx_base.so.3.0',
                                        'link' => '-lwx_base'
                                      },
                            'core' => {
                                        'dll' => 'libwx_gtk2_core.so.3.0',
                                        'link' => '-lwx_gtk2_core'
                                      },
                            'xrc' => {
                                       'dll' => 'libwx_gtk2_xrc.so.3.0',
                                       'link' => '-lwx_gtk2_xrc'
                                     },
                            'html' => {
                                        'dll' => 'libwx_gtk2_html.so.3.0',
                                        'link' => '-lwx_gtk2_html'
                                      },
                            'richtext' => {
                                            'dll' => 'libwx_gtk2_richtext.so.3.0',
                                            'link' => '-lwx_gtk2_richtext'
                                          },
                            'qa' => {
                                      'dll' => 'libwx_gtk2_qa.so.3.0',
                                      'link' => '-lwx_gtk2_qa'
                                    },
                            'stc' => {
                                       'link' => '-lwx_gtk2_stc',
                                       'dll' => 'libwx_gtk2_stc.so.3.0'
                                     },
                            'adv' => {
                                       'dll' => 'libwx_gtk2_adv.so.3.0',
                                       'link' => '-lwx_gtk2_adv'
                                     },
                            'gl' => {
                                      'link' => '-lwx_gtk2_gl',
                                      'dll' => 'libwx_gtk2_gl.so.3.0'
                                    },
                            'xml' => {
                                       'link' => '-lwx_base_xml',
                                       'dll' => 'libwx_base_xml.so.3.0'
                                     },
                            'fl' => {
                                      'dll' => 'libwx_gtk2_fl.so.3.0',
                                      'link' => '-lwx_gtk2_fl'
                                    },
                            'net' => {
                                       'dll' => 'libwx_base_net.so.3.0',
                                       'link' => '-lwx_base_net'
                                     },
                            'aui' => {
                                       'dll' => 'libwx_gtk2_aui.so.3.0',
                                       'link' => '-lwx_gtk2_aui'
                                     },
                            'gizmos' => {
                                          'link' => '-lwx_gtk2_gizmos',
                                          'dll' => 'libwx_gtk2_gizmos.so.3.0'
                                        }
                          },
          'prefix' => '/usr/local',
          'defines' => '-D_FILE_OFFSET_BITS=64 -D_LARGE_FILES -D_IODBC_ -D__WXGTK__ ',
          'link_libraries' => ' -L/usr/local/lib -pthread -L/usr/local/lib -L/usr/X11R6/lib'
        };
    };
}

my $key = substr __PACKAGE__, 1 + rindex __PACKAGE__, ':';

sub values { %VALUES, key => $key }

sub config {
   +{ %{$VALUES{config}},
      package       => __PACKAGE__,
      key           => $key,
      version       => $VALUES{version},
      }
}

1;
