/*
 * This file has been generated by the onto2vocabularyclass tool
 * copyright (C) 2007-2010 Sebastian Trueg <trueg@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _SOPRANO_NDO_H_
#define _SOPRANO_NDO_H_

#include <QtCore/QUrl>
#include "nepomuk_export.h"

namespace Nepomuk2 {
    namespace Vocabulary {
        namespace NDO {
            /**
             * http://www.semanticdesktop.org/ontologies/2010/04/30/ndo#
             */
            NEPOMUK_EXPORT QUrl ndoNamespace();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/04/30/ndo#DownloadEvent 
             * 
             * A single event (from the point of view of the user) of downloading 
             * of a file or a set of files. Use nuao:involves to indicate the 
             * files involved. The event is assigned to downloaded copies 
             * of files. Can be assigned to multiple files. 
             */
            NEPOMUK_EXPORT QUrl DownloadEvent();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/04/30/ndo#P2PFile 
             * 
             * A file available via a peer-to-peer network 
             */
            NEPOMUK_EXPORT QUrl P2PFile();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/04/30/ndo#Torrent 
             * 
             * A .torrent file which contains references(ndo:TorrentedFile) 
             * to files available via BitTorrent. The references are pointed 
             * to via nie:hasLogicalPart 
             */
            NEPOMUK_EXPORT QUrl Torrent();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/04/30/ndo#TorrentedFile 
             * 
             * A file available via a BitTorrent peer-to-peer network 
             */
            NEPOMUK_EXPORT QUrl TorrentedFile();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/04/30/ndo#copiedFrom 
             * 
             * Links a DataObject with its copy. This relation means that originally 
             * the Data Objects were copies but might have changed subsequentially. 
             */
            NEPOMUK_EXPORT QUrl copiedFrom();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/04/30/ndo#referrer 
             * 
             * Points to the Information Element that contained the link to 
             * the download source which was used in the download event. 
             */
            NEPOMUK_EXPORT QUrl referrer();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/04/30/ndo/metadata 
             */
            NEPOMUK_EXPORT QUrl metadata();
        }
    }
}

#endif
