/* ============================================================
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2004-12-14
 * Copyright 2004 by Renchi Raju
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * ============================================================ */

#ifndef KEXIFWIDGET_H
#define KEXIFWIDGET_H

#include <qwidget.h>
#include "libkexif_export.h"
class KExifData;
class KExifListView;

class LIBKEXIF_EXPORT KExifWidget : public QWidget
{
    Q_OBJECT
    
public:

    enum Mode
    {
        SIMPLE,
        FULL
    };

    KExifWidget(QWidget* parent, const char* name=0);
    ~KExifWidget();

    bool loadFile(const QString& filename);
    bool loadData(char *data, int size);
    void setMode(Mode mode);

    KExifData* exifData() const;

    QString getCurrentItemName() const;
    void    setCurrentItem(const QString& itemName);
    
private:

    void buildView();

private:

    KExifData*     m_data;
    KExifListView* m_view;
    Mode           m_mode;
};

#endif /* KEXIFWIDGET_H */
