// -*- c++ -*-
// Generated by gmmproc 2.39.93 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_AUDIOSRC_H
#define _GSTREAMERMM_AUDIOSRC_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include <gstreamermm/audioringbuffer.h>
#include <gst/audio/gstaudiosrc.h>
#include <gstreamermm/audiobasesrc.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstAudioSrc GstAudioSrc;
typedef struct _GstAudioSrcClass GstAudioSrcClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class AudioSrc_Class; } // namespace Gst
namespace Gst
{

/** A simple base class for audio sources.
 * This is the most simple base class for audio sources that only requires
 * subclasses to implement a set of simple virtual functions:
 *
 * - open_vfunc() - Open the device.
 * - prepare_vfunc()  - Configure the device with the specified format.
 * - read_vfunc() - Read samples from the device.
 * - reset_vfunc() - Unblock reads and flush the device.
 * - get_delay_vfunc() - Get the number of samples written but not yet played
 * by the device.
 * - unprepare_vfunc() - Undo operations done by prepare.
 * - close_vfunc() - Close the device.
 *
 * All scheduling of samples and timestamps is done in this base class together
 * with Gst::AudioBaseSrc using a default implementation of a
 * Gst::AudioRingBuffer that uses threads.
 *
 * Last reviewed on 2006-09-27 (0.10.12)
 *
 * @ingroup GstBaseClasses
 */

class AudioSrc : public Gst::AudioBaseSrc
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef AudioSrc CppObjectType;
  typedef AudioSrc_Class CppClassType;
  typedef GstAudioSrc BaseObjectType;
  typedef GstAudioSrcClass BaseClassType;

private:  friend class AudioSrc_Class;
  static CppClassType audiosrc_class_;

private:
  // noncopyable
  AudioSrc(const AudioSrc&);
  AudioSrc& operator=(const AudioSrc&);

protected:
  explicit AudioSrc(const Glib::ConstructParams& construct_params);
  explicit AudioSrc(GstAudioSrc* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~AudioSrc();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstAudioSrc*       gobj()       { return reinterpret_cast<GstAudioSrc*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstAudioSrc* gobj() const { return reinterpret_cast<GstAudioSrc*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstAudioSrc* gobj_copy();

private:


public:
  /** vfunc to open the device.
   */
    virtual bool open_vfunc();


  /** vfunc to configure device with spec.
   */
  virtual bool prepare_vfunc(Gst::AudioRingBufferSpec& spec);

  /** vfunc to undo the configuration.
   */
    virtual bool unprepare_vfunc();


  /** vfunc to close the device.
   */
    virtual bool close_vfunc();


  /** vfunc to read samples to the audio device.
   */
  virtual guint read_vfunc(const void* data, guint length, ClockTime* timestamp);

  /** vfunc to get the number of samples queued in the device.
   */
    virtual guint get_delay_vfunc() const;


  /** vfunc to unblock a read to the device and reset.
   */
    virtual void reset_vfunc();


protected:

  
public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::AudioSrc
   */
  Glib::RefPtr<Gst::AudioSrc> wrap(GstAudioSrc* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_AUDIOSRC_H */

