/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.ber;

import gnu.java.security.ber.BER;
import gnu.java.security.ber.BERValue;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BERReader
extends DERReader
implements BER {
    public BERReader(byte[] in) {
        super(in);
    }

    public BERReader(byte[] in, int off, int len) {
        super(in, off, len);
    }

    public BERReader(InputStream in) {
        super(in);
    }

    public DERValue read() throws IOException {
        this.in.mark(2);
        int tag = this.in.read();
        if (tag == -1) {
            throw new EOFException();
        }
        int length = this.in.read();
        if (length == 0) {
            if (tag == 0) {
                return END_OF_SEQUENCE;
            }
            byte[] byArray = new byte[2];
            byArray[0] = (byte)tag;
            return new BERValue(tag, CONSTRUCTED_VALUE, byArray);
        }
        this.in.reset();
        return super.read();
    }

    public int peek() throws IOException {
        this.in.mark(1);
        int ret = this.in.read();
        this.in.reset();
        return ret;
    }
}

