/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.cpdsadapter;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.PoolablePreparedStatement;
import org.apache.tomcat.dbcp.dbcp2.cpdsadapter.ConnectionImpl;
import org.apache.tomcat.dbcp.dbcp2.cpdsadapter.PStmtKeyCPDS;
import org.apache.tomcat.dbcp.pool2.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.KeyedPooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObject;

class PooledConnectionImpl
implements PooledConnection,
KeyedPooledObjectFactory<PStmtKeyCPDS, PoolablePreparedStatement<PStmtKeyCPDS>> {
    private static final String CLOSED = "Attempted to use PooledConnection after closed() was called.";
    private Connection connection = null;
    private final DelegatingConnection<?> delegatingConnection;
    private Connection logicalConnection = null;
    private final Vector<ConnectionEventListener> eventListeners;
    private final Vector<StatementEventListener> statementEventListeners = new Vector();
    private boolean isClosed;
    private KeyedObjectPool<PStmtKeyCPDS, PoolablePreparedStatement<PStmtKeyCPDS>> pstmtPool = null;
    private boolean accessToUnderlyingConnectionAllowed = false;

    PooledConnectionImpl(Connection connection) {
        this.connection = connection;
        this.delegatingConnection = connection instanceof DelegatingConnection ? (DelegatingConnection<Object>)connection : new DelegatingConnection<Connection>(connection);
        this.eventListeners = new Vector();
        this.isClosed = false;
    }

    public void setStatementPool(KeyedObjectPool<PStmtKeyCPDS, PoolablePreparedStatement<PStmtKeyCPDS>> statementPool) {
        this.pstmtPool = statementPool;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        if (!this.statementEventListeners.contains(listener)) {
            this.statementEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        block14: {
            this.assertOpen();
            this.isClosed = true;
            try {
                if (this.pstmtPool == null) break block14;
                try {
                    this.pstmtPool.close();
                }
                finally {
                    this.pstmtPool = null;
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException("Cannot close connection (return to pool failed)", e);
            }
            finally {
                try {
                    this.connection.close();
                }
                finally {
                    this.connection = null;
                }
            }
        }
    }

    private void assertOpen() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(CLOSED);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.assertOpen();
        if (this.logicalConnection != null && !this.logicalConnection.isClosed()) {
            throw new SQLException("PooledConnection was reused, withoutits previous Connection being closed.");
        }
        this.logicalConnection = new ConnectionImpl(this, this.connection, this.isAccessToUnderlyingConnectionAllowed());
        return this.logicalConnection;
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.eventListeners.remove(listener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.remove(listener);
    }

    protected void finalize() throws Throwable {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.logicalConnection != null && !this.logicalConnection.isClosed()) {
            throw new SQLException("PooledConnection was gc'ed, withoutits last Connection being closed.");
        }
    }

    void notifyListeners() {
        Object[] listeners;
        ConnectionEvent event = new ConnectionEvent(this);
        for (Object listener : listeners = this.eventListeners.toArray()) {
            ((ConnectionEventListener)listener).connectionClosed(event);
        }
    }

    PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(sql);
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(sql));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(sql, autoGeneratedKeys);
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(sql, autoGeneratedKeys));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(sql, columnIndexes);
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(sql, columnIndexes));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(sql, columnNames);
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(sql, columnNames));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    protected PStmtKeyCPDS createKey(String sql, int autoGeneratedKeys) {
        return new PStmtKeyCPDS(this.normalizeSQL(sql), autoGeneratedKeys);
    }

    protected PStmtKeyCPDS createKey(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new PStmtKeyCPDS(this.normalizeSQL(sql), resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    protected PStmtKeyCPDS createKey(String sql, int[] columnIndexes) {
        return new PStmtKeyCPDS(this.normalizeSQL(sql), columnIndexes);
    }

    protected PStmtKeyCPDS createKey(String sql, String[] columnNames) {
        return new PStmtKeyCPDS(this.normalizeSQL(sql), columnNames);
    }

    protected PStmtKeyCPDS createKey(String sql, int resultSetType, int resultSetConcurrency) {
        return new PStmtKeyCPDS(this.normalizeSQL(sql), resultSetType, resultSetConcurrency);
    }

    protected PStmtKeyCPDS createKey(String sql) {
        return new PStmtKeyCPDS(this.normalizeSQL(sql));
    }

    protected String normalizeSQL(String sql) {
        return sql.trim();
    }

    @Override
    public PooledObject<PoolablePreparedStatement<PStmtKeyCPDS>> makeObject(PStmtKeyCPDS key) throws Exception {
        if (null == key) {
            throw new IllegalArgumentException();
        }
        if (null == key.getResultSetType() && null == key.getResultSetConcurrency()) {
            if (null == key.getAutoGeneratedKeys()) {
                return new DefaultPooledObject<PoolablePreparedStatement<PStmtKeyCPDS>>(new PoolablePreparedStatement<PStmtKeyCPDS>(this.connection.prepareStatement(key.getSql()), key, this.pstmtPool, this.delegatingConnection));
            }
            return new DefaultPooledObject<PoolablePreparedStatement<PStmtKeyCPDS>>(new PoolablePreparedStatement<PStmtKeyCPDS>(this.connection.prepareStatement(key.getSql(), key.getAutoGeneratedKeys()), key, this.pstmtPool, this.delegatingConnection));
        }
        return new DefaultPooledObject<PoolablePreparedStatement<PStmtKeyCPDS>>(new PoolablePreparedStatement<PStmtKeyCPDS>(this.connection.prepareStatement(key.getSql(), key.getResultSetType(), key.getResultSetConcurrency()), key, this.pstmtPool, this.delegatingConnection));
    }

    @Override
    public void destroyObject(PStmtKeyCPDS key, PooledObject<PoolablePreparedStatement<PStmtKeyCPDS>> p) throws Exception {
        p.getObject().getInnermostDelegate().close();
    }

    @Override
    public boolean validateObject(PStmtKeyCPDS key, PooledObject<PoolablePreparedStatement<PStmtKeyCPDS>> p) {
        return true;
    }

    @Override
    public void activateObject(PStmtKeyCPDS key, PooledObject<PoolablePreparedStatement<PStmtKeyCPDS>> p) throws Exception {
        p.getObject().activate();
    }

    @Override
    public void passivateObject(PStmtKeyCPDS key, PooledObject<PoolablePreparedStatement<PStmtKeyCPDS>> p) throws Exception {
        PoolablePreparedStatement<PStmtKeyCPDS> ppss = p.getObject();
        ppss.clearParameters();
        ppss.passivate();
    }

    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public synchronized void setAccessToUnderlyingConnectionAllowed(boolean allow) {
        this.accessToUnderlyingConnectionAllowed = allow;
    }
}

