/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.spdy;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tomcat.spdy.CompressDeflater6;
import org.apache.tomcat.spdy.SpdyContext;
import org.apache.tomcat.spdy.SpdyFrame;
import org.apache.tomcat.spdy.SpdyStream;

public abstract class SpdyConnection {
    private volatile SpdyFrame inFrame;
    private CompressSupport compressSupport;
    private final Map<Integer, SpdyStream> channels = new HashMap<Integer, SpdyStream>();
    private static final Logger log = Logger.getLogger(SpdyConnection.class.getName());
    public static final int TYPE_SYN_STREAM = 1;
    public static final int TYPE_SYN_REPLY = 2;
    public static final int TYPE_RST_STREAM = 3;
    public static final int TYPE_SETTINGS = 4;
    public static final int TYPE_PING = 6;
    public static final int TYPE_GOAWAY = 7;
    public static final int TYPE_HEADERS = 8;
    public static final int TYPE_WINDOW = 8;
    public static String[] TYPES = new String[]{"SYN_STREAM", "SYN_REPLY", "RST_STREAM", "SETTINGS", "5", "PING", "GOAWAY", "HEADERS", "WINDOW_UPDATE"};
    static final int FLAG_HALF_CLOSE = 1;
    private static final String[] RST_ERRORS = new String[]{"PROTOCOL_ERROR", "INVALID_STREAM", "REFUSED_STREAM", "UNSUPPORTED_VERSION", "CANCEL", "FLOW_CONTROL_ERROR", "STREAM_IN_USE", "STREAM_ALREADY_CLOSED"};
    protected final SpdyContext spdyContext;
    protected boolean inClosed;
    private int lastChannel;
    private int outStreamId = 1;
    private final LinkedList<SpdyFrame> prioriyQueue = new LinkedList();
    private final LinkedList<SpdyFrame> outQueue = new LinkedList();
    public static final int LONG = 1;
    public static final int CLOSE = -1;
    private SpdyFrame nextFrame;
    private SpdyFrame out;
    private int goAway = Integer.MAX_VALUE;
    private final Runnable nbDrain = new Runnable(){

        @Override
        public void run() {
            SpdyConnection.this.drain();
        }
    };

    public SpdyConnection(SpdyContext spdyContext) {
        this.spdyContext = spdyContext;
        if (spdyContext.compression) {
            this.setCompressSupport(CompressDeflater6.get());
        }
    }

    public String toString() {
        return "SpdyCon open=" + this.channels.size() + " " + this.lastChannel;
    }

    public void dump(PrintWriter out) {
        out.println("SpdyConnection open=" + this.channels.size() + " outQ:" + this.outQueue.size());
        for (SpdyStream str : this.channels.values()) {
            str.dump(out);
        }
        out.println();
    }

    public abstract int write(byte[] var1, int var2, int var3) throws IOException;

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public abstract void close() throws IOException;

    public void setCompressSupport(CompressSupport cs) {
        this.compressSupport = cs;
    }

    public SpdyFrame getFrame(int type) {
        SpdyFrame frame = this.getSpdyContext().getFrame();
        frame.c = true;
        frame.type = type;
        return frame;
    }

    public SpdyFrame getDataFrame() {
        SpdyFrame frame = this.getSpdyContext().getFrame();
        return frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain() {
        Runnable runnable = this.nbDrain;
        synchronized (runnable) {
            this._drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _drain() {
        while (true) {
            LinkedList<SpdyFrame> linkedList = this.outQueue;
            synchronized (linkedList) {
                if (this.out == null) {
                    this.out = this.prioriyQueue.poll();
                    if (this.out == null) {
                        this.out = this.outQueue.poll();
                    }
                    if (this.out == null) {
                        return false;
                    }
                    if (this.goAway < this.out.streamId) {
                        // empty if block
                    }
                    try {
                        if (!this.out.c) {
                            if (this.out.stream != null) {
                                this.out.streamId = this.out.stream.getRequest().streamId;
                            }
                        } else if (this.out.type == 1) {
                            this.out.fixNV(18);
                            if (this.compressSupport != null) {
                                this.compressSupport.compress(this.out, 18);
                            }
                        } else if (this.out.type == 2 || this.out.type == 8) {
                            this.out.fixNV(14);
                            if (this.compressSupport != null) {
                                this.compressSupport.compress(this.out, 14);
                            }
                        }
                    }
                    catch (IOException ex) {
                        this.abort("Compress error");
                        return false;
                    }
                    if (this.out.type == 1) {
                        this.out.streamId = this.outStreamId;
                        this.outStreamId += 2;
                        Map<Integer, SpdyStream> ex = this.channels;
                        synchronized (ex) {
                            this.channels.put(this.out.streamId, this.out.stream);
                        }
                    }
                    this.out.serializeHead();
                }
                if (this.out.endData == this.out.off) {
                    this.out = null;
                    continue;
                }
            }
            try {
                int toWrite = this.out.endData - this.out.off;
                while (toWrite > 0) {
                    int wr = this.write(this.out.data, this.out.off, toWrite);
                    if (wr < 0) {
                        return false;
                    }
                    if (wr == 0) {
                        return true;
                    }
                    if (wr > toWrite) continue;
                    this.out.off += wr;
                    toWrite -= wr;
                }
                Map<Integer, SpdyStream> map = this.channels;
                synchronized (map) {
                    if (this.out.stream != null) {
                        if (this.out.isHalfClose()) {
                            this.out.stream.finSent = true;
                        }
                        if (this.out.stream.finRcvd && this.out.stream.finSent) {
                            this.channels.remove(this.out.streamId);
                        }
                    }
                }
                this.out = null;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.onClose();
                return false;
            }
        }
    }

    public void nonBlockingSend(SpdyFrame oframe, SpdyStream proc) {
        this.queueFrame(oframe, proc, oframe.pri == 0 ? this.outQueue : this.prioriyQueue);
        this.getSpdyContext().getExecutor().execute(this.nbDrain);
    }

    public void send(SpdyFrame oframe, SpdyStream proc) {
        this.queueFrame(oframe, proc, oframe.pri == 0 ? this.outQueue : this.prioriyQueue);
        this.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueFrame(SpdyFrame oframe, SpdyStream proc, LinkedList<SpdyFrame> queue) {
        oframe.endData = oframe.off;
        oframe.off = 0;
        oframe.stream = proc;
        LinkedList<SpdyFrame> linkedList = this.outQueue;
        synchronized (linkedList) {
            queue.add(oframe);
        }
    }

    public void onClose() {
    }

    private void trace(String s) {
        System.err.println(s);
    }

    public SpdyFrame inFrame() {
        return this.inFrame;
    }

    public int onBlockingSocket() {
        try {
            int rc = this.processInput();
            return rc;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.trace("< onData-ERROR() " + this.lastChannel);
            this.abort("Error processing socket" + t);
            return -1;
        }
    }

    public int processInput() throws IOException {
        while (true) {
            if (this.inFrame == null) {
                this.inFrame = this.getSpdyContext().getFrame();
            }
            if (this.inFrame.data == null) {
                this.inFrame.data = new byte[16384];
            }
            if (this.inFrame.endReadData < 8 || this.inFrame.endReadData < this.inFrame.endData) {
                int rd = this.read(this.inFrame.data, this.inFrame.endReadData, this.inFrame.data.length - this.inFrame.endReadData);
                if (rd == -1) {
                    if (this.channels.size() == 0) {
                        return -1;
                    }
                    this.abort("Closed");
                } else {
                    if (rd < 0) {
                        this.abort("Closed - read error");
                        return -1;
                    }
                    if (rd == 0) {
                        return 1;
                    }
                }
                this.inFrame.endReadData += rd;
            }
            if (this.inFrame.endReadData < 8) continue;
            if (this.inFrame.endData == 0) {
                this.inFrame.parse();
                if (this.inFrame.version != 2) {
                    this.abort("Wrong version");
                    return -1;
                }
                if (this.inFrame.endData < 0 || this.inFrame.endData > 32000) {
                    this.abort("Framing error, size = " + this.inFrame.endData);
                    return -1;
                }
                if (this.inFrame.data.length < this.inFrame.endData) {
                    byte[] tmp = new byte[this.inFrame.endData];
                    System.arraycopy(this.inFrame.data, 0, tmp, 0, this.inFrame.endReadData);
                    this.inFrame.data = tmp;
                }
            }
            if (this.inFrame.endReadData < this.inFrame.endData) continue;
            int extra = this.inFrame.endReadData - this.inFrame.endData;
            if (extra > 0) {
                this.nextFrame = this.getSpdyContext().getFrame();
                this.nextFrame.makeSpace(extra);
                System.arraycopy(this.inFrame.data, this.inFrame.endData, this.nextFrame.data, 0, extra);
                this.nextFrame.endReadData = extra;
                this.inFrame.endReadData = this.inFrame.endData;
            }
            if (this.inFrame.type == 1) {
                this.lastChannel = this.inFrame.streamId = this.inFrame.readInt();
                this.inFrame.associated = this.inFrame.readInt();
                this.inFrame.pri = this.inFrame.read16();
                if (this.compressSupport != null) {
                    this.compressSupport.decompress(this.inFrame, 18);
                }
                this.inFrame.nvCount = this.inFrame.read16();
            } else if (this.inFrame.type == 2 || this.inFrame.type == 8) {
                this.inFrame.streamId = this.inFrame.readInt();
                this.inFrame.read16();
                if (this.compressSupport != null) {
                    this.compressSupport.decompress(this.inFrame, 14);
                }
                this.inFrame.nvCount = this.inFrame.read16();
            }
            try {
                int state = this.handleFrame();
                if (state == -1) {
                    return state;
                }
            }
            catch (Throwable t) {
                this.abort("Error handling frame");
                t.printStackTrace();
                return -1;
            }
            if (this.inFrame != null) {
                this.inFrame.recyle();
                if (this.nextFrame == null) continue;
                this.inFrame = this.nextFrame;
                this.nextFrame = null;
                continue;
            }
            this.inFrame = this.nextFrame;
            this.nextFrame = null;
            if (this.inFrame != null) continue;
            this.inFrame = this.getSpdyContext().getFrame();
        }
    }

    public void abort(String msg) {
        System.err.println(msg);
        this.inClosed = true;
        ArrayList<Integer> ch = new ArrayList<Integer>(this.channels.keySet());
        for (Integer i : ch) {
            SpdyStream stream = this.channels.remove(i);
            if (stream == null) continue;
            stream.onReset();
        }
    }

    public void abort(String msg, int last) {
        System.err.println(msg);
        this.inClosed = true;
        ArrayList<Integer> ch = new ArrayList<Integer>(this.channels.keySet());
        for (Integer i : ch) {
            SpdyStream stream;
            if (i <= last || (stream = this.channels.remove(i)) == null) continue;
            stream.onReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int handleFrame() throws IOException {
        block33: {
            SpdyStream sch;
            block32: {
                if (!this.inFrame.c) break block32;
                switch (this.inFrame.type) {
                    case 4: {
                        int cnt = this.inFrame.readInt();
                        for (int i = 0; i < cnt; ++i) {
                            this.inFrame.readByte();
                            this.inFrame.read24();
                            this.inFrame.readInt();
                        }
                        break block33;
                    }
                    case 7: {
                        int lastStream = this.inFrame.readInt();
                        log.info("GOAWAY last=" + lastStream);
                        this.abort("GO_AWAY", lastStream);
                        this.goAway = lastStream;
                        return -1;
                    }
                    case 3: {
                        SpdyStream sch2;
                        this.inFrame.streamId = this.inFrame.read32();
                        int errCode = this.inFrame.read32();
                        Map<Integer, SpdyStream> map = this.channels;
                        synchronized (map) {
                            sch2 = this.channels.remove(this.inFrame.streamId);
                        }
                        if (sch2 != null) {
                            sch2.onReset();
                        }
                        this.inFrame = null;
                        break;
                    }
                    case 1: {
                        SpdyStream ch = this.getSpdyContext().getStream(this);
                        Map<Integer, SpdyStream> sch2 = this.channels;
                        synchronized (sch2) {
                            this.channels.put(this.inFrame.streamId, ch);
                        }
                        try {
                            ch.onCtlFrame(this.inFrame);
                            this.inFrame = null;
                        }
                        catch (Throwable t) {
                            log.log(Level.SEVERE, "Error parsing head SYN_STREAM", t);
                            this.abort("Error reading headers " + t);
                            return -1;
                        }
                        this.spdyContext.onStream(this, ch);
                        break;
                    }
                    case 2: {
                        SpdyStream sch3;
                        Map<Integer, SpdyStream> t = this.channels;
                        synchronized (t) {
                            sch3 = this.channels.get(this.inFrame.streamId);
                        }
                        if (sch3 == null) {
                            this.abort("Missing channel");
                            return -1;
                        }
                        try {
                            sch3.onCtlFrame(this.inFrame);
                            this.inFrame = null;
                            break;
                        }
                        catch (Throwable t2) {
                            log.info("Error parsing head SYN_STREAM" + t2);
                            this.abort("Error reading headers " + t2);
                            return -1;
                        }
                    }
                    case 6: {
                        SpdyFrame oframe = this.getSpdyContext().getFrame();
                        oframe.type = 6;
                        oframe.c = true;
                        oframe.append32(this.inFrame.read32());
                        oframe.pri = 128;
                        this.send(oframe, null);
                        break;
                    }
                }
                break block33;
            }
            Map<Integer, SpdyStream> map = this.channels;
            synchronized (map) {
                sch = this.channels.get(this.inFrame.streamId);
            }
            if (sch == null) {
                this.abort("Missing channel");
                return -1;
            }
            sch.onDataFrame(this.inFrame);
            map = this.channels;
            synchronized (map) {
                if (sch.finRcvd && sch.finSent) {
                    this.channels.remove(this.inFrame.streamId);
                }
            }
            this.inFrame = null;
        }
        return 1;
    }

    public SpdyContext getSpdyContext() {
        return this.spdyContext;
    }

    public SpdyStream get(String host, String url) {
        SpdyStream sch = new SpdyStream(this);
        sch.getRequest().addHeader("host", host);
        sch.getRequest().addHeader("url", url);
        sch.send();
        return sch;
    }

    static interface CompressSupport {
        public void compress(SpdyFrame var1, int var2) throws IOException;

        public void decompress(SpdyFrame var1, int var2) throws IOException;
    }
}

