/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.spdy;

import java.io.IOException;
import org.apache.tomcat.jni.SSLExt;
import org.apache.tomcat.jni.socket.AprSocket;
import org.apache.tomcat.jni.socket.AprSocketContext;
import org.apache.tomcat.spdy.SpdyConnection;
import org.apache.tomcat.spdy.SpdyContext;

public class NetSupportOpenSSL
extends SpdyContext.NetSupport {
    private AprSocketContext con = new AprSocketContext();

    public NetSupportOpenSSL() {
        this.con.customVerification(new AprSocketContext.TlsCertVerifier(){

            public void handshakeDone(AprSocket ch) {
            }
        });
        this.con.setNpn("spdy/2");
    }

    @Override
    public boolean isSpdy(Object socketW) {
        byte[] proto = new byte[32];
        int len = SSLExt.getNPN((long)((Long)socketW), (byte[])proto);
        return len == 6;
    }

    @Override
    public SpdyConnection getConnection(String host, int port) throws IOException {
        SpdyConnectionAprSocket spdy = new SpdyConnectionAprSocket(this.ctx);
        AprSocket ch = this.con.socket(host, port, this.ctx.tls);
        spdy.setSocket(ch);
        ch.connect();
        ch.setHandler((AprSocketContext.BlockingPollHandler)new SpdySocketHandler(spdy));
        int rc = spdy.processInput();
        if (rc == -1) {
            ch.close();
            throw new IOException("Error connecting");
        }
        return spdy;
    }

    @Override
    public void onAccept(Object socket) {
        this.onAcceptLong((Long)socket);
    }

    public void onAcceptLong(long socket) {
        SpdyConnectionAprSocket spdy = new SpdyConnectionAprSocket(this.ctx);
        AprSocket s = this.con.socket(socket);
        spdy.setSocket(s);
        SpdySocketHandler handler = new SpdySocketHandler(spdy);
        s.setHandler((AprSocketContext.BlockingPollHandler)handler);
        handler.process(s, true, true, false);
    }

    public AprSocketContext getAprContext() {
        return this.con;
    }

    @Override
    public void listen(int port, String cert, String key) throws IOException {
        this.con = new AprSocketContext(){

            protected void onSocket(AprSocket s) {
                SpdyConnectionAprSocket spdy = new SpdyConnectionAprSocket(NetSupportOpenSSL.this.ctx);
                spdy.setSocket(s);
                SpdySocketHandler handler = new SpdySocketHandler(spdy);
                s.setHandler((AprSocketContext.BlockingPollHandler)handler);
            }
        };
        this.con.setNpn(SpdyContext.SPDY_NPN_OUT);
        this.con.setKeys(cert, key);
        this.con.listen(port);
    }

    @Override
    public void stop() throws IOException {
        this.con.stop();
    }

    private static class SpdyConnectionAprSocket
    extends SpdyConnection {
        private AprSocket socket;

        public SpdyConnectionAprSocket(SpdyContext spdyContext) {
            super(spdyContext);
        }

        public void setSocket(AprSocket ch) {
            this.socket = ch;
        }

        @Override
        public void close() throws IOException {
            this.socket.close();
        }

        @Override
        public int write(byte[] data, int off, int len) throws IOException {
            if (this.socket == null) {
                return -1;
            }
            int sent = this.socket.write(data, off, len);
            if (sent < 0) {
                return -1;
            }
            return sent;
        }

        @Override
        public int read(byte[] data, int off, int len) throws IOException {
            if (this.socket == null) {
                return -1;
            }
            int rd = this.socket.read(data, off, len);
            if (rd == -70014) {
                return -1;
            }
            if (rd == -120001 || rd == -120003 || rd == -120002) {
                rd = 0;
            }
            if (rd < 0) {
                return -1;
            }
            return rd;
        }
    }

    private static class SpdySocketHandler
    implements AprSocketContext.NonBlockingPollHandler {
        private final SpdyConnection con;

        SpdySocketHandler(SpdyConnection con) {
            this.con = con;
        }

        public void closed(AprSocket ch) {
        }

        public void process(AprSocket ch, boolean in, boolean out, boolean close) {
            try {
                int rc = this.con.processInput();
                if (rc == -1) {
                    ch.close();
                }
                this.con.drain();
            }
            catch (IOException e) {
                e.printStackTrace();
                ch.reset();
            }
        }

        public void connected(AprSocket ch) {
        }

        public void error(AprSocket ch, Throwable t) {
        }
    }
}

