/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.spdy;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.tomcat.spdy.SpdyConnection;
import org.apache.tomcat.spdy.SpdyFrame;

class CompressDeflater6
implements SpdyConnection.CompressSupport {
    public static final long DICT_ID = 3751956914L;
    private static final String SPDY_DICT_S = "optionsgetheadpostputdeletetraceacceptaccept-charsetaccept-encodingaccept-languageauthorizationexpectfromhostif-modified-sinceif-matchif-none-matchif-rangeif-unmodifiedsincemax-forwardsproxy-authorizationrangerefererteuser-agent100101200201202203204205206300301302303304305306307400401402403404405406407408409410411412413414415416417500501502503504505accept-rangesageetaglocationproxy-authenticatepublicretry-afterservervarywarningwww-authenticateallowcontent-basecontent-encodingcache-controlconnectiondatetrailertransfer-encodingupgradeviawarningcontent-languagecontent-lengthcontent-locationcontent-md5content-rangecontent-typeetagexpireslast-modifiedset-cookieMondayTuesdayWednesdayThursdayFridaySaturdaySundayJanFebMarAprMayJunJulAugSepOctNovDecchunkedtext/htmlimage/pngimage/jpgimage/gifapplication/xmlapplication/xhtmltext/plainpublicmax-agecharset=iso-8859-1utf-8gzipdeflateHTTP/1.1statusversionurl ";
    private static final byte[] SPDY_DICT = "optionsgetheadpostputdeletetraceacceptaccept-charsetaccept-encodingaccept-languageauthorizationexpectfromhostif-modified-sinceif-matchif-none-matchif-rangeif-unmodifiedsincemax-forwardsproxy-authorizationrangerefererteuser-agent100101200201202203204205206300301302303304305306307400401402403404405406407408409410411412413414415416417500501502503504505accept-rangesageetaglocationproxy-authenticatepublicretry-afterservervarywarningwww-authenticateallowcontent-basecontent-encodingcache-controlconnectiondatetrailertransfer-encodingupgradeviawarningcontent-languagecontent-lengthcontent-locationcontent-md5content-rangecontent-typeetagexpireslast-modifiedset-cookieMondayTuesdayWednesdayThursdayFridaySaturdaySundayJanFebMarAprMayJunJulAugSepOctNovDecchunkedtext/htmlimage/pngimage/jpgimage/gifapplication/xmlapplication/xhtmltext/plainpublicmax-agecharset=iso-8859-1utf-8gzipdeflateHTTP/1.1statusversionurl ".getBytes();
    private Deflater zipOut;
    private Inflater zipIn;
    private byte[] decompressBuffer;
    private int decMax;
    private byte[] compressBuffer;

    public static CompressDeflater6 get() {
        return new CompressDeflater6();
    }

    public void recycle() {
    }

    public void init() {
        if (this.zipOut != null) {
            return;
        }
        try {
            this.zipOut = new Deflater(-1, false);
            this.zipOut.setDictionary(SPDY_DICT);
            this.zipIn = new Inflater();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void compress(SpdyFrame frame, int start) throws IOException {
        this.init();
        if (this.compressBuffer == null) {
            this.compressBuffer = new byte[frame.data.length];
        }
        this.zipOut.setInput(frame.data, start, frame.endData - start - 1);
        int coff = start;
        this.zipOut.setLevel(-1);
        while (true) {
            int rd;
            if ((rd = this.zipOut.deflate(this.compressBuffer, coff, this.compressBuffer.length - coff)) == 0) {
                this.zipOut.setInput(frame.data, frame.endData - 1, 1);
                this.zipOut.setLevel(1);
                while (true) {
                    rd = this.zipOut.deflate(this.compressBuffer, coff, this.compressBuffer.length - coff);
                    coff += rd;
                    if (rd == 0) break;
                    byte[] b = new byte[this.compressBuffer.length * 2];
                    System.arraycopy(this.compressBuffer, 0, b, 0, coff);
                    this.compressBuffer = b;
                }
                break;
            }
            coff += rd;
        }
        this.zipOut.setLevel(-1);
        byte[] tmp = frame.data;
        frame.data = this.compressBuffer;
        this.compressBuffer = tmp;
        frame.endData = coff;
    }

    @Override
    public synchronized void decompress(SpdyFrame frame, int start) throws IOException {
        this.init();
        if (this.decompressBuffer == null) {
            this.decompressBuffer = new byte[frame.data.length];
        }
        this.decMax = frame.endData;
        int off = start;
        this.zipIn.setInput(frame.data, start, this.decMax - start);
        while (true) {
            int rd;
            try {
                while ((rd = this.zipIn.inflate(this.decompressBuffer, off, this.decompressBuffer.length - off)) == 0 && this.zipIn.needsDictionary()) {
                    this.zipIn.setDictionary(SPDY_DICT);
                }
            }
            catch (DataFormatException e) {
                throw new IOException(e);
            }
            if (rd == 0 || rd == -1) break;
            byte[] b = new byte[this.decompressBuffer.length * 2];
            System.arraycopy(this.decompressBuffer, 0, b, 0, off += rd);
            this.decompressBuffer = b;
        }
        byte[] tmpBuf = this.decompressBuffer;
        this.decompressBuffer = frame.data;
        frame.data = tmpBuf;
        frame.off = start;
        frame.endData = off;
    }

    static {
        CompressDeflater6.SPDY_DICT[CompressDeflater6.SPDY_DICT.length - 1] = 0;
    }
}

