/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.spdy;

import java.io.IOException;
import java.net.Socket;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.spdy.SpdyProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.spdy.NetSupportSocket;
import org.apache.tomcat.spdy.SpdyConnection;
import org.apache.tomcat.spdy.SpdyContext;
import org.apache.tomcat.spdy.SpdyStream;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class SpdyProxyProtocol
extends AbstractProtocol<Socket> {
    private static final Log log = LogFactory.getLog(SpdyProxyProtocol.class);
    private final JIoEndpoint.Handler cHandler = new TomcatJioHandler();
    private SpdyContext spdyContext;
    private boolean compress = false;

    public SpdyProxyProtocol() {
        this.endpoint = new JIoEndpoint();
        ((JIoEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(-1);
        this.setTcpNoDelay(true);
    }

    protected Log getLog() {
        return log;
    }

    protected String getNamePrefix() {
        return "spdy2-jio";
    }

    protected String getProtocolName() {
        return "spdy2";
    }

    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    public void start() throws Exception {
        super.start();
        this.spdyContext = new SpdyContext();
        this.spdyContext.setTlsCompression(false, this.compress);
        this.spdyContext.setHandler(new SpdyContext.SpdyHandler(){

            @Override
            public void onStream(SpdyConnection con, SpdyStream ch) throws IOException {
                SpdyProcessor sp = new SpdyProcessor(con, SpdyProxyProtocol.this.endpoint);
                sp.setAdapter(SpdyProxyProtocol.this.getAdapter());
                sp.onSynStream(ch);
            }
        });
        this.spdyContext.setNetSupport(new NetSupportSocket());
        this.spdyContext.setExecutor(this.endpoint.getExecutor());
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public class TomcatJioHandler
    implements JIoEndpoint.Handler {
        public Object getGlobal() {
            return null;
        }

        public void recycle() {
        }

        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Socket> socket, SocketStatus status) {
            SpdyProxyProtocol.this.spdyContext.getNetSupport().onAccept(socket.getSocket());
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }

        public SSLImplementation getSslImplementation() {
            return null;
        }

        public void beforeHandshake(SocketWrapper<Socket> socket) {
        }
    }
}

