/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.spdy;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpUpgradeHandler;
import org.apache.coyote.AbstractProcessor;
import org.apache.coyote.ActionCode;
import org.apache.coyote.AsyncContextCallback;
import org.apache.coyote.Constants;
import org.apache.coyote.ErrorState;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.spdy.SpdyConnection;
import org.apache.tomcat.spdy.SpdyFrame;
import org.apache.tomcat.spdy.SpdyStream;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class SpdyProcessor<S>
extends AbstractProcessor<S>
implements Runnable {
    private static final Log log = LogFactory.getLog(SpdyProcessor.class);
    private final SpdyConnection spdy;
    private SpdyStream spdyStream;
    private final ByteChunk keyBuffer = new ByteChunk();
    private boolean finished;
    private SpdyFrame inFrame = null;
    private boolean outClosed = false;
    private boolean outCommit = false;
    private static final byte[] EMPTY = new byte[0];

    public SpdyProcessor(SpdyConnection spdy, AbstractEndpoint<S> endpoint) {
        super(endpoint);
        this.spdy = spdy;
        this.request.setInputBuffer((InputBuffer)new LiteInputBuffer());
        this.response.setOutputBuffer((OutputBuffer)new LiteOutputBuffer());
    }

    void onRequest() {
        Executor exec = this.spdy.getSpdyContext().getExecutor();
        exec.execute(this);
    }

    @Override
    public void run() {
        RequestInfo rp = this.request.getRequestProcessor();
        try {
            rp.setStage(3);
            this.getAdapter().service(this.request, this.response);
        }
        catch (InterruptedIOException e) {
            this.setErrorState(ErrorState.CLOSE_NOW, e);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            t.printStackTrace();
            this.response.setStatus(500);
            this.getAdapter().log(this.request, this.response, 0L);
            this.setErrorState(ErrorState.CLOSE_NOW, t);
        }
        if (!this.finished) {
            try {
                this.finish();
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
                this.setErrorState(ErrorState.CLOSE_NOW, t);
            }
        }
        if (this.getErrorState().isError()) {
            this.response.setStatus(500);
        }
        this.request.updateCounters();
        rp.setStage(6);
    }

    private void finish() {
        if (!this.response.isCommitted()) {
            this.response.action(ActionCode.COMMIT, (Object)this.response);
        }
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.response.action(ActionCode.CLOSE, null);
    }

    private void maybeCommit() {
        if (this.outCommit) {
            return;
        }
        if (!this.response.isCommitted()) {
            this.sendSynReply();
        }
    }

    public void action(ActionCode actionCode, Object param) {
        switch (actionCode) {
            case COMMIT: {
                this.maybeCommit();
                break;
            }
            case CLIENT_FLUSH: {
                this.maybeCommit();
                break;
            }
            case IS_ERROR: {
                ((AtomicBoolean)param).set(this.getErrorState().isError());
                break;
            }
            case DISABLE_SWALLOW_INPUT: {
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                break;
            }
            case CLOSE: {
                if (this.outClosed) {
                    return;
                }
                this.outClosed = true;
                this.maybeCommit();
                this.spdyStream.sendDataFrame(EMPTY, 0, 0, true);
                break;
            }
            case REQ_SSL_ATTRIBUTE: {
                break;
            }
            case REQ_HOST_ATTRIBUTE: {
                if (!this.request.remoteHost().isNull()) break;
                try {
                    this.request.remoteHost().setString(InetAddress.getByName(this.request.remoteAddr().toString()).getHostName());
                }
                catch (IOException iex) {}
                break;
            }
            case REQ_LOCALPORT_ATTRIBUTE: {
                String configured = (String)this.endpoint.getAttribute("proxyPort");
                int localPort = 0;
                localPort = configured != null ? Integer.parseInt(configured) : this.endpoint.getPort();
                this.request.setLocalPort(localPort);
                break;
            }
            case REQ_LOCAL_ADDR_ATTRIBUTE: {
                String localIp;
                InetAddress localAddress = this.endpoint.getAddress();
                String string = localIp = localAddress == null ? null : localAddress.getHostAddress();
                if (localIp == null) {
                    localIp = (String)this.endpoint.getAttribute("proxyIP");
                }
                if (localIp == null) {
                    localIp = "127.0.0.1";
                }
                this.request.localAddr().setString(localIp);
                break;
            }
            case REQ_HOST_ADDR_ATTRIBUTE: {
                String localH;
                InetAddress localAddress = this.endpoint.getAddress();
                String string = localH = localAddress == null ? null : localAddress.getCanonicalHostName();
                if (localH == null) {
                    localH = (String)this.endpoint.getAttribute("proxyName");
                }
                if (localH == null) {
                    localH = "localhost";
                }
                this.request.localAddr().setString(localH);
                break;
            }
            case REQ_SET_BODY_REPLAY: {
                break;
            }
            case ASYNC_START: {
                this.asyncStateMachine.asyncStart((AsyncContextCallback)param);
                break;
            }
            case ASYNC_DISPATCHED: {
                this.asyncStateMachine.asyncDispatched();
                break;
            }
            case ASYNC_TIMEOUT: {
                AtomicBoolean result = (AtomicBoolean)param;
                result.set(this.asyncStateMachine.asyncTimeout());
                break;
            }
            case ASYNC_RUN: {
                this.asyncStateMachine.asyncRun((Runnable)param);
                break;
            }
            case ASYNC_ERROR: {
                this.asyncStateMachine.asyncError();
                break;
            }
            case ASYNC_IS_STARTED: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncStarted());
                break;
            }
            case ASYNC_IS_DISPATCHING: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncDispatching());
                break;
            }
            case ASYNC_IS_ASYNC: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsync());
                break;
            }
            case ASYNC_IS_TIMINGOUT: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncTimingOut());
                break;
            }
            case ASYNC_IS_ERROR: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncError());
                break;
            }
            case CLOSE_NOW: {
                this.setErrorState(ErrorState.CLOSE_NOW, null);
                break;
            }
        }
    }

    protected void sendSynReply() {
        long contentLength;
        String contentLanguage;
        this.response.setCommitted(true);
        MimeHeaders headers = this.response.getMimeHeaders();
        String contentType = this.response.getContentType();
        if (contentType != null) {
            headers.setValue("Content-Type").setString(contentType);
        }
        if ((contentLanguage = this.response.getContentLanguage()) != null) {
            headers.setValue("Content-Language").setString(contentLanguage);
        }
        if ((contentLength = this.response.getContentLengthLong()) >= 0L) {
            headers.setValue("Content-Length").setLong(contentLength);
        }
        this.sendResponseHead();
    }

    private void sendResponseHead() {
        SpdyFrame rframe = this.spdy.getFrame(2);
        rframe.associated = 0;
        MimeHeaders headers = this.response.getMimeHeaders();
        for (int i = 0; i < headers.size(); ++i) {
            MessageBytes mb = headers.getName(i);
            mb.toBytes();
            ByteChunk bc = mb.getByteChunk();
            byte[] bb = bc.getBuffer();
            for (int j = bc.getStart(); j < bc.getEnd(); ++j) {
                bb[j] = (byte)Ascii.toLower((int)bb[j]);
            }
            rframe.headerName(bc.getBuffer(), bc.getStart(), bc.getLength());
            mb = headers.getValue(i);
            mb.toBytes();
            bc = mb.getByteChunk();
            rframe.headerValue(bc.getBuffer(), bc.getStart(), bc.getLength());
        }
        if (this.response.getStatus() == 0) {
            rframe.addHeader(SpdyFrame.STATUS, SpdyFrame.OK200);
        } else {
            String message = null;
            if (Constants.USE_CUSTOM_STATUS_MSG_IN_HEADER && HttpMessages.isSafeInHttpHeader((String)this.response.getMessage())) {
                message = this.response.getMessage();
            }
            if (message == null) {
                message = HttpMessages.getInstance((Locale)this.response.getLocale()).getMessage(this.response.getStatus());
            }
            if (message == null) {
                message = Integer.toString(this.response.getStatus());
            }
            String status = this.response.getStatus() + " " + message;
            byte[] statusB = status.getBytes();
            rframe.headerName(SpdyFrame.STATUS, 0, SpdyFrame.STATUS.length);
            rframe.headerValue(statusB, 0, statusB.length);
        }
        rframe.addHeader(SpdyFrame.VERSION, SpdyFrame.HTTP11);
        rframe.streamId = this.spdyStream.reqFrame.streamId;
        this.spdy.send(rframe, this.spdyStream);
        this.outCommit = true;
    }

    public boolean isComet() {
        return false;
    }

    public AbstractEndpoint.Handler.SocketState process(SocketWrapper<S> socket) throws IOException {
        throw new IOException("Unimplemented");
    }

    public AbstractEndpoint.Handler.SocketState event(SocketStatus status) throws IOException {
        System.err.println("EVENT: " + status);
        return null;
    }

    public AbstractEndpoint.Handler.SocketState asyncDispatch(SocketStatus status) {
        System.err.println("ASYNC DISPATCH: " + status);
        return null;
    }

    public boolean isUpgrade() {
        return false;
    }

    public ByteBuffer getLeftoverInput() {
        return null;
    }

    public AbstractEndpoint.Handler.SocketState upgradeDispatch(SocketStatus status) throws IOException {
        return null;
    }

    protected void registerForEvent(boolean read, boolean write) {
    }

    public void onSynStream(SpdyStream str) throws IOException {
        this.spdyStream = str;
        SpdyFrame frame = str.reqFrame;
        RequestInfo rp = this.request.getRequestProcessor();
        rp.setStage(2);
        MimeHeaders mimeHeaders = this.request.getMimeHeaders();
        mimeHeaders.setLimit(this.endpoint.getMaxHeaderCount());
        for (int i = 0; i < frame.nvCount; ++i) {
            int nameLen = frame.read16();
            if (nameLen > frame.remaining()) {
                throw new IOException("Name too long");
            }
            this.keyBuffer.setBytes(frame.data, frame.off, nameLen);
            if (this.keyBuffer.equals("method")) {
                frame.advance(nameLen);
                int valueLen = frame.read16();
                if (valueLen > frame.remaining()) {
                    throw new IOException("Name too long");
                }
                this.request.method().setBytes(frame.data, frame.off, valueLen);
                frame.advance(valueLen);
                continue;
            }
            if (this.keyBuffer.equals("url")) {
                frame.advance(nameLen);
                int valueLen = frame.read16();
                if (valueLen > frame.remaining()) {
                    throw new IOException("Name too long");
                }
                int questionPos = -1;
                int end = frame.off + valueLen;
                for (int k = frame.off; k < end; ++k) {
                    if (frame.data[k] != 63) continue;
                    questionPos = k;
                    break;
                }
                if (questionPos >= 0) {
                    this.request.queryString().setBytes(frame.data, questionPos + 1, end - questionPos - 1);
                    this.request.requestURI().setBytes(frame.data, frame.off, questionPos - frame.off);
                } else {
                    this.request.requestURI().setBytes(frame.data, frame.off, valueLen);
                }
                frame.advance(valueLen);
                continue;
            }
            if (this.keyBuffer.equals("version")) {
                frame.advance(nameLen);
                int valueLen = frame.read16();
                if (valueLen > frame.remaining()) {
                    throw new IOException("Name too long");
                }
                frame.advance(valueLen);
                continue;
            }
            MessageBytes value = mimeHeaders.addValue(frame.data, frame.off, nameLen);
            frame.advance(nameLen);
            int valueLen = frame.read16();
            if (valueLen > frame.remaining()) {
                throw new IOException("Name too long");
            }
            value.setBytes(frame.data, frame.off, valueLen);
            frame.advance(valueLen);
        }
        this.onRequest();
    }

    public void recycle(boolean socketClosing) {
    }

    public void setSslSupport(SSLSupport sslSupport) {
    }

    public HttpUpgradeHandler getHttpUpgradeHandler() {
        return null;
    }

    protected Log getLog() {
        return log;
    }

    final class LiteOutputBuffer
    implements OutputBuffer {
        long byteCount;

        LiteOutputBuffer() {
        }

        public int doWrite(ByteChunk chunk, Response response) throws IOException {
            if (!response.isCommitted()) {
                response.action(ActionCode.COMMIT, null);
            }
            SpdyProcessor.this.spdyStream.sendDataFrame(chunk.getBuffer(), chunk.getStart(), chunk.getLength(), false);
            this.byteCount += (long)chunk.getLength();
            return chunk.getLength();
        }

        public long getBytesWritten() {
            return this.byteCount;
        }
    }

    class LiteInputBuffer
    implements InputBuffer {
        LiteInputBuffer() {
        }

        public int doRead(ByteChunk bchunk, Request request) throws IOException {
            if (SpdyProcessor.this.inFrame == null) {
                SpdyProcessor.this.inFrame = SpdyProcessor.this.spdyStream.getDataFrame(SpdyProcessor.this.endpoint.getSoTimeout());
            }
            if (SpdyProcessor.this.inFrame == null) {
                return -1;
            }
            if (SpdyProcessor.this.inFrame.remaining() == 0 && SpdyProcessor.this.inFrame.isHalfClose()) {
                return -1;
            }
            int rd = Math.min(SpdyProcessor.this.inFrame.remaining(), bchunk.getBytes().length);
            System.arraycopy(((SpdyProcessor)SpdyProcessor.this).inFrame.data, ((SpdyProcessor)SpdyProcessor.this).inFrame.off, bchunk.getBytes(), bchunk.getStart(), rd);
            SpdyProcessor.this.inFrame.advance(rd);
            if (SpdyProcessor.this.inFrame.remaining() == 0 && !SpdyProcessor.this.inFrame.isHalfClose()) {
                SpdyProcessor.this.inFrame = null;
            }
            bchunk.setEnd(bchunk.getEnd() + rd);
            return rd;
        }
    }
}

