/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.spdy;

import java.io.IOException;
import org.apache.coyote.Adapter;
import org.apache.coyote.http11.NpnHandler;
import org.apache.coyote.spdy.SpdyProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.SSLExt;
import org.apache.tomcat.spdy.NetSupportOpenSSL;
import org.apache.tomcat.spdy.SpdyConnection;
import org.apache.tomcat.spdy.SpdyContext;
import org.apache.tomcat.spdy.SpdyStream;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class SpdyAprNpnHandler
implements NpnHandler<Long> {
    private static final Log log = LogFactory.getLog(AprEndpoint.class);
    private SpdyContext spdyContext;

    public void init(final AbstractEndpoint<Long> ep, long sslContext, final Adapter adapter) {
        this.spdyContext = new SpdyContext();
        if (sslContext == 0L) {
            this.spdyContext.setTlsCompression(false, false);
            return;
        }
        if (0 != SSLExt.setNPN((long)sslContext, (byte[])SpdyContext.SPDY_NPN_OUT)) {
            log.warn((Object)"SPDY/NPN not supported");
        }
        this.spdyContext.setNetSupport(new NetSupportOpenSSL());
        this.spdyContext.setExecutor(ep.getExecutor());
        this.spdyContext.setHandler(new SpdyContext.SpdyHandler(){

            @Override
            public void onStream(SpdyConnection con, SpdyStream ch) throws IOException {
                SpdyProcessor sp = new SpdyProcessor(con, ep);
                sp.setAdapter(adapter);
                sp.onSynStream(ch);
            }
        });
    }

    public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Long> socketWrapper, SocketStatus status) {
        long socket = (Long)socketWrapper.getSocket();
        if (!this.spdyContext.getNetSupport().isSpdy(socketWrapper.getSocket())) {
            return AbstractEndpoint.Handler.SocketState.OPEN;
        }
        ((NetSupportOpenSSL)this.spdyContext.getNetSupport()).onAcceptLong(socket);
        return AbstractEndpoint.Handler.SocketState.LONG;
    }

    public void onCreateEngine(Object socket) {
    }
}

