/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.flash.encoder;

import com.carbonfive.flash.Context;
import com.carbonfive.flash.InfiniteLoopException;
import com.carbonfive.flash.LoopFinder;
import com.carbonfive.flash.encoder.ActionScriptEncoder;
import com.carbonfive.flash.encoder.ArrayEncoder;
import com.carbonfive.flash.encoder.CachingEncoder;
import com.carbonfive.flash.encoder.CollectionEncoder;
import com.carbonfive.flash.encoder.DateEncoder;
import com.carbonfive.flash.encoder.JavaBeanEncoder;
import com.carbonfive.flash.encoder.MapEncoder;
import com.carbonfive.flash.encoder.NativeEncoder;
import com.carbonfive.flash.encoder.NullEncoder;
import com.carbonfive.flash.encoder.NumberEncoder;
import java.io.Serializable;
import java.sql.ResultSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EncoderFactory {
    private static final Log log = LogFactory.getLog((Class)(class$com$carbonfive$flash$encoder$EncoderFactory == null ? (class$com$carbonfive$flash$encoder$EncoderFactory = EncoderFactory.class$("com.carbonfive.flash.encoder.EncoderFactory")) : class$com$carbonfive$flash$encoder$EncoderFactory));
    private static EncoderFactory instance;
    private static final NativeEncoder nativeEncoder;
    private static final NumberEncoder numberEncoder;
    private static final DateEncoder dateEncoder;
    private static final ArrayEncoder arrayEncoder;
    private static final MapEncoder mapEncoder;
    private static final CollectionEncoder collectionEncoder;
    private static final JavaBeanEncoder javaBeanEncoder;
    private static final NullEncoder nullEncoder;
    static /* synthetic */ Class class$com$carbonfive$flash$encoder$EncoderFactory;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$Object;

    private EncoderFactory() {
    }

    public static synchronized EncoderFactory getInstance() {
        if (instance == null) {
            instance = new EncoderFactory();
        }
        return instance;
    }

    public ActionScriptEncoder getEncoder(Context ctx, Object decodedObject) {
        if (decodedObject == null) {
            return nullEncoder;
        }
        Class<?> clazz = decodedObject.getClass();
        LoopFinder loopFinder = ctx.getLoopFinder();
        loopFinder.add(clazz);
        if (loopFinder.isLoop()) {
            throw new InfiniteLoopException(loopFinder);
        }
        if (ctx.getFilter().doIgnoreClass(clazz)) {
            return nullEncoder;
        }
        boolean isNativeObject = EncoderFactory.isActionScriptNative(decodedObject);
        boolean isNumber = (class$java$lang$Number == null ? (class$java$lang$Number = EncoderFactory.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz);
        boolean isDate = (class$java$util$Date == null ? (class$java$util$Date = EncoderFactory.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(clazz);
        boolean isArray = clazz.isArray();
        boolean isCollection = (class$java$util$Collection == null ? (class$java$util$Collection = EncoderFactory.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz);
        boolean isMap = (class$java$util$Map == null ? (class$java$util$Map = EncoderFactory.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz);
        boolean isJavaBean = (class$java$io$Serializable == null ? (class$java$io$Serializable = EncoderFactory.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz);
        CachingEncoder encoder = null;
        if (isNativeObject) {
            encoder = new CachingEncoder(nativeEncoder);
        } else if (isNumber) {
            encoder = new CachingEncoder(numberEncoder);
        } else if (isDate) {
            encoder = new CachingEncoder(dateEncoder);
        } else if (isArray) {
            encoder = new CachingEncoder(arrayEncoder);
        } else if (isMap) {
            encoder = new CachingEncoder(mapEncoder);
        } else if (isCollection) {
            encoder = new CachingEncoder(collectionEncoder);
        } else if (isJavaBean) {
            encoder = new CachingEncoder(javaBeanEncoder);
        } else {
            if (!(decodedObject instanceof Serializable)) {
                log.warn((Object)("Cannot encode object: " + clazz.getName() + " - It must implement Serializable"));
            }
            encoder = new CachingEncoder(nativeEncoder);
        }
        return encoder;
    }

    public static boolean isActionScriptNative(Object obj) {
        if (obj == null) {
            return true;
        }
        if ((class$java$lang$Object == null ? (class$java$lang$Object = EncoderFactory.class$("java.lang.Object")) : class$java$lang$Object).equals(obj.getClass())) {
            return true;
        }
        if (obj instanceof Boolean) {
            return true;
        }
        if (obj instanceof String) {
            return true;
        }
        if (obj instanceof Character) {
            return true;
        }
        if (obj instanceof ResultSet) {
            return true;
        }
        if (EncoderFactory.instanceOf(obj.getClass(), "org.w3c.dom.Document")) {
            return true;
        }
        if (EncoderFactory.instanceOf(obj.getClass(), "flashgateway.io.ASXMLString")) {
            return true;
        }
        return EncoderFactory.instanceOf(obj.getClass(), "flashgateway.sql.PageableResultSet");
    }

    static boolean instanceOf(Class clazz, String className) {
        if (clazz == null) {
            return false;
        }
        if (className.equals(clazz.getName())) {
            return true;
        }
        if (clazz.getSuperclass() == null) {
            return false;
        }
        return EncoderFactory.instanceOf(clazz.getSuperclass(), className);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        nativeEncoder = new NativeEncoder();
        numberEncoder = new NumberEncoder();
        dateEncoder = new DateEncoder();
        arrayEncoder = new ArrayEncoder();
        mapEncoder = new MapEncoder();
        collectionEncoder = new CollectionEncoder();
        javaBeanEncoder = new JavaBeanEncoder();
        nullEncoder = new NullEncoder();
    }
}

