/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.parser;

import java.io.Serializable;
import org.w3c.css.sac.LexicalUnit;

public class LexicalUnitImpl
implements LexicalUnit,
Serializable {
    private short _type;
    private LexicalUnit _next;
    private LexicalUnit _prev;
    private float _floatVal;
    private String _dimension;
    private String _function;
    private LexicalUnit _params;
    private String _stringVal;

    protected LexicalUnitImpl(LexicalUnit previous, short type) {
        this._type = type;
        this._prev = previous;
        if (this._prev != null) {
            ((LexicalUnitImpl)this._prev)._next = this;
        }
    }

    protected LexicalUnitImpl(LexicalUnit previous, int value) {
        this(previous, 13);
        this._floatVal = value;
    }

    protected LexicalUnitImpl(LexicalUnit previous, short type, float value) {
        this(previous, type);
        this._floatVal = value;
    }

    protected LexicalUnitImpl(LexicalUnit previous, short type, String dimension, float value) {
        this(previous, type);
        this._dimension = dimension;
        this._floatVal = value;
    }

    protected LexicalUnitImpl(LexicalUnit previous, short type, String value) {
        this(previous, type);
        this._stringVal = value;
    }

    protected LexicalUnitImpl(LexicalUnit previous, short type, String name, LexicalUnit params) {
        this(previous, type);
        this._function = name;
        this._params = params;
    }

    public short getLexicalUnitType() {
        return this._type;
    }

    public LexicalUnit getNextLexicalUnit() {
        return this._next;
    }

    public LexicalUnit getPreviousLexicalUnit() {
        return this._prev;
    }

    public int getIntegerValue() {
        return (int)this._floatVal;
    }

    public float getFloatValue() {
        return this._floatVal;
    }

    public String getDimensionUnitText() {
        switch (this._type) {
            case 15: {
                return "em";
            }
            case 16: {
                return "ex";
            }
            case 17: {
                return "px";
            }
            case 18: {
                return "in";
            }
            case 19: {
                return "cm";
            }
            case 20: {
                return "mm";
            }
            case 21: {
                return "pt";
            }
            case 22: {
                return "pc";
            }
            case 23: {
                return "%";
            }
            case 28: {
                return "deg";
            }
            case 29: {
                return "grad";
            }
            case 30: {
                return "rad";
            }
            case 31: {
                return "ms";
            }
            case 32: {
                return "s";
            }
            case 33: {
                return "Hz";
            }
            case 34: {
                return "kHz";
            }
            case 42: {
                return this._dimension;
            }
        }
        return "";
    }

    public String getFunctionName() {
        return this._function;
    }

    public LexicalUnit getParameters() {
        return this._params;
    }

    public String getStringValue() {
        return this._stringVal;
    }

    public LexicalUnit getSubValues() {
        return this._params;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this._type) {
            case 0: {
                sb.append(",");
                break;
            }
            case 1: {
                sb.append("+");
                break;
            }
            case 2: {
                sb.append("-");
                break;
            }
            case 3: {
                sb.append("*");
                break;
            }
            case 4: {
                sb.append("/");
                break;
            }
            case 5: {
                sb.append("%");
                break;
            }
            case 6: {
                sb.append("^");
                break;
            }
            case 7: {
                sb.append("<");
                break;
            }
            case 8: {
                sb.append(">");
                break;
            }
            case 9: {
                sb.append("<=");
                break;
            }
            case 10: {
                sb.append(">=");
                break;
            }
            case 11: {
                sb.append("~");
                break;
            }
            case 12: {
                sb.append("inherit");
                break;
            }
            case 13: {
                sb.append(String.valueOf(this.getIntegerValue()));
                break;
            }
            case 14: {
                sb.append(this.trimFloat(this.getFloatValue()));
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: {
                sb.append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText());
                break;
            }
            case 24: {
                sb.append("url(").append(this.getStringValue()).append(")");
                break;
            }
            case 25: {
                sb.append("counter(");
                this.appendParams(sb, this._params);
                sb.append(")");
                break;
            }
            case 26: {
                sb.append("counters(");
                this.appendParams(sb, this._params);
                sb.append(")");
                break;
            }
            case 27: {
                sb.append("rgb(");
                this.appendParams(sb, this._params);
                sb.append(")");
                break;
            }
            case 35: {
                sb.append(this.getStringValue());
                break;
            }
            case 36: {
                sb.append("\"").append(this.getStringValue()).append("\"");
                break;
            }
            case 37: {
                sb.append("attr(");
                this.appendParams(sb, this._params);
                sb.append(")");
                break;
            }
            case 38: {
                sb.append("rect(");
                this.appendParams(sb, this._params);
                sb.append(")");
                break;
            }
            case 39: {
                sb.append(this.getStringValue());
                break;
            }
            case 40: {
                sb.append(this.getStringValue());
                break;
            }
            case 41: {
                sb.append(this.getFunctionName());
                this.appendParams(sb, this._params);
                sb.append(")");
            }
        }
        return sb.toString();
    }

    public String toDebugString() {
        StringBuffer sb = new StringBuffer();
        switch (this._type) {
            case 0: {
                sb.append("SAC_OPERATOR_COMMA");
                break;
            }
            case 1: {
                sb.append("SAC_OPERATOR_PLUS");
                break;
            }
            case 2: {
                sb.append("SAC_OPERATOR_MINUS");
                break;
            }
            case 3: {
                sb.append("SAC_OPERATOR_MULTIPLY");
                break;
            }
            case 4: {
                sb.append("SAC_OPERATOR_SLASH");
                break;
            }
            case 5: {
                sb.append("SAC_OPERATOR_MOD");
                break;
            }
            case 6: {
                sb.append("SAC_OPERATOR_EXP");
                break;
            }
            case 7: {
                sb.append("SAC_OPERATOR_LT");
                break;
            }
            case 8: {
                sb.append("SAC_OPERATOR_GT");
                break;
            }
            case 9: {
                sb.append("SAC_OPERATOR_LE");
                break;
            }
            case 10: {
                sb.append("SAC_OPERATOR_GE");
                break;
            }
            case 11: {
                sb.append("SAC_OPERATOR_TILDE");
                break;
            }
            case 12: {
                sb.append("SAC_INHERIT");
                break;
            }
            case 13: {
                sb.append("SAC_INTEGER(").append(String.valueOf(this.getIntegerValue())).append(")");
                break;
            }
            case 14: {
                sb.append("SAC_REAL(").append(this.trimFloat(this.getFloatValue())).append(")");
                break;
            }
            case 15: {
                sb.append("SAC_EM(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 16: {
                sb.append("SAC_EX(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 17: {
                sb.append("SAC_PIXEL(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 18: {
                sb.append("SAC_INCH(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 19: {
                sb.append("SAC_CENTIMETER(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 20: {
                sb.append("SAC_MILLIMETER(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 21: {
                sb.append("SAC_POINT(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 22: {
                sb.append("SAC_PICA(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 23: {
                sb.append("SAC_PERCENTAGE(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 28: {
                sb.append("SAC_DEGREE(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 29: {
                sb.append("SAC_GRADIAN(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 30: {
                sb.append("SAC_RADIAN(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 31: {
                sb.append("SAC_MILLISECOND(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 32: {
                sb.append("SAC_SECOND(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 33: {
                sb.append("SAC_HERTZ(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 34: {
                sb.append("SAC_KILOHERTZ(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 42: {
                sb.append("SAC_DIMENSION(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 24: {
                sb.append("SAC_URI(url(").append(this.getStringValue()).append("))");
                break;
            }
            case 25: {
                sb.append("SAC_COUNTER_FUNCTION(counter(");
                this.appendParams(sb, this._params);
                sb.append("))");
                break;
            }
            case 26: {
                sb.append("SAC_COUNTERS_FUNCTION(counters(");
                this.appendParams(sb, this._params);
                sb.append("))");
                break;
            }
            case 27: {
                sb.append("SAC_RGBCOLOR(rgb(");
                this.appendParams(sb, this._params);
                sb.append("))");
                break;
            }
            case 35: {
                sb.append("SAC_IDENT(").append(this.getStringValue()).append(")");
                break;
            }
            case 36: {
                sb.append("SAC_STRING_VALUE(\"").append(this.getStringValue()).append("\")");
                break;
            }
            case 37: {
                sb.append("SAC_ATTR(attr(");
                this.appendParams(sb, this._params);
                sb.append("))");
                break;
            }
            case 38: {
                sb.append("SAC_RECT_FUNCTION(rect(");
                this.appendParams(sb, this._params);
                sb.append("))");
                break;
            }
            case 39: {
                sb.append("SAC_UNICODERANGE(").append(this.getStringValue()).append(")");
                break;
            }
            case 40: {
                sb.append("SAC_SUB_EXPRESSION(").append(this.getStringValue()).append(")");
                break;
            }
            case 41: {
                sb.append("SAC_FUNCTION(").append(this.getFunctionName()).append("(");
                this.appendParams(sb, this._params);
                sb.append("))");
            }
        }
        return sb.toString();
    }

    private void appendParams(StringBuffer sb, LexicalUnit first) {
        LexicalUnit l = first;
        while (l != null) {
            sb.append(l.toString());
            l = l.getNextLexicalUnit();
        }
    }

    private String trimFloat(float f) {
        String s = String.valueOf(this.getFloatValue());
        return f - (float)((int)f) != 0.0f ? s : s.substring(0, s.length() - 2);
    }

    private static float value(char op, String s) {
        return (float)(op == '-' ? -1 : 1) * Float.valueOf(s).floatValue();
    }

    public static LexicalUnit createNumber(LexicalUnit prev, float f) {
        if (f > (float)((int)f)) {
            return new LexicalUnitImpl(prev, 14, f);
        }
        return new LexicalUnitImpl(prev, (int)f);
    }

    public static LexicalUnit createPercentage(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 23, f);
    }

    public static LexicalUnit createPixel(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 17, f);
    }

    public static LexicalUnit createCentimeter(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 19, f);
    }

    public static LexicalUnit createMillimeter(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 20, f);
    }

    public static LexicalUnit createInch(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 18, f);
    }

    public static LexicalUnit createPoint(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 21, f);
    }

    public static LexicalUnit createPica(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 22, f);
    }

    public static LexicalUnit createEm(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 15, f);
    }

    public static LexicalUnit createEx(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 16, f);
    }

    public static LexicalUnit createDegree(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 28, f);
    }

    public static LexicalUnit createRadian(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 30, f);
    }

    public static LexicalUnit createGradian(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 29, f);
    }

    public static LexicalUnit createMillisecond(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 31, f);
    }

    public static LexicalUnit createSecond(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 32, f);
    }

    public static LexicalUnit createHertz(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 33, f);
    }

    public static LexicalUnit createDimension(LexicalUnit prev, float f, String dim) {
        return new LexicalUnitImpl(prev, 42, dim, f);
    }

    public static LexicalUnit createKiloHertz(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 34, f);
    }

    public static LexicalUnit createCounter(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, 25, "counter", params);
    }

    public static LexicalUnit createCounters(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, 26, "counters", params);
    }

    public static LexicalUnit createAttr(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, 37, "attr", params);
    }

    public static LexicalUnit createRect(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, 38, "rect", params);
    }

    public static LexicalUnit createRgbColor(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, 27, "rgb", params);
    }

    public static LexicalUnit createFunction(LexicalUnit prev, String name, LexicalUnit params) {
        return new LexicalUnitImpl(prev, 41, name, params);
    }

    public static LexicalUnit createString(LexicalUnit prev, String value) {
        return new LexicalUnitImpl(prev, 36, value);
    }

    public static LexicalUnit createIdent(LexicalUnit prev, String value) {
        return new LexicalUnitImpl(prev, 35, value);
    }

    public static LexicalUnit createURI(LexicalUnit prev, String value) {
        return new LexicalUnitImpl(prev, 24, value);
    }

    public static LexicalUnit createComma(LexicalUnit prev) {
        return new LexicalUnitImpl(prev, 0);
    }
}

