/*
 * Decompiled with CFR 0.152.
 */
package railo.loader.util;

import java.io.File;
import java.io.FileFilter;

public final class ExtensionFilter
implements FileFilter {
    private final String[] extensions;
    private final boolean allowDir;
    private final boolean ignoreCase;

    public ExtensionFilter(String extension) {
        this(new String[]{extension}, false, true);
    }

    public ExtensionFilter(String extension, boolean allowDir) {
        this(new String[]{extension}, allowDir, true);
    }

    public ExtensionFilter(String[] extensions) {
        this(extensions, false, true);
    }

    public ExtensionFilter(String[] extensions, boolean allowDir) {
        this(extensions, allowDir, true);
    }

    public ExtensionFilter(String[] extensions, boolean allowDir, boolean ignoreCase) {
        int i = 0;
        while (i < extensions.length) {
            if (!extensions[i].startsWith(".")) {
                extensions[i] = "." + extensions[i];
            }
            if (ignoreCase) {
                extensions[i] = extensions[i].toLowerCase();
            }
            ++i;
        }
        this.extensions = extensions;
        this.allowDir = allowDir;
        this.ignoreCase = ignoreCase;
    }

    @Override
    public boolean accept(File res) {
        if (res.isDirectory()) {
            return this.allowDir;
        }
        if (res.exists()) {
            String name = this.ignoreCase ? res.getName().toLowerCase() : res.getName();
            int i = 0;
            while (i < this.extensions.length) {
                if (name.endsWith(this.extensions[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String[] getExtensions() {
        return this.extensions;
    }
}

