/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.util.Library;

public class BorderStyle
extends Dictionary {
    private static final float[] DEFAULT_DASH_ARRAY = new float[]{3.0f};
    public static final Color DARKEST = Color.black;
    public static final Color DARK = new Color(-10461088);
    public static final Color LIGHT = new Color(-7303024);
    public static final Color LIGHTEST = new Color(-1710619);
    public static final String BORDER_STYLE_SOLID = "S";
    public static final String BORDER_STYLE_DASHED = "D";
    public static final String BORDER_STYLE_BEVELED = "B";
    public static final String BORDER_STYLE_INSET = "I";
    public static final String BORDER_STYLE_UNDERLINE = "U";
    private float strokeWidth = 1.0f;
    private String borderStyle = "S";
    private float[] dashArray = DEFAULT_DASH_ARRAY;

    public BorderStyle(Library library, Hashtable hashtable) {
        super(library, hashtable);
        Vector vector;
        Object object;
        Number number = (Number)this.getObject("W");
        if (number != null) {
            this.strokeWidth = number.floatValue();
        }
        if ((object = this.getObject(BORDER_STYLE_SOLID)) != null) {
            this.borderStyle = object.toString();
        }
        if ((vector = (Vector)this.getObject(BORDER_STYLE_DASHED)) != null) {
            int n = vector.size();
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                Number number2 = (Number)vector.get(i);
                fArray[i] = number2.floatValue();
            }
            this.dashArray = fArray;
        }
    }

    public BorderStyle() {
        super(null, null);
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(float f) {
        this.strokeWidth = f;
    }

    public void setBorderStyle(String string) {
        this.borderStyle = string;
    }

    public boolean isStyleSolid() {
        return this.borderStyle.equals(BORDER_STYLE_SOLID);
    }

    public boolean isStyleDashed() {
        return this.borderStyle.equals(BORDER_STYLE_DASHED);
    }

    public boolean isStyleBeveled() {
        return this.borderStyle.equals(BORDER_STYLE_BEVELED);
    }

    public boolean isStyleInset() {
        return this.borderStyle.equals(BORDER_STYLE_INSET);
    }

    public boolean isStyleUnderline() {
        return this.borderStyle.equals(BORDER_STYLE_UNDERLINE);
    }

    public void setDashArray(float[] fArray) {
        this.dashArray = fArray;
    }

    public float[] getDashArray() {
        return this.dashArray;
    }
}

