/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableByteArrayInputStream;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Parser;

public class ObjectStream
extends Stream {
    private static final Logger logger = Logger.getLogger(Form.class.toString());
    private boolean m_bInited;
    private SeekableInput m_DecodedStream;
    private int[] m_iaObjectNumbers;
    private long[] m_laObjectOffset;

    public ObjectStream(Library library, Hashtable hashtable, SeekableInputConstrainedWrapper seekableInputConstrainedWrapper) {
        super(library, hashtable, seekableInputConstrainedWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        if (this.m_bInited) {
            return;
        }
        this.m_bInited = true;
        int n = this.library.getInt(this.entries, "N");
        long l = this.library.getLong(this.entries, "First");
        byte[] byArray = this.getBytes();
        this.m_DecodedStream = new SeekableByteArrayInputStream(byArray);
        this.m_DecodedStream.beginThreadAccess();
        this.m_iaObjectNumbers = new int[n];
        this.m_laObjectOffset = new long[n];
        try {
            Parser parser = new Parser(this.m_DecodedStream);
            for (int i = 0; i < n; ++i) {
                this.m_iaObjectNumbers[i] = parser.getIntSurroundedByWhitespace();
                this.m_laObjectOffset[i] = parser.getLongSurroundedByWhitespace() + l;
            }
        }
        finally {
            this.m_DecodedStream.endThreadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadObject(Library library, int n) {
        this.init();
        if (this.m_iaObjectNumbers == null || this.m_laObjectOffset == null || this.m_iaObjectNumbers.length != this.m_laObjectOffset.length || n < 0 || n >= this.m_iaObjectNumbers.length) {
            return false;
        }
        boolean bl = false;
        try {
            int n2 = this.m_iaObjectNumbers[n];
            long l = this.m_laObjectOffset[n];
            this.m_DecodedStream.beginThreadAccess();
            this.m_DecodedStream.seekAbsolute(l);
            Parser parser = new Parser(this.m_DecodedStream, 1);
            Object object = parser.getObject(library);
            if (object == null) {
                Reference reference = new Reference(n2, 0);
                object = parser.addPObject(library, reference);
            } else if (!(object instanceof PObject)) {
                Reference reference = new Reference(n2, 0);
                library.addObject(object, reference);
            }
            bl = object != null;
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Error loading PDF object.", exception);
        }
        finally {
            this.m_DecodedStream.endThreadAccess();
        }
        return bl;
    }

    public void dispose(boolean bl) {
        this.m_bInited = false;
        this.m_DecodedStream = null;
        this.m_iaObjectNumbers = null;
        this.m_laObjectOffset = null;
        super.dispose(bl);
    }
}

