/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import oracle.xml.jdwp.XSLJDWPEvent;
import oracle.xml.jdwp.XSLJDWPEventManager;
import oracle.xml.jdwp.XSLJDWPEventRequestGroup;
import oracle.xml.jdwp.XSLJDWPEventRequestManager;
import oracle.xml.jdwp.XSLJDWPUtil;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;

public class XSLJDWPEventValue {
    byte eventKind = (byte)-1;
    String baseURL;
    int line;
    long codeIndexBegin;
    long codeIndexEnd;
    long codeIndex;
    String name;
    String ins;
    XSLStylesheet xss;
    XSLTContext context;
    XSLJDWPEventManager manager;
    XSLJDWPEvent event;

    public XSLJDWPEventValue(byte by, XSLStylesheet xSLStylesheet) {
        this.eventKind = by;
        this.init(xSLStylesheet);
        boolean bl = this.reportASAP(by);
        if (bl) {
            this.manager.addEventValue(this);
        }
    }

    public XSLJDWPEventValue(XSLJDWPEvent xSLJDWPEvent, XSLStylesheet xSLStylesheet) {
        if (xSLJDWPEvent == null) {
            return;
        }
        this.eventKind = xSLJDWPEvent.getEventKind();
        this.init(xSLStylesheet);
        this.event = xSLJDWPEvent;
        this.manager.addEventValue(this);
    }

    XSLJDWPEvent getEvent() {
        return this.event;
    }

    public XSLJDWPEventValue(XSLStylesheet xSLStylesheet) {
        this.init(xSLStylesheet);
    }

    public byte getSuspendPolicy() {
        XSLJDWPEventRequestManager xSLJDWPEventRequestManager = this.xss.getJDWPDebugger().getEventRequestManager();
        for (int i = 0; i < xSLJDWPEventRequestManager.size(); ++i) {
            XSLJDWPEventRequestGroup xSLJDWPEventRequestGroup = (XSLJDWPEventRequestGroup)xSLJDWPEventRequestManager.get(i);
            if (xSLJDWPEventRequestGroup.getEventKind() != this.eventKind) continue;
            return xSLJDWPEventRequestGroup.getSuspendPolicy();
        }
        return 0;
    }

    private void init(XSLStylesheet xSLStylesheet) {
        this.xss = xSLStylesheet;
        this.manager = xSLStylesheet.getEventManager();
    }

    public void add() {
        XSLJDWPUtil.printTrace(this.xss.getXSLDebugProp(), this.line + ": " + this.codeIndex + ":" + this.codeIndexBegin + ":" + this.codeIndexEnd);
        XSLJDWPUtil.printTrace(this.xss.getXSLDebugProp(), "ins : " + this.ins);
        XSLJDWPUtil.printTrace(this.xss.getXSLDebugProp(), "name: " + this.name);
        XSLJDWPUtil.printTrace(this.xss.getXSLDebugProp(), "url : " + this.baseURL);
        this.name = this.name.intern();
        if (this.name == "*|/" || this.name == "node()" || this.name == "text()|@*") {
            return;
        }
        this.manager.addEventValue(this);
    }

    XSLStylesheet getXSLStylesheet() {
        return this.xss;
    }

    public void setEventKind(byte by) {
        this.eventKind = by;
    }

    byte getEventKind() {
        return this.eventKind;
    }

    public void setInstructionName(String string) {
        this.ins = string;
    }

    String getInstructionName() {
        return this.ins;
    }

    public void setBaseURL(String string) {
        this.baseURL = string;
    }

    String getBaseURL() {
        return this.baseURL;
    }

    public void setName(String string) {
        this.name = string;
    }

    String getName() {
        return this.name;
    }

    int getLineNumber() {
        return this.line;
    }

    public void setLineNumber(int n) {
        this.line = n;
    }

    long getCodeIndexBegin() {
        return this.codeIndexBegin;
    }

    public void setCodeIndexBegin(long l) {
        this.codeIndexBegin = l;
        this.setCodeIndex(l);
    }

    long getCodeIndexEnd() {
        return this.codeIndexEnd;
    }

    public void setCodeIndexEnd(long l) {
        this.codeIndexEnd = l;
        this.setCodeIndex(l);
    }

    private void setCodeIndex(long l) {
        this.codeIndex = l;
    }

    long getCodeIndex() {
        return this.codeIndex;
    }

    public void setXSLTContext(XSLTContext xSLTContext) {
        this.context = xSLTContext;
    }

    XSLTContext getXSLTContext() {
        return this.context;
    }

    private boolean reportASAP(byte by) {
        switch (by) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 90: 
            case 99: {
                return true;
            }
            case 20: 
            case 21: 
            case 40: 
            case 41: {
                return false;
            }
        }
        return false;
    }
}

