/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public abstract class Datum
implements Serializable {
    private byte[] data;
    static final long serialVersionUID = 4645732484621936751L;

    public Datum() {
    }

    public Datum(byte[] byArray) {
        this.data = byArray;
    }

    public InputStream asciiStreamValue() throws SQLException {
        throw new SQLException("Conversion to ascii stream failed");
    }

    public BigDecimal bigDecimalValue() throws SQLException {
        throw new SQLException("Conversion to BigDecimal failed");
    }

    public InputStream binaryStreamValue() throws SQLException {
        throw new SQLException("Conversion to binary stream failed");
    }

    public boolean booleanValue() throws SQLException {
        throw new SQLException("Conversion to boolean failed");
    }

    public byte byteValue() throws SQLException {
        throw new SQLException("Conversion to byte failed");
    }

    public Reader characterStreamValue() throws SQLException {
        throw new SQLException("Conversion to character stream failed");
    }

    protected static int compareBytes(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        int n2 = byArray2.length;
        int n3 = 0;
        int n4 = Math.min(n, n2);
        int n5 = 0;
        int n6 = 0;
        while (n3 < n4) {
            n5 = byArray[n3] & 0xFF;
            n6 = byArray2[n3] & 0xFF;
            if (n5 != n6) {
                if (n5 < n6) {
                    return -1;
                }
                return 1;
            }
            ++n3;
        }
        if (n == n2) {
            return 0;
        }
        if (n > n2) {
            return 1;
        }
        return -1;
    }

    public Date dateValue() throws SQLException {
        throw new SQLException("Conversion to Date failed");
    }

    public double doubleValue() throws SQLException {
        throw new SQLException("Conversion to double failed");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Datum)) {
            return false;
        }
        if (this.getClass() == object.getClass()) {
            Datum datum = (Datum)object;
            if (this.data.length != datum.data.length) {
                return false;
            }
            int n = 0;
            while (n < this.data.length) {
                if (this.data[n] != datum.data[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public float floatValue() throws SQLException {
        throw new SQLException("Conversion to float failed");
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.data.length];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        return byArray;
    }

    public long getLength() {
        if (this.data == null) {
            return 0L;
        }
        return this.data.length;
    }

    public InputStream getStream() {
        return new ByteArrayInputStream(this.data);
    }

    public int intValue() throws SQLException {
        throw new SQLException("Conversion to integer failed");
    }

    public abstract boolean isConvertibleTo(Class var1);

    public long longValue() throws SQLException {
        throw new SQLException("Conversion to long failed");
    }

    public abstract Object makeJdbcArray(int var1);

    public void setBytes(byte[] byArray) {
        int n = byArray.length;
        this.data = new byte[n];
        System.arraycopy(byArray, 0, this.data, 0, n);
    }

    public void setShareBytes(byte[] byArray) {
        this.data = byArray;
    }

    public byte[] shareBytes() {
        return this.data;
    }

    public String stringValue() throws SQLException {
        throw new SQLException("Conversion to String failed");
    }

    public Time timeValue() throws SQLException {
        throw new SQLException("Conversion to Time failed");
    }

    public Timestamp timestampValue() throws SQLException {
        throw new SQLException("Conversion to Timestamp failed");
    }

    public abstract Object toJdbc() throws SQLException;
}

