/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.Datum;

public class OracleTypeFLOAT
extends OracleType
implements Serializable {
    static final long serialVersionUID = 4088841548269771109L;
    int m_precision;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051228";

    protected OracleTypeFLOAT() {
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        return OracleTypeNUMBER.toNUMBER(object, oracleConnection);
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l, int n) throws SQLException {
        return OracleTypeNUMBER.toNUMBERArray(object, oracleConnection, l, n);
    }

    public int getTypeCode() {
        return 6;
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        this.null_offset = streamInfo.null_offset++;
        this.lds_offset = streamInfo.lds_offset++;
        this.m_precision = streamInfo.readUnsignedByte();
    }

    public int getScale() {
        return -127;
    }

    public int getPrecision() {
        return this.m_precision;
    }

    public int getSizeLDS(byte[] byArray) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size(byArray, 12);
            this.align_for_lds = Util.FDO_get_align(byArray, 12);
        }
        return this.size_for_lds;
    }

    public int getAlignLDS(byte[] byArray) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size(byArray, 12);
            this.align_for_lds = Util.FDO_get_align(byArray, 12);
        }
        return this.align_for_lds;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        return OracleTypeNUMBER.numericUnpickle80rec(this.lds_offset, this.null_offset, unpickleContext, n, n2, map);
    }

    protected static Object unpickle80_nativeArray(UnpickleContext unpickleContext, long l, int n, int n2, int n3) throws SQLException {
        return OracleTypeNUMBER.unpickle80_nativeArray(unpickleContext, l, n, n2, n3);
    }

    protected static Object unpickle81_nativeArray(PickleContext pickleContext, long l, int n, int n2) throws SQLException {
        return OracleTypeNUMBER.unpickle81_nativeArray(pickleContext, l, n, n2);
    }

    protected Object toObject(byte[] byArray, int n, Map map) throws SQLException {
        return OracleTypeNUMBER.toNumericObject(byArray, n, map);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.m_precision);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.m_precision = objectInputStream.readInt();
    }
}

