/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.InputStream;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.exception.PdfException;
import org.jpedal.utils.LogWriter;

public class DeviceCMYKColorSpace
extends GenericColorSpace {
    private float lastC = -1.0f;
    private float lastM = -1.0f;
    private float lastY = -1.0f;
    private float lastK = -1.0f;
    private static ColorSpace CMYK = null;

    private void initColorspace() {
        try {
            InputStream inputStream;
            String string = System.getProperty("org.jpedal.profile");
            if (string == null) {
                inputStream = this.getClass().getResourceAsStream("/org/jpedal/res/cmm/cmyk.icm");
            } else {
                try {
                    inputStream = new FileInputStream(string);
                }
                catch (Exception exception) {
                    throw new PdfException("PdfException attempting to use user profile " + string + " Message=" + exception);
                }
            }
            ICC_Profile iCC_Profile = ICC_Profile.getInstance(inputStream);
            CMYK = new ICC_ColorSpace(iCC_Profile);
            inputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception);
        }
    }

    public DeviceCMYKColorSpace() {
        this.componentCount = 4;
        if (CMYK == null) {
            this.initColorspace();
        }
        this.cs = CMYK;
        this.value = 1498837125;
    }

    public final void setColor(String[] stringArray, int n) {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = Float.parseFloat(stringArray[i]);
        }
        this.setColor(fArray, n);
    }

    public final void setColor(float[] fArray, int n) {
        boolean bl = true;
        this.c = 1.0f;
        this.y = 1.0f;
        this.m = 1.0f;
        this.k = 1.0f;
        if (n > 3) {
            this.c = fArray[0];
            this.m = fArray[1];
            this.y = fArray[2];
            this.k = fArray[3];
        } else {
            if (n > 1) {
                this.c = fArray[0];
            }
            if (n > 2) {
                this.m = fArray[1];
            }
            if (n > 2) {
                this.y = fArray[2];
            }
            if (n > 3) {
                this.k = fArray[3];
            }
        }
        if (this.lastC != this.c || this.lastM != this.m || this.lastY != this.y || this.lastK != this.k) {
            this.rawValues = new float[4];
            this.rawValues[0] = this.c;
            this.rawValues[1] = this.m;
            this.rawValues[2] = this.y;
            this.rawValues[3] = this.k;
            if (!bl) {
                float f;
                float f2;
                float f3 = this.c + this.k;
                if (f3 > 1.0f) {
                    f3 = 1.0f;
                }
                if ((f2 = this.m + this.k) > 1.0f) {
                    f2 = 1.0f;
                }
                if ((f = this.y + this.k) > 1.0f) {
                    f = 1.0f;
                }
                this.currentColor = new PdfColor((int)(255.0f * (1.0f - f3)), (int)(255.0f * (1.0f - f2)), (int)(255.0f * (1.0f - f)));
            } else if (this.c == 0.0f && this.y == 0.0f && this.m == 0.0f && this.k == 0.0f) {
                this.currentColor = new PdfColor(1.0f, 1.0f, 1.0f);
            } else {
                if ((double)this.c > 0.99) {
                    this.c = 1.0f;
                } else if ((double)this.c < 0.01) {
                    this.c = 0.0f;
                }
                if ((double)this.m > 0.99) {
                    this.m = 1.0f;
                } else if ((double)this.m < 0.01) {
                    this.m = 0.0f;
                }
                if ((double)this.y > 0.99) {
                    this.y = 1.0f;
                } else if ((double)this.y < 0.01) {
                    this.y = 0.0f;
                }
                if ((double)this.k > 0.99) {
                    this.k = 1.0f;
                } else if ((double)this.k < 0.01) {
                    this.k = 0.0f;
                }
                float[] fArray2 = new float[]{this.c, this.m, this.y, this.k};
                float[] fArray3 = CMYK.toRGB(fArray2);
                for (int i = 0; i < 3; ++i) {
                    if ((double)fArray3[i] > 0.99) {
                        fArray3[i] = 1.0f;
                        continue;
                    }
                    if (!((double)fArray3[i] < 0.01)) continue;
                    fArray3[i] = 0.0f;
                }
                this.currentColor = new PdfColor(fArray3[0], fArray3[1], fArray3[2]);
            }
            this.lastC = this.c;
            this.lastM = this.m;
            this.lastY = this.y;
            this.lastK = this.k;
        }
    }

    public final BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4) {
        return this.nonRGBJPEGToRGBImage(byArray, n, n2, fArray, n3, n4);
    }

    public final byte[] convertIndexToRGB(byte[] byArray) {
        return this.convert4Index(byArray);
    }
}

