/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.poifs.filesystem.BATManaged;
import org.apache.poi.poifs.storage.BATBlock;
import org.apache.poi.poifs.storage.BlockWritable;
import org.apache.poi.poifs.storage.HeaderBlockWriter;
import org.apache.poi.util.IntList;

public class BlockAllocationTableWriter
implements BlockWritable,
BATManaged {
    private IntList _entries = new IntList();
    private BATBlock[] _blocks = new BATBlock[0];
    private int _start_block = -2;

    public int createBlocks() {
        int n;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            n = BATBlock.calculateStorageRequirements(n3 + n2 + this._entries.size());
            int n4 = HeaderBlockWriter.calculateXBATStorageRequirements(n);
            if (n3 == n && n2 == n4) break;
            n3 = n;
            n2 = n4;
        }
        n = this.allocateSpace(n3);
        this.allocateSpace(n2);
        this.simpleCreateBlocks();
        return n;
    }

    public int allocateSpace(int n) {
        int n2 = this._entries.size();
        if (n > 0) {
            int n3 = n - 1;
            int n4 = n2 + 1;
            for (int i = 0; i < n3; ++i) {
                this._entries.add(n4++);
            }
            this._entries.add(-2);
        }
        return n2;
    }

    public int getStartBlock() {
        return this._start_block;
    }

    void simpleCreateBlocks() {
        this._blocks = BATBlock.createBATBlocks(this._entries.toArray());
    }

    public void writeBlocks(OutputStream outputStream) throws IOException {
        for (int i = 0; i < this._blocks.length; ++i) {
            this._blocks[i].writeBlocks(outputStream);
        }
    }

    public int countBlocks() {
        return this._blocks.length;
    }

    public void setStartBlock(int n) {
        this._start_block = n;
    }
}

