/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.usermodel;

import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public class BorderCode
implements Cloneable {
    public static final int SIZE = 4;
    private short _info;
    private static final BitField _dptLineWidth = new BitField(255);
    private static final BitField _brcType = new BitField(65280);
    private short _info2;
    private static final BitField _ico = new BitField(255);
    private static final BitField _dptDpace = new BitField(7936);
    private static final BitField _fShadow = new BitField(8192);
    private static final BitField _fFrame = new BitField(16384);

    public BorderCode() {
    }

    public BorderCode(byte[] byArray, int n) {
        this._info = LittleEndian.getShort(byArray, n);
        this._info2 = LittleEndian.getShort(byArray, n + 2);
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putShort(byArray, n, this._info);
        LittleEndian.putShort(byArray, n + 2, this._info2);
    }

    public int toInt() {
        byte[] byArray = new byte[4];
        this.serialize(byArray, 0);
        return LittleEndian.getInt(byArray);
    }

    public boolean isEmpty() {
        return this._info == 0 && this._info2 == 0;
    }

    public boolean equals(Object object) {
        BorderCode borderCode = (BorderCode)object;
        return this._info == borderCode._info && this._info2 == borderCode._info2;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

