/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hwpf.model.CHPFormattedDiskPage;
import org.apache.poi.hwpf.model.CHPX;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.PropertyNode;
import org.apache.poi.hwpf.model.io.HWPFFileSystem;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.hwpf.sprm.SprmBuffer;
import org.apache.poi.util.LittleEndian;

public class CHPBinTable {
    ArrayList _textRuns = new ArrayList();

    public CHPBinTable(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        PlexOfCps plexOfCps = new PlexOfCps(byArray2, n, n2, 4);
        int n4 = plexOfCps.length();
        for (int i = 0; i < n4; ++i) {
            GenericPropertyNode genericPropertyNode = plexOfCps.getProperty(i);
            int n5 = LittleEndian.getInt(genericPropertyNode.getBytes());
            int n6 = 512 * n5;
            CHPFormattedDiskPage cHPFormattedDiskPage = new CHPFormattedDiskPage(byArray, n6, n3);
            int n7 = cHPFormattedDiskPage.size();
            for (int j = 0; j < n7; ++j) {
                this._textRuns.add(cHPFormattedDiskPage.getCHPX(j));
            }
        }
    }

    public void adjustForDelete(int n, int n2, int n3) {
        int n4;
        int n5 = this._textRuns.size();
        int n6 = n2 + n3;
        int n7 = n;
        CHPX cHPX = (CHPX)this._textRuns.get(n7);
        while (cHPX.getEnd() < n6) {
            cHPX = (CHPX)this._textRuns.get(++n7);
        }
        if (n == n7) {
            cHPX = (CHPX)this._textRuns.get(n7);
            cHPX.setEnd(cHPX.getEnd() - n6 + n2);
        } else {
            cHPX = (CHPX)this._textRuns.get(n);
            cHPX.setEnd(n2);
            for (n4 = n + 1; n4 < n7; ++n4) {
                cHPX = (CHPX)this._textRuns.get(n4);
                cHPX.setStart(n2);
                cHPX.setEnd(n2);
            }
            cHPX = (CHPX)this._textRuns.get(n7);
            cHPX.setEnd(cHPX.getEnd() - n6 + n2);
        }
        for (n4 = n7 + 1; n4 < n5; ++n4) {
            cHPX = (CHPX)this._textRuns.get(n4);
            cHPX.setStart(cHPX.getStart() - n3);
            cHPX.setEnd(cHPX.getEnd() - n3);
        }
    }

    public void insert(int n, int n2, SprmBuffer sprmBuffer) {
        CHPX cHPX = new CHPX(n2, n2, sprmBuffer);
        if (n == this._textRuns.size()) {
            this._textRuns.add(cHPX);
        } else {
            CHPX cHPX2 = (CHPX)this._textRuns.get(n);
            if (cHPX2.getStart() < n2) {
                CHPX cHPX3 = new CHPX(n2, cHPX2.getEnd(), cHPX2.getSprmBuf());
                cHPX2.setEnd(n2);
                this._textRuns.add(n + 1, cHPX);
                this._textRuns.add(n + 2, cHPX3);
            } else {
                this._textRuns.add(n, cHPX);
            }
        }
    }

    public void adjustForInsert(int n, int n2) {
        int n3 = this._textRuns.size();
        CHPX cHPX = (CHPX)this._textRuns.get(n);
        cHPX.setEnd(cHPX.getEnd() + n2);
        for (int i = n + 1; i < n3; ++i) {
            cHPX = (CHPX)this._textRuns.get(i);
            cHPX.setStart(cHPX.getStart() + n2);
            cHPX.setEnd(cHPX.getEnd() + n2);
        }
    }

    public List getTextRuns() {
        return this._textRuns;
    }

    public void writeTo(HWPFFileSystem hWPFFileSystem, int n) throws IOException {
        HWPFOutputStream hWPFOutputStream = hWPFFileSystem.getStream("WordDocument");
        HWPFOutputStream hWPFOutputStream2 = hWPFFileSystem.getStream("1Table");
        PlexOfCps plexOfCps = new PlexOfCps(4);
        int n2 = hWPFOutputStream.getOffset();
        int n3 = n2 % 512;
        if (n3 != 0) {
            byte[] byArray = new byte[512 - n3];
            hWPFOutputStream.write(byArray);
        }
        n2 = hWPFOutputStream.getOffset();
        int n4 = n2 / 512;
        int n5 = ((PropertyNode)this._textRuns.get(this._textRuns.size() - 1)).getEnd();
        n5 += n;
        ArrayList arrayList = this._textRuns;
        do {
            PropertyNode propertyNode = (PropertyNode)arrayList.get(0);
            int n6 = propertyNode.getStart() + n;
            CHPFormattedDiskPage cHPFormattedDiskPage = new CHPFormattedDiskPage();
            cHPFormattedDiskPage.fill(arrayList);
            byte[] byArray = cHPFormattedDiskPage.toByteArray(n);
            hWPFOutputStream.write(byArray);
            arrayList = cHPFormattedDiskPage.getOverflow();
            int n7 = n5;
            if (arrayList != null) {
                n7 = ((PropertyNode)arrayList.get(0)).getStart() + n;
            }
            byte[] byArray2 = new byte[4];
            LittleEndian.putInt(byArray2, n4++);
            plexOfCps.addProperty(new GenericPropertyNode(n6, n7, byArray2));
        } while (arrayList != null);
        hWPFOutputStream2.write(plexOfCps.toByteArray());
    }
}

