/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.demux.mpg;

import java.awt.Dimension;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.VideoFormat;
import net.sourceforge.jffmpeg.demux.mpg.MpegDemux;
import net.sourceforge.jffmpeg.demux.mpg.MpegTrack;

public class MpegVideoTrack
extends MpegTrack {
    private boolean parsedHeader = false;
    private Buffer header = new Buffer();
    private float[] frameRateTable = new float[]{0.0f, 23.976025f, 24.0f, 25.0f, 29.97003f, 30.0f, 50.0f, 59.94006f, 60.0f, 15.0f, 5.0f, 10.0f, 12.0f, 15.0f, 0.0f};

    public MpegVideoTrack(MpegDemux mpegDemux, int n) {
        super(mpegDemux, n);
    }

    public Format getFormat() {
        if (!this.parsedHeader) {
            try {
                this.parseHeader();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.format;
    }

    protected synchronized void parseHeader() throws IOException {
        long l = 0L;
        int n = 0;
        int n2 = 0;
        float f = 0.0f;
        while (!this.parsedHeader) {
            int n3;
            int n4 = this.demux.peekPacket(this.pos);
            if (n4 < 432) {
                this.parsedHeader = true;
                break;
            }
            if (n4 >= 448 && n4 <= 479 || n4 >= 480 && n4 <= 495 || n4 == 445) {
                l = this.pos;
                this.pos = this.demux.readDTSHeader(this.header, this.pos);
                continue;
            }
            int n5 = this.header.getLength() + 4;
            if (n4 == 435) {
                this.pos = this.demux.readPacket(this.header, this.trackId, this.pos);
                byte[] byArray = (byte[])this.header.getData();
                n = (byArray[n5] & 0xFF) << 4 | byArray[n5 + 1] >> 4 & 0xF;
                n2 = (byArray[n5 + 1] & 0xF) << 8 | byArray[n5 + 2] & 0xFF;
                n3 = byArray[n5 + 3] & 0xF;
                f = this.frameRateTable[n3];
                this.format = new VideoFormat("mpeg", new Dimension(n, n2), 10000, new byte[1].getClass(), f);
                continue;
            }
            if (n4 == 437) {
                this.pos = this.demux.readPacket(this.header, this.trackId, this.pos);
                byte[] byArray = (byte[])this.header.getData();
                n3 = byArray[n5] >> 4 & 0xF;
                if (n3 != 1) continue;
                this.format = new VideoFormat("mpeg", new Dimension(n |= (byArray[n5 + 1] & 1) << 12 | (byArray[n5 + 2] & 0x80) << 3, n2 |= (byArray[n5 + 2] & 0xA0) << 5), 10000, new byte[1].getClass(), f);
                continue;
            }
            int n6 = this.header.getLength();
            this.pos = this.demux.readPacket(this.header, this.trackId, this.pos);
            this.header.setLength(n6);
        }
        if (l != 0L) {
            this.pos = l;
        }
    }

    public void readFrame(Buffer buffer) {
        try {
            byte[] byArray;
            if (!this.parsedHeader) {
                this.parseHeader();
            }
            if ((byArray = (byte[])buffer.getData()) == null || byArray.length < 100000) {
                byArray = new byte[1000000];
                buffer.setData((Object)byArray);
            }
            buffer.setLength(0);
            buffer.setOffset(0);
            boolean bl = false;
            while (!bl) {
                int n = this.demux.peekPacket(this.pos);
                if (n >= 448 && n <= 479 || n >= 480 && n <= 495 || n == 445) {
                    if (n != this.trackId) {
                        this.pos = this.demux.skipDTSPacket(this.pos);
                        continue;
                    }
                    this.pos = this.demux.readDTSHeader(buffer, this.pos);
                    continue;
                }
                if (n == 439) {
                    buffer.setEOM(true);
                }
                if (n == 439 || n == 440) {
                    bl = true;
                    this.pos = this.demux.skipPacket(this.pos);
                    break;
                }
                if (n == 442) {
                    if (this.trackId == n) {
                        this.pos = this.demux.readPacket(buffer, this.trackId, this.pos + 4L);
                        bl = true;
                        continue;
                    }
                    this.pos = this.demux.skipPacket(this.pos);
                    continue;
                }
                if (buffer.getLength() == 0) {
                    byte[] byArray2 = (byte[])buffer.getData();
                    buffer.setLength(this.header.getLength());
                    buffer.setOffset(0);
                    System.arraycopy(this.header.getData(), 0, byArray2, 0, this.header.getLength());
                }
                this.pos = this.demux.readPacket(buffer, this.trackId, this.pos);
            }
            buffer.setFlags(64);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

