/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editorinput;

import java.io.File;
import java.io.InputStream;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.python.pydev.plugin.PydevPlugin;

public class PydevZipFileStorage
implements IStorage {
    private final File zipFile;
    private final String zipPath;

    public PydevZipFileStorage(File zipFile, String zipPath) {
        this.zipFile = zipFile;
        this.zipPath = zipPath;
    }

    public InputStream getContents() throws CoreException {
        try {
            ZipFile f = new ZipFile(this.zipFile);
            return f.getInputStream(f.getEntry(this.zipPath));
        }
        catch (Exception e) {
            throw new CoreException((IStatus)PydevPlugin.makeStatus(4, "Error getting contents from zip file", e));
        }
    }

    public IPath getFullPath() {
        return Path.fromOSString((String)this.zipFile.getAbsolutePath()).append((IPath)new Path(this.zipPath));
    }

    public String getName() {
        return this.zipPath;
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

